/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataFilterChain
implements MetadataFilter {
    private Logger log = LoggerFactory.getLogger(MetadataFilterChain.class);
    private List<MetadataFilter> filters = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XMLObject filter(XMLObject xmlObject) throws FilterException {
        if (xmlObject == null) {
            return null;
        }
        List<MetadataFilter> list = this.filters;
        synchronized (list) {
            if (this.filters == null || this.filters.isEmpty()) {
                this.log.debug("No filters configured, nothing to do");
                return xmlObject;
            }
            XMLObject current = xmlObject;
            for (MetadataFilter filter : this.filters) {
                if (current == null) {
                    return null;
                }
                this.log.debug("Applying filter {}", (Object)filter.getClass().getName());
                current = filter.filter(current);
            }
            return current;
        }
    }

    public List<MetadataFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<MetadataFilter> newFilters) {
        if (newFilters == null || newFilters.isEmpty()) {
            this.filters.clear();
        }
        ArrayList<MetadataFilter> checkedFilters = new ArrayList<MetadataFilter>();
        for (MetadataFilter filter : newFilters) {
            if (filter == null) continue;
            checkedFilters.add(filter);
        }
        this.filters = checkedFilters;
    }
}

