/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.logic;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Predicate;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;

public class EntityIdPredicate
implements Predicate<EntityDescriptor> {
    @Nonnull
    @NonnullElements
    private final Set<String> entityIds;

    public EntityIdPredicate(@Nullable @ParameterName(name="ids") Collection<String> ids) {
        this.entityIds = new HashSet<String>(StringSupport.normalizeStringCollection(ids));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Set<String> getEntityIds() {
        return ImmutableSet.copyOf(this.entityIds);
    }

    public boolean test(@Nullable EntityDescriptor input) {
        if (input == null || input.getEntityID() == null) {
            return false;
        }
        return this.entityIds.contains(input.getEntityID());
    }
}

