/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEvent
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LogEvent.class);
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy = new CurrentOrPreviousEventLookup();
    @Nonnull
    @NotEmpty
    private Set<String> suppressedEvents = Collections.emptySet();

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    public void setSuppressedEvents(@Nullable @NotEmpty Collection<String> events) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.suppressedEvents = events != null ? new HashSet<String>(StringSupport.normalizeStringCollection(events)) : Collections.emptySet();
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        EventContext eventCtx = this.eventContextLookupStrategy.apply(profileRequestContext);
        if (eventCtx == null || eventCtx.getEvent() == null) {
            return;
        }
        String eventString = eventCtx.getEvent().toString();
        if (!this.suppressedEvents.contains(eventString)) {
            this.log.warn("A non-proceed event occurred while processing the request: {}", (Object)eventString);
        }
    }
}

