/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.Prototype;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.LoggerFactory;

@Prototype
public abstract class AbstractMessageHandler<MessageType>
extends AbstractInitializableComponent
implements MessageHandler<MessageType> {
    @Override
    public void invoke(@Nonnull MessageContext<MessageType> messageContext) throws MessageHandlerException {
        Constraint.isNotNull(messageContext, (String)"Message context cannot be null");
        if (this.doPreInvoke(messageContext)) {
            try {
                this.doInvoke(messageContext);
            }
            catch (MessageHandlerException e) {
                try {
                    this.doPostInvoke(messageContext, e);
                }
                catch (Throwable t) {
                    LoggerFactory.getLogger(AbstractMessageHandler.class).warn(this.getLogPrefix() + " Unchecked exception/error thrown by doPostInvoke, " + "superseding a MessageHandlerException ", (Throwable)e);
                    t.addSuppressed(e);
                    throw t;
                }
                throw e;
            }
            catch (Throwable t) {
                try {
                    this.doPostInvoke(messageContext);
                }
                catch (Throwable t2) {
                    LoggerFactory.getLogger(AbstractMessageHandler.class).warn(this.getLogPrefix() + " Unchecked exception/error thrown by doPostInvoke, " + "superseding an unchecked exception/error ", t);
                    t2.addSuppressed(t);
                    throw t2;
                }
                throw t;
            }
            this.doPostInvoke(messageContext);
        }
    }

    protected boolean doPreInvoke(@Nonnull MessageContext<MessageType> messageContext) throws MessageHandlerException {
        return true;
    }

    protected abstract void doInvoke(@Nonnull MessageContext<MessageType> var1) throws MessageHandlerException;

    protected void doPostInvoke(@Nonnull MessageContext<MessageType> messageContext) {
    }

    protected void doPostInvoke(@Nonnull MessageContext<MessageType> messageContext, @Nonnull Exception e) {
        this.doPostInvoke(messageContext);
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        return "Message Handler: ";
    }
}

