/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.notes;

import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.FileMode;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.TreeFormatter;
import org.openrewrite.jgit.util.Paths;

class NonNoteEntry
extends ObjectId {
    private final byte[] name;
    private final FileMode mode;
    NonNoteEntry next;

    NonNoteEntry(byte[] name, FileMode mode, AnyObjectId id) {
        super(id);
        this.name = name;
        this.mode = mode;
    }

    void format(TreeFormatter fmt) {
        fmt.append(this.name, this.mode, (AnyObjectId)this);
    }

    int treeEntrySize() {
        return TreeFormatter.entrySize(this.mode, this.name.length);
    }

    int pathCompare(byte[] bBuf, int bPos, int bLen, FileMode bMode) {
        return Paths.compare(this.name, 0, this.name.length, this.mode.getBits(), bBuf, bPos, bLen, bMode.getBits());
    }
}

