/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.format;

import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.Style;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.format.AutodetectGeneralFormatStyle;
import org.openrewrite.xml.format.LineBreaksVisitor;
import org.openrewrite.xml.format.MinimumViableSpacingVisitor;
import org.openrewrite.xml.format.NormalizeFormatVisitor;
import org.openrewrite.xml.format.NormalizeLineBreaksVisitor;
import org.openrewrite.xml.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.xml.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.xml.format.TabsAndIndentsVisitor;
import org.openrewrite.xml.style.Autodetect;
import org.openrewrite.xml.style.TabsAndIndentsStyle;
import org.openrewrite.xml.tree.Xml;

public class AutoFormatVisitor<P>
extends XmlVisitor<P> {
    private final @Nullable Tree stopAfter;

    public AutoFormatVisitor() {
        this(null);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public Xml visit(@Nullable Tree tree, P p, Cursor cursor) {
        Xml.Document doc = tree instanceof Xml.Document ? (Xml.Document)tree : (Xml.Document)cursor.firstEnclosingOrThrow(Xml.Document.class);
        Xml t = (Xml)new NormalizeFormatVisitor(this.stopAfter).visit(tree, p, cursor.fork());
        t = (Xml)new MinimumViableSpacingVisitor(this.stopAfter).visit(t, p, cursor.fork());
        t = (Xml)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visit(t, p, cursor.fork());
        t = (Xml)new LineBreaksVisitor(this.stopAfter).visit(t, p, cursor.fork());
        TabsAndIndentsStyle tabsStyle = (TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)doc, () -> (TabsAndIndentsStyle)Autodetect.detector().sample((SourceFile)doc).build().getStyle(TabsAndIndentsStyle.class));
        t = (Xml)new NormalizeTabsOrSpacesVisitor(tabsStyle, this.stopAfter).visit(t, p, cursor.fork());
        t = (Xml)new TabsAndIndentsVisitor(tabsStyle, this.stopAfter).visit(t, p, cursor.fork());
        return (Xml)new NormalizeLineBreaksVisitor(Optional.ofNullable((GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)doc)).orElse(AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(doc)), this.stopAfter).visit(t, p, cursor.fork());
    }

    @Override
    public Xml.Document visitDocument(Xml.Document doc, P p) {
        Xml.Document t = (Xml.Document)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visit((Tree)doc, (Object)p);
        t = (Xml.Document)new NormalizeFormatVisitor(this.stopAfter).visit((Tree)t, (Object)p);
        t = (Xml.Document)new MinimumViableSpacingVisitor(this.stopAfter).visit((Tree)t, (Object)p);
        t = (Xml.Document)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visit((Tree)t, (Object)p);
        t = (Xml.Document)new LineBreaksVisitor(this.stopAfter).visit((Tree)t, (Object)p);
        TabsAndIndentsStyle tabsStyle = Optional.ofNullable((TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)doc)).orElseGet(() -> (TabsAndIndentsStyle)Autodetect.detector().sample((SourceFile)doc).build().getStyle(TabsAndIndentsStyle.class));
        assert (tabsStyle != null);
        t = (Xml.Document)new NormalizeTabsOrSpacesVisitor(tabsStyle, this.stopAfter).visit((Tree)t, (Object)p);
        t = (Xml.Document)new TabsAndIndentsVisitor(tabsStyle, this.stopAfter).visit((Tree)t, (Object)p);
        t = (Xml.Document)new NormalizeLineBreaksVisitor(Optional.ofNullable((GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)doc)).orElse(AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(doc)), this.stopAfter).visit((Tree)t, (Object)p);
        assert (t != null);
        return t;
    }
}

