/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.marker.AlreadyReplaced;
import org.openrewrite.marker.Marker;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

@Incubating(since="8.30.0")
public class XsltTransformationVisitor
extends XmlVisitor<ExecutionContext> {
    private final String xslt;

    @Override
    public Xml visitDocument(Xml.Document document, ExecutionContext executionContext) {
        for (Marker marker : document.getMarkers().getMarkers()) {
            AlreadyReplaced alreadyReplaced;
            if (!(marker instanceof AlreadyReplaced) || !Objects.equals(this.xslt, (alreadyReplaced = (AlreadyReplaced)marker).getReplace())) continue;
            return document;
        }
        Xml.Document d = (Xml.Document)super.visitDocument(document, executionContext);
        d = XsltTransformationVisitor.transform(d, this.xslt);
        return d.withMarkers(document.getMarkers().add((Marker)new AlreadyReplaced(Tree.randomId(), null, this.xslt)));
    }

    private static Xml.Document transform(Xml.Document document, String xslt) {
        Xml.Document document2;
        StreamSource xsltSource = new StreamSource(new ByteArrayInputStream(xslt.getBytes()));
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
        String originalDocument = document.printAll();
        StreamSource text = new StreamSource(new ByteArrayInputStream(originalDocument.getBytes()));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            transformer.transform(text, new StreamResult(os));
            document2 = document.withRoot(Xml.Tag.build(os.toString().replace("\r", "")));
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | TransformerException e) {
                throw new RuntimeException("XSLT transformation exception: " + e.getMessage(), e);
            }
        }
        os.close();
        return document2;
    }

    public static Xml.Tag transformTag(@Language(value="xml") String xmlContent, @Language(value="xslt") String xslt) {
        Xml.Tag tag;
        StreamSource xsltSource = new StreamSource(new ByteArrayInputStream(xslt.getBytes()));
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
        StreamSource text = new StreamSource(new ByteArrayInputStream(xmlContent.getBytes()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            transformer.transform(text, new StreamResult(baos));
            tag = Xml.Tag.build(baos.toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | TransformerException e) {
                throw new RuntimeException("XSLT transformation exception: " + e.getMessage(), e);
            }
        }
        baos.close();
        return tag;
    }

    @Generated
    public XsltTransformationVisitor(String xslt) {
        this.xslt = xslt;
    }
}

