/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.openrewrite.CreateFileVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class CreateXmlFile
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="Relative file path", description="File path of new file.", example="foo/bar/baz.xml")
    private final String relativeFileName;
    @Option(displayName="File contents", description="Multiline text content for the file.", example="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>\n    <child>1</child></root>", required=false)
    @Nullable
    @Language(value="xml")
    private final String fileContents;
    @Option(displayName="Overwrite existing file", description="If there is an existing file, should it be overwritten.", required=false)
    @Nullable
    private final Boolean overwriteExisting;

    public String getDisplayName() {
        return "Create XML file";
    }

    public String getDescription() {
        return "Create a new XML file.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(true);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(AtomicBoolean shouldCreate) {
        return new CreateFileVisitor(Paths.get(this.relativeFileName, new String[0]), shouldCreate);
    }

    public Collection<SourceFile> generate(AtomicBoolean shouldCreate, ExecutionContext ctx) {
        if (shouldCreate.get()) {
            return XmlParser.builder().build().parse("").map(brandNewFile -> brandNewFile.withSourcePath(Paths.get(this.relativeFileName, new String[0]))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final AtomicBoolean created) {
        final Path path = Paths.get(this.relativeFileName, new String[0]);
        return new XmlVisitor<ExecutionContext>(){

            @Override
            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                if ((created.get() || Boolean.TRUE.equals(CreateXmlFile.this.overwriteExisting)) && path.equals(document.getSourcePath())) {
                    SourceFile sourceFile;
                    if (StringUtils.isBlank((String)CreateXmlFile.this.fileContents)) {
                        return document.withProlog(null).withRoot(null);
                    }
                    Optional<SourceFile> sourceFiles = XmlParser.builder().build().parse(CreateXmlFile.this.fileContents).findFirst();
                    if (sourceFiles.isPresent() && (sourceFile = sourceFiles.get()) instanceof Xml.Document) {
                        Xml.Document newXmlDocument = (Xml.Document)sourceFile;
                        return document.withProlog(newXmlDocument.getProlog()).withRoot(newXmlDocument.getRoot());
                    }
                }
                return document;
            }
        };
    }

    public CreateXmlFile(String relativeFileName, @Nullable @Language(value="xml") String fileContents, @Nullable Boolean overwriteExisting) {
        this.relativeFileName = relativeFileName;
        this.fileContents = fileContents;
        this.overwriteExisting = overwriteExisting;
    }

    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    @Nullable
    @Language(value="xml")
    public String getFileContents() {
        return this.fileContents;
    }

    @Nullable
    public Boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    @NonNull
    public String toString() {
        return "CreateXmlFile(relativeFileName=" + this.getRelativeFileName() + ", fileContents=" + this.getFileContents() + ", overwriteExisting=" + this.getOverwriteExisting() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateXmlFile)) {
            return false;
        }
        CreateXmlFile other = (CreateXmlFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overwriteExisting = this.getOverwriteExisting();
        Boolean other$overwriteExisting = other.getOverwriteExisting();
        if (this$overwriteExisting == null ? other$overwriteExisting != null : !((Object)this$overwriteExisting).equals(other$overwriteExisting)) {
            return false;
        }
        String this$relativeFileName = this.getRelativeFileName();
        String other$relativeFileName = other.getRelativeFileName();
        if (this$relativeFileName == null ? other$relativeFileName != null : !this$relativeFileName.equals(other$relativeFileName)) {
            return false;
        }
        String this$fileContents = this.getFileContents();
        String other$fileContents = other.getFileContents();
        return !(this$fileContents == null ? other$fileContents != null : !this$fileContents.equals(other$fileContents));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CreateXmlFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overwriteExisting = this.getOverwriteExisting();
        result = result * 59 + ($overwriteExisting == null ? 43 : ((Object)$overwriteExisting).hashCode());
        String $relativeFileName = this.getRelativeFileName();
        result = result * 59 + ($relativeFileName == null ? 43 : $relativeFileName.hashCode());
        String $fileContents = this.getFileContents();
        result = result * 59 + ($fileContents == null ? 43 : $fileContents.hashCode());
        return result;
    }
}

