/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.internal.XmlParserVisitor;
import org.openrewrite.xml.internal.grammar.XMLLexer;
import org.openrewrite.xml.internal.grammar.XMLParser;
import org.openrewrite.xml.tree.Xml;

public class XmlParser
implements Parser<Xml.Document> {
    public List<Xml.Document> parse(List<Path> sourceFiles, @Nullable Path relativeTo) {
        return sourceFiles.stream().map(sourceFile -> {
            try {
                XMLParser parser = new XMLParser((TokenStream)new CommonTokenStream((TokenSource)new XMLLexer(CharStreams.fromPath((Path)sourceFile))));
                return new XmlParserVisitor(relativeTo == null ? sourceFile : relativeTo.relativize((Path)sourceFile), new String(Files.readAllBytes(sourceFile), StandardCharsets.UTF_8)).visitDocument(parser.document());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList());
    }

    public List<Xml.Document> parse(List<String> xmlSources) {
        return xmlSources.stream().map(xmlSource -> {
            XMLParser parser = new XMLParser((TokenStream)new CommonTokenStream((TokenSource)new XMLLexer((CharStream)CharStreams.fromString((String)xmlSource))));
            return new XmlParserVisitor(Paths.get("unknown.xml", new String[0]), (String)xmlSource).visitDocument(parser.document());
        }).collect(Collectors.toList());
    }

    public Xml.Tag parseTag(String tag) {
        XMLParser parser = new XMLParser((TokenStream)new CommonTokenStream((TokenSource)new XMLLexer((CharStream)CharStreams.fromString((String)tag))));
        return (Xml.Tag)new XmlParserVisitor(null, tag).visitContent(parser.content());
    }
}

