/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.ExperimentalPathApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeSerializer;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaParserTest;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0018\u0010\u0006\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/tree/JavaParserTest;", "", "byteArrayAsClasspathElement", "", "jp", "Lorg/openrewrite/java/JavaParser$Builder;", "dependsOn", "relativeSourcePath", "Lorg/openrewrite/java/JavaParser;", "rewrite-test"})
public interface JavaParserTest {
    @Test
    @ExperimentalPathApi
    public void byteArrayAsClasspathElement(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void relativeSourcePath(@NotNull JavaParser var1);

    @Test
    public void dependsOn(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        @ExperimentalPathApi
        public static void byteArrayAsClasspathElement(@NotNull JavaParserTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"junit-jupiter-api"};
            Object object = JavaParser.dependenciesFromClasspath((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dependenciesFromClasspath(\"junit-jupiter-api\")");
            ZipFile zipFile = new ZipFile(((Path)CollectionsKt.first((List)object)).toFile());
            object = zipFile;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ZipFile zip = (ZipFile)object;
                Enumeration<? extends ZipEntry> enumeration = zip.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zip.entries()");
                boolean bl3 = false;
                List classpath2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)byteArrayAsClasspathElement.1.classpath.1.INSTANCE), (Function1)((Function1)new Function1<ZipEntry, byte[]>(zip){
                    final /* synthetic */ ZipFile $zip;
                    {
                        this.$zip = $zip;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public final byte[] invoke(ZipEntry entry) {
                        byte[] byArray;
                        Closeable closeable = this.$zip.getInputStream(entry);
                        boolean bl = false;
                        boolean bl2 = false;
                        Throwable throwable = null;
                        try {
                            InputStream input = (InputStream)closeable;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
                            byArray = ByteStreamsKt.readBytes((InputStream)input);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return byArray;
                    }
                })));
                InMemoryExecutionContext context2 = new InMemoryExecutionContext((Consumer)byteArrayAsClasspathElement.1.context.1.INSTANCE);
                Collection $this$toTypedArray$iv = classpath2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                T[] TArray = thisCollection$iv.toArray((T[])new byte[0][]);
                if (TArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Object object2 = (byte[][])TArray;
                byte[][] byArrayArray = new byte[((Object[])object2).length][];
                System.arraycopy(object2, 0, byArrayArray, 0, ((Object[])object2).length);
                object2 = new String[1];
                object2[0] = (byte[])"class Test {\n    @org.junit.jupiter.api.Test\n    void test() {\n    }\n}";
                List cus = jp.classpath((byte[][])byArrayArray).logCompilationWarningsAndErrors(true).build().parse((ExecutionContext)context2, (String[])object2);
                ListAssert listAssert = (ListAssert)Assertions.assertThat((List)new FindTypes("org.junit.jupiter.api.Test").run(cus)).isNotEmpty();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        @Test
        public static void relativeSourcePath(@NotNull JavaParserTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Path projectDir = Paths.get("/Users/jon/Projects/github/Netflix/eureka", new String[0]);
            Path sourcePath = Paths.get("/Users/jon/Projects/github/Netflix/eureka/eureka-client-archaius2/src/main/java/com/netflix/discovery/EurekaArchaius2ClientConfig.java", new String[0]);
            J.CompilationUnit cu2 = (J.CompilationUnit)jp.parseInputs((Iterable)CollectionsKt.listOf((Object)new Parser.Input(sourcePath, (Supplier)relativeSourcePath.cu.1.INSTANCE)), projectDir, (ExecutionContext)new InMemoryExecutionContext()).get(0);
            Assertions.assertThat((Path)cu2.getSourcePath()).isEqualTo((Object)Paths.get("eureka-client-archaius2/src/main/java/com/netflix/discovery/EurekaArchaius2ClientConfig.java", new String[0]));
            TreeSerializer serializer = new TreeSerializer();
            J.CompilationUnit cu22 = (J.CompilationUnit)serializer.read(serializer.write((SourceFile)cu2));
            Assertions.assertThat((Path)cu22.getSourcePath()).isEqualTo((Object)Paths.get("eureka-client-archaius2/src/main/java/com/netflix/discovery/EurekaArchaius2ClientConfig.java", new String[0]));
        }

        @Test
        public static void dependsOn(@NotNull JavaParserTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    A a;\n}"};
            List cu2 = jp.dependsOn((Collection)Collections.singletonList(Parser.Input.fromString((String)"class A {}"))).build().parse(stringArray);
            Object e = ((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            stringArray = ((J.VariableDeclarations)e).getTypeAsClass();
            Assertions.assertThat((String)(stringArray == null ? null : stringArray.getFullyQualifiedName())).isEqualTo("A");
        }
    }
}

