/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.cleanup.EmptyBlock;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lorg/openrewrite/java/cleanup/EmptyBlockTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "emptyCatchBlockWithExceptionAndEmptyFinally", "", "jp", "Lorg/openrewrite/java/JavaParser;", "emptyCatchBlockWithIOException", "emptyInstanceAndStaticInit", "emptyLoops", "emptySwitch", "emptySynchronized", "emptyTry", "extractSideEffectsFromEmptyIfsWithNoElse", "invertIfWithElseIfElseClause", "invertIfWithOnlyElseClauseAndBinaryOperator", "rewrite-test"})
public interface EmptyBlockTest
extends JavaRecipeTest {
    @Override
    @Nullable
    public Recipe getRecipe();

    @Test
    public void emptySwitch(@NotNull JavaParser var1);

    @Test
    public void emptySynchronized(@NotNull JavaParser var1);

    @Test
    public void emptyTry(@NotNull JavaParser var1);

    @Test
    public void emptyCatchBlockWithIOException(@NotNull JavaParser var1);

    @Test
    public void emptyCatchBlockWithExceptionAndEmptyFinally(@NotNull JavaParser var1);

    @Test
    public void emptyLoops(@NotNull JavaParser var1);

    @Test
    public void emptyInstanceAndStaticInit(@NotNull JavaParser var1);

    @Test
    public void extractSideEffectsFromEmptyIfsWithNoElse(@NotNull JavaParser var1);

    @Test
    public void invertIfWithOnlyElseClauseAndBinaryOperator(@NotNull JavaParser var1);

    @Test
    public void invertIfWithElseIfElseClause(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull EmptyBlockTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new EmptyBlock();
        }

        @Test
        public static void emptySwitch(@NotNull EmptyBlockTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            public class A {\n                {\n                    int i = 0;\n                    switch(i) {\n                    }\n                }\n            }\n        ", null, "\n            public class A {\n                {\n                    int i = 0;\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void emptySynchronized(@NotNull EmptyBlockTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            public class A {\n                {\n                    final Object o = new Object();\n                    synchronized(o) {\n                    }\n                }\n            }\n        ", null, "\n            public class A {\n                {\n                    final Object o = new Object();\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void emptyTry(@NotNull EmptyBlockTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import java.io.*;\n\n            public class A {\n                {\n                    try(FileInputStream fis = new FileInputStream(\"\")) {\n                    } catch (IOException e) {\n                    }\n                }\n            }\n        ", null, "\n            public class A {\n                {\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void emptyCatchBlockWithIOException(@NotNull EmptyBlockTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import java.io.FileInputStream;\n            import java.io.IOException;\n            import java.nio.file.*;\n            \n            public class A {\n                public void foo() {\n                    try {\n                        new FileInputStream(new File(\"somewhere\"));\n                    } catch (IOException e) {\n                    }\n                }\n            }\n        ", null, "\n            import java.io.FileInputStream;\n            import java.io.IOException;\n            import java.io.UncheckedIOException;\n            import java.nio.file.*;\n            \n            public class A {\n                public void foo() {\n                    try {\n                        new FileInputStream(new File(\"somewhere\"));\n                    } catch (IOException e) {\n                        throw new UncheckedIOException(e);\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void emptyCatchBlockWithExceptionAndEmptyFinally(@NotNull EmptyBlockTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import java.nio.file.*;\n            \n            public class A {\n                public void foo() {\n                    try {\n                        new FileInputStream(new File(\"somewhere\"));\n                    } catch (Throwable t) {\n                    } finally {\n                    }\n                }\n            }\n        ", null, "\n            import java.nio.file.*;\n            \n            public class A {\n                public void foo() {\n                    try {\n                        new FileInputStream(new File(\"somewhere\"));\n                    } catch (Throwable t) {\n                        throw new RuntimeException(t);\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void emptyLoops(@NotNull EmptyBlockTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            public class A {\n                public void foo() {\n                    while(true) {\n                    }\n                    do {\n                    } while(true);\n                }\n            }\n        ", null, "\n            public class A {\n                public void foo() {\n                    while(true) {\n                        continue;\n                    }\n                    do {\n                        continue;\n                    } while(true);\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void emptyInstanceAndStaticInit(@NotNull EmptyBlockTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            public class A {\n                static {}\n                {}\n            }\n        ", null, "\n            public class A {\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void extractSideEffectsFromEmptyIfsWithNoElse(@NotNull EmptyBlockTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            public class A {\n                int n = sideEffect();\n            \n                int sideEffect() {\n                    return new java.util.Random().nextInt();\n                }\n            \n                boolean boolSideEffect() {\n                    return sideEffect() == 0;\n                }\n            \n                public void lotsOfIfs() {\n                    if(sideEffect() == 1) {}\n                    if(sideEffect() == sideEffect()) {}\n                    int n;\n                    if((n = sideEffect()) == 1) {}\n                    if((n /= sideEffect()) == 1) {}\n                    if(new A().n == 1) {}\n                    if(!boolSideEffect()) {}\n                    if(1 == 2) {}\n                }\n            }\n        ", null, "\n            public class A {\n                int n = sideEffect();\n            \n                int sideEffect() {\n                    return new java.util.Random().nextInt();\n                }\n            \n                boolean boolSideEffect() {\n                    return sideEffect() == 0;\n                }\n            \n                public void lotsOfIfs() {\n                    sideEffect();\n                    sideEffect();\n                    sideEffect();\n                    int n;\n                    n = sideEffect();\n                    n /= sideEffect();\n                    new A();\n                    boolSideEffect();\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void invertIfWithOnlyElseClauseAndBinaryOperator(@NotNull EmptyBlockTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            public class A {\n                {\n                    if(\"foo\".length() > 3)   {\n                    } else {\n                        System.out.println(\"this\");\n                    }\n                }\n            }\n        ", null, "\n            public class A {\n                {\n                    if(\"foo\".length() <= 3)   {\n                        System.out.println(\"this\");\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void invertIfWithElseIfElseClause(@NotNull EmptyBlockTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            public class A {\n                {\n                    if(\"foo\".length() > 3) {\n                    } else if(\"foo\".length() > 4) {\n                        System.out.println(\"longer\");\n                    }\n                    else {\n                        System.out.println(\"this\");\n                    }\n                }\n            }\n        ", null, "\n            public class A {\n                {\n                    if(\"foo\".length() <= 3) {\n                        if(\"foo\".length() > 4) {\n                            System.out.println(\"longer\");\n                        }\n                        else {\n                            System.out.println(\"this\");\n                        }\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull EmptyBlockTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull EmptyBlockTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull EmptyBlockTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull EmptyBlockTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, after);
        }

        public static void assertChanged(@NotNull EmptyBlockTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, dependsOn, after);
        }

        public static void assertChanged(@NotNull EmptyBlockTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull EmptyBlockTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull EmptyBlockTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull EmptyBlockTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull EmptyBlockTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull EmptyBlockTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertUnchanged(@NotNull EmptyBlockTest this_, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, before);
        }

        public static void assertUnchanged(@NotNull EmptyBlockTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull EmptyBlockTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull EmptyBlockTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull EmptyBlockTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before);
        }

        public static void assertUnchanged(@NotNull EmptyBlockTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, before);
        }

        public static void assertUnchanged(@NotNull EmptyBlockTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull EmptyBlockTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull EmptyBlockTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull EmptyBlockTest this_) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

