/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/tree/CyclicTypeTest;", "", "cyclicType", "", "jp", "Lorg/openrewrite/java/JavaParser;", "cyclicTypeInArray", "genericNesting", "interdependentTypes", "nestedTypes", "rewrite-test"})
public interface CyclicTypeTest {
    @Test
    public void genericNesting(@NotNull JavaParser var1);

    @Test
    public void nestedTypes(@NotNull JavaParser var1);

    @Test
    public void interdependentTypes(@NotNull JavaParser var1);

    @Test
    public void cyclicType(@NotNull JavaParser var1);

    @Test
    public void cyclicTypeInArray(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void genericNesting(CyclicTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            jp.parse("\n            import java.util.*;\n\n            public class A {\n                B b;\n            }\n\n            class B extends G<C> { }\n\n            class C {\n                A a;\n            }\n\n            class G<T> {}\n        ", new String[0]);
        }

        @Test
        public static void nestedTypes(CyclicTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            jp.parse("\n            public class A {\n                B b;\n                public static class B {\n                    A a;\n                }\n            }\n        ", new String[0]);
        }

        @Test
        public static void interdependentTypes(CyclicTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            jp.parse("\n            public class A {\n                B b;\n            }\n\n            class B {\n                A a;\n            }\n        ", new String[0]);
        }

        @Test
        public static void cyclicType(CyclicTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            jp.parse("\n            public class A<T> {\n                A<?> a;\n            }\n        ", new String[0]);
        }

        @Test
        public static void cyclicTypeInArray(CyclicTypeTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                A[] nested = new A[0];\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            JavaType.Array fieldType = TestKt.asArray(((J.VariableDecls.NamedVar)e3).getType());
            Assertions.assertTrue((boolean)(fieldType instanceof JavaType.Array));
            JavaType.Array array = fieldType;
            if (array == null) {
                Intrinsics.throwNpe();
            }
            JavaType.Class elemType = TestKt.asClass(array.getElemType());
            Assertions.assertTrue((boolean)(elemType instanceof JavaType.Class));
            JavaType.Class clazz = elemType;
            if (clazz == null) {
                Intrinsics.throwNpe();
            }
            Object e4 = clazz.getMembers().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e4, (String)"elemType!!.members[0]");
            JavaType javaType = ((JavaType.Var)e4).getType();
            Assertions.assertTrue((boolean)((javaType != null && (javaType = TestKt.asArray(javaType)) != null ? javaType.getElemType() : null) instanceof JavaType.Cyclic));
        }
    }
}

