/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.ChangeLiteral;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.ReorderMethodArguments;
import org.openrewrite.java.ReorderMethodArgumentsTest;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/ReorderMethodArgumentsTest;", "", "refactorReorderArguments", "", "jp", "Lorg/openrewrite/java/JavaParser;", "refactorReorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg", "refactorReorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation", "refactorReorderArgumentsWithNoSourceAttachment", "rewrite-test"})
public interface ReorderMethodArgumentsTest {
    @Test
    public void refactorReorderArguments(@NotNull JavaParser var1);

    @Test
    public void refactorReorderArgumentsWithNoSourceAttachment(@NotNull JavaParser var1);

    @Test
    public void refactorReorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(@NotNull JavaParser var1);

    @Test
    public void refactorReorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void refactorReorderArguments(ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "package a;\npublic class A {\n   public void foo(String s, Integer m, Integer n) {}\n   public void foo(Integer n, Integer m, String s) {}\n}";
            String b = "import a.*;\npublic class B {\n   A a;\n   public void test() {\n       a.foo(\n           \"mystring\",\n           1,\n           2\n       );\n   }\n}";
            J.CompilationUnit cu = jp.parse(b, a);
            List foos = cu.findMethodCalls("a.A foo(..)");
            Refactor refactor = cu.refactor();
            SourceVisitor[] sourceVisitorArray = new SourceVisitor[1];
            Object e = foos.get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"foos[0]");
            J.MethodInvocation.Arguments arguments = ((J.MethodInvocation)e).getArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)arguments, (String)"foos[0].args");
            List list = arguments.getArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"foos[0].args.args");
            sourceVisitorArray[0] = (SourceVisitor)new ChangeLiteral((Expression)CollectionsKt.first((List)list), (Function)refactorReorderArguments.fixed.1.INSTANCE);
            Change change = refactor.visit(sourceVisitorArray).visit(new SourceVisitor[]{(SourceVisitor)new ReorderMethodArguments.Scoped((J.MethodInvocation)foos.get(0), new String[]{"n", "m", "s"}, new String[0])}).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026))\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\n                       2,\n                       1,\n                       \"anotherstring\"\n                   );\n               }\n            }\n        ");
        }

        @Test
        public static void refactorReorderArgumentsWithNoSourceAttachment(ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            package a;\n            public class A {\n               public void foo(String arg0, Integer... arg1) {}\n               public void foo(Integer arg0, Integer arg1, String arg2) {}\n            }\n        ";
            String b = "import a.*;\npublic class B {\n   A a;\n   public void test() {\n       a.foo(\"s\", 0, 1);\n   }\n}";
            J.CompilationUnit cu = jp.parse(b, a);
            ReorderMethodArguments reorderMethodArguments = new ReorderMethodArguments();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = cu.refactor();
            boolean bl = false;
            boolean bl2 = false;
            ReorderMethodArguments $this$apply = reorderMethodArguments;
            boolean bl3 = false;
            $this$apply.setMethod("a.A foo(..)");
            $this$apply.setOrder(new String[]{"n", "s"});
            $this$apply.setOriginalOrder(new String[]{"s", "n"});
            ReorderMethodArguments reorderMethodArguments2 = reorderMethodArguments;
            sourceVisitorArray[n] = (SourceVisitor)reorderMethodArguments2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(0, 1, \"s\");\n               }\n            }\n        ");
        }

        @Test
        public static void refactorReorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            package a;\n            public class A {\n               public void foo(String s, Integer n, Object... o) {}\n               public void bar(String s, Object... o) {}\n            }\n        ";
            String b = "import a.*;\npublic class B {\n   A a;\n   public void test() {\n       a.foo(\"mystring\", 0, \"a\", \"b\");\n   }\n}";
            J.CompilationUnit cu = jp.parse(b, a);
            ReorderMethodArguments reorderMethodArguments = new ReorderMethodArguments();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = cu.refactor();
            boolean bl = false;
            boolean bl2 = false;
            ReorderMethodArguments $this$apply = reorderMethodArguments;
            boolean bl3 = false;
            $this$apply.setMethod("a.A foo(..)");
            $this$apply.setOrder(new String[]{"s", "o", "n"});
            ReorderMethodArguments reorderMethodArguments2 = reorderMethodArguments;
            sourceVisitorArray[n] = (SourceVisitor)reorderMethodArguments2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\"mystring\", \"a\", \"b\", 0);\n               }\n            }\n        ");
        }

        @Test
        public static void refactorReorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            package a;\n            public class A {\n               public void foo(String s, Object... o) {}\n            }\n        ";
            String b = "import a.*;\npublic class B {\n   public void test() {\n       new A().foo(\"mystring\");\n   }\n}";
            J.CompilationUnit cu = jp.parse(b, a);
            ReorderMethodArguments reorderMethodArguments = new ReorderMethodArguments();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = cu.refactor();
            boolean bl = false;
            boolean bl2 = false;
            ReorderMethodArguments $this$apply = reorderMethodArguments;
            boolean bl3 = false;
            $this$apply.setMethod("a.A foo(..)");
            $this$apply.setOrder(new String[]{"o", "s"});
            ReorderMethodArguments reorderMethodArguments2 = reorderMethodArguments;
            sourceVisitorArray[n] = (SourceVisitor)reorderMethodArguments2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import a.*;\n            public class B {\n               public void test() {\n                   new A().foo(\"mystring\");\n               }\n            }\n        ");
        }
    }
}

