/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.MethodMatcherTest;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\bf\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0012"}, d2={"Lorg/openrewrite/java/MethodMatcherTest;", "", "dotDotMatchesArrayArgs", "", "jp", "Lorg/openrewrite/java/JavaParser;", "matchesArguments", "matchesArgumentsWithDotDot", "matchesArgumentsWithWildcards", "matchesArrayArguments", "matchesConstructorUsage", "matchesMethodName", "matchesMethodSymbolsWithVarargs", "matchesMethodTargetType", "matchesSuperclassArgumentTypes", "matchesSuperclassType", "matchesUnqualifiedJavaLangArguments", "Companion", "rewrite-test"})
public interface MethodMatcherTest {
    public static final Companion Companion = org.openrewrite.java.MethodMatcherTest$Companion.$$INSTANCE;

    @Test
    public void matchesSuperclassType(@NotNull JavaParser var1);

    @Test
    public void matchesMethodTargetType(@NotNull JavaParser var1);

    @Test
    public void matchesMethodName(@NotNull JavaParser var1);

    @Test
    public void matchesArguments(@NotNull JavaParser var1);

    @Test
    public void matchesUnqualifiedJavaLangArguments(@NotNull JavaParser var1);

    @Test
    public void matchesArgumentsWithWildcards(@NotNull JavaParser var1);

    @Test
    public void matchesArgumentsWithDotDot(@NotNull JavaParser var1);

    @Test
    public void matchesSuperclassArgumentTypes(@NotNull JavaParser var1);

    @Test
    public void matchesMethodSymbolsWithVarargs(@NotNull JavaParser var1);

    @Test
    public void dotDotMatchesArrayArgs(@NotNull JavaParser var1);

    @Test
    public void matchesArrayArguments(@NotNull JavaParser var1);

    @Test
    public void matchesConstructorUsage(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void matchesSuperclassType(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)new MethodMatcher("Object equals(Object)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.String")));
            Assertions.assertFalse((boolean)new MethodMatcher("String equals(String)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.Object")));
        }

        @Test
        public static void matchesMethodTargetType(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Function1 typeRegex2 = matchesMethodTargetType.typeRegex.1.INSTANCE;
            Assertions.assertTrue((boolean)((Regex)typeRegex2.invoke((Object)"*..MyClass foo()")).matches((CharSequence)"com.bar.MyClass"));
            Assertions.assertTrue((boolean)((Regex)typeRegex2.invoke((Object)"MyClass foo()")).matches((CharSequence)"MyClass"));
            Assertions.assertTrue((boolean)((Regex)typeRegex2.invoke((Object)"com.bar.MyClass foo()")).matches((CharSequence)"com.bar.MyClass"));
            Assertions.assertTrue((boolean)((Regex)typeRegex2.invoke((Object)"com.*.MyClass foo()")).matches((CharSequence)"com.bar.MyClass"));
        }

        @Test
        public static void matchesMethodName(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Function1 nameRegex2 = matchesMethodName.nameRegex.1.INSTANCE;
            Assertions.assertTrue((boolean)((Regex)nameRegex2.invoke((Object)"A foo()")).matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)((Regex)nameRegex2.invoke((Object)"A *()")).matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)((Regex)nameRegex2.invoke((Object)"A fo*()")).matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)((Regex)nameRegex2.invoke((Object)"A *oo()")).matches((CharSequence)"foo"));
        }

        @Test
        public static void matchesArguments(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo()")).matches((CharSequence)""));
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(int)")).matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(java.util.Map)")).matches((CharSequence)"java.util.Map"));
        }

        @Test
        public static void matchesUnqualifiedJavaLangArguments(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(String)")).matches((CharSequence)"java.lang.String"));
        }

        @Test
        public static void matchesArgumentsWithWildcards(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(java.util.*)")).matches((CharSequence)"java.util.Map"));
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(java..*)")).matches((CharSequence)"java.util.Map"));
        }

        @Test
        public static void matchesArgumentsWithDotDot(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(.., int)")).matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(.., int)")).matches((CharSequence)"int,int"));
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(int, ..)")).matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(int, ..)")).matches((CharSequence)"int,int"));
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(..)")).matches((CharSequence)""));
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(..)")).matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(..)")).matches((CharSequence)"int,int"));
        }

        @Test
        public static void matchesSuperclassArgumentTypes(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)new MethodMatcher("Object equals(Object)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.String")));
            Assertions.assertFalse((boolean)new MethodMatcher("String equals(String)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.Object")));
        }

        @Test
        public static void matchesMethodSymbolsWithVarargs(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            ((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(String, Object...)")).matches((CharSequence)"String,Object[]");
        }

        @Test
        public static void dotDotMatchesArrayArgs(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            ((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(..)")).matches((CharSequence)"String,Object[]");
        }

        @Test
        public static void matchesArrayArguments(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)((Regex)org.openrewrite.java.MethodMatcherTest$Companion.access$getArgRegex$p(Companion).invoke((Object)"A foo(String[])")).matches((CharSequence)"java.lang.String[]"));
        }

        @Test
        public static void matchesConstructorUsage(MethodMatcherTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit cu = jp.parse("package a;\n\nclass A { \n    {\n        A a = new A(); \n    }\n}", new String[0]);
            MethodMatcher methodMatcher = new MethodMatcher("a.A A()");
            J.CompilationUnit compilationUnit = cu;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"cu");
            List list = compilationUnit.getClasses();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cu.classes");
            Object object = CollectionsKt.first((List)list);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"cu.classes.first()");
            J.Block block = ((J.ClassDecl)object).getBody();
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"cu.classes.first().body");
            List list2 = block.getStatements();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"cu.classes.first().body.statements");
            Object object2 = CollectionsKt.first((List)list2);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block<*>");
            }
            List list3 = ((J.Block)object2).getStatements();
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"(cu.classes.first().body\u2026              .statements");
            Object object3 = CollectionsKt.first((List)list3);
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            List list4 = ((J.VariableDecls)object3).getVars();
            Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"((cu.classes.first().bod\u2026 as J.VariableDecls).vars");
            Object object4 = CollectionsKt.first((List)list4);
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"((cu.classes.first().bod\u2026riableDecls).vars.first()");
            Expression expression = ((J.VariableDecls.NamedVar)object4).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
            }
            Assertions.assertTrue((boolean)methodMatcher.matches((J.NewClass)expression));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/MethodMatcherTest$Companion;", "", "()V", "argRegex", "Lkotlin/Function1;", "", "Lkotlin/text/Regex;", "rewrite-test"})
    public static final class Companion {
        private static final Function1<String, Regex> argRegex;
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            argRegex = argRegex.1.INSTANCE;
        }

        public static final /* synthetic */ Function1 access$getArgRegex$p(Companion $this) {
            Companion companion = $this;
            return argRegex;
        }
    }
}

