/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.GenerateConstructorUsingFields;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/GenerateConstructorUsingFieldsTest;", "", "emptyListOfFields", "", "jp", "Lorg/openrewrite/java/JavaParser;", "generateConstructorUsingFields", "rewrite-test"})
public interface GenerateConstructorUsingFieldsTest {
    @Test
    public void generateConstructorUsingFields(@NotNull JavaParser var1);

    @Test
    public void emptyListOfFields(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void generateConstructorUsingFields(GenerateConstructorUsingFieldsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("public class UsersController {\n    private final UsersService usersService;\n    private final UsernameService usernameService;\n    \n    public User findUser(String name) {\n    }\n}", new String[0]);
            Refactor refactor = a.refactor();
            SourceVisitor[] sourceVisitorArray = new SourceVisitor[1];
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            J.ClassDecl classDecl = (J.ClassDecl)compilationUnit.getClasses().get(0);
            Object e = a.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            sourceVisitorArray[0] = (SourceVisitor)new GenerateConstructorUsingFields(jp, classDecl, ((J.ClassDecl)e).getFields());
            Change change = refactor.visit(sourceVisitorArray).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor()\n           \u2026))\n                .fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            public class UsersController {\n                private final UsersService usersService;\n                private final UsernameService usernameService;\n            \n                public UsersController(UsersService usersService, UsernameService usernameService) {\n                    this.usersService = usersService;\n                    this.usernameService = usernameService;\n                }\n                \n                public User findUser(String name) {\n                }\n            }\n        ");
        }

        @Test
        public static void emptyListOfFields(GenerateConstructorUsingFieldsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("public class UsersController {\n}", new String[0]);
            Refactor refactor = a.refactor();
            SourceVisitor[] sourceVisitorArray = new SourceVisitor[1];
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            sourceVisitorArray[0] = (SourceVisitor)new GenerateConstructorUsingFields(jp, (J.ClassDecl)compilationUnit.getClasses().get(0), CollectionsKt.emptyList());
            Change change = refactor.visit(sourceVisitorArray).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor()\n           \u2026))\n                .fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            public class UsersController {\n            \n                public UsersController() {\n                }\n            }\n        ");
        }
    }
}

