/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.rpc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.javascript.rpc.InstallRecipesByFile;
import org.openrewrite.javascript.rpc.InstallRecipesByPackage;
import org.openrewrite.javascript.rpc.InstallRecipesResponse;
import org.openrewrite.javascript.rpc.ParseProject;
import org.openrewrite.javascript.rpc.ParseProjectResponse;
import org.openrewrite.marketplace.RecipeMarketplace;
import org.openrewrite.rpc.RewriteRpc;
import org.openrewrite.rpc.RewriteRpcProcess;
import org.openrewrite.rpc.RewriteRpcProcessManager;
import org.openrewrite.rpc.request.PrepareRecipe;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class JavaScriptRewriteRpc
extends RewriteRpc {
    private static final RewriteRpcProcessManager<JavaScriptRewriteRpc> MANAGER = new RewriteRpcProcessManager((Supplier)JavaScriptRewriteRpc.builder());
    private final String command;
    private final Map<String, String> commandEnv;
    private final RewriteRpcProcess process;

    JavaScriptRewriteRpc(RewriteRpcProcess process, RecipeMarketplace marketplace, String command, Map<String, String> commandEnv) {
        super(process.getRpcClient(), marketplace);
        this.command = command;
        this.commandEnv = commandEnv;
        this.process = process;
    }

    public static @Nullable JavaScriptRewriteRpc get() {
        return (JavaScriptRewriteRpc)MANAGER.get();
    }

    public static JavaScriptRewriteRpc getOrStart() {
        return (JavaScriptRewriteRpc)MANAGER.getOrStart();
    }

    public static void setFactory(Builder builder) {
        MANAGER.setFactory((Supplier)builder);
    }

    public void shutdown() {
        super.shutdown();
        this.process.shutdown();
    }

    public static void shutdownCurrent() {
        MANAGER.shutdown();
    }

    public InstallRecipesResponse installRecipes(File recipes) {
        return (InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByFile(recipes.getAbsoluteFile().toPath()), InstallRecipesResponse.class);
    }

    public InstallRecipesResponse installRecipes(String packageName) {
        return this.installRecipes(packageName, null);
    }

    public InstallRecipesResponse installRecipes(String packageName, @Nullable String version) {
        return (InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByPackage(new InstallRecipesByPackage.Package(packageName, version)), InstallRecipesResponse.class);
    }

    public Stream<SourceFile> parseProject(Path projectPath, ExecutionContext ctx) {
        return this.parseProject(projectPath, null, null, ctx);
    }

    public Stream<SourceFile> parseProject(Path projectPath, @Nullable List<String> exclusions, ExecutionContext ctx) {
        return this.parseProject(projectPath, exclusions, null, ctx);
    }

    public Stream<SourceFile> parseProject(final Path projectPath, final @Nullable List<String> exclusions, final @Nullable Path relativeTo, ExecutionContext ctx) {
        final ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return StreamSupport.stream(new Spliterator<SourceFile>(){
            private int index = 0;
            private @Nullable ParseProjectResponse response;

            @Override
            public boolean tryAdvance(Consumer<? super SourceFile> action) {
                if (this.response == null) {
                    parsingListener.intermediateMessage("Starting project parsing: " + projectPath);
                    this.response = (ParseProjectResponse)JavaScriptRewriteRpc.this.send("ParseProject", new ParseProject(projectPath, exclusions, relativeTo), ParseProjectResponse.class);
                    parsingListener.intermediateMessage(String.format("Discovered %,d files to parse", this.response.size()));
                }
                if (this.index >= this.response.size()) {
                    return false;
                }
                ParseProjectResponse.Item item = (ParseProjectResponse.Item)this.response.get(this.index);
                ++this.index;
                SourceFile sourceFile = (SourceFile)JavaScriptRewriteRpc.this.getObject(item.getId(), item.getSourceFileType());
                action.accept((SourceFile)sourceFile);
                return true;
            }

            @Override
            public @Nullable Spliterator<SourceFile> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return this.response == null ? Long.MAX_VALUE : (long)(this.response.size() - this.index);
            }

            @Override
            public int characteristics() {
                return this.response == null ? 16 : 16464;
            }
        }, false);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public Map<String, String> getCommandEnv() {
        return this.commandEnv;
    }

    @Generated
    public RewriteRpcProcess getProcess() {
        return this.process;
    }

    public static class Builder
    implements Supplier<JavaScriptRewriteRpc> {
        private RecipeMarketplace marketplace = new RecipeMarketplace();
        private final Map<String, String> environment = new HashMap<String, String>();
        private Path npxPath = Paths.get("npx", new String[0]);
        private @Nullable Path log;
        private @Nullable Path metricsCsv;
        private @Nullable Path recipeInstallDir;
        private Duration timeout = Duration.ofSeconds(30L);
        private boolean traceRpcMessages;
        private @Nullable Integer inspectBrk;
        private @Nullable Path inspectBrkRewriteSourcePath;
        private @Nullable Integer maxHeapSize;
        private @Nullable Path workingDirectory;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable PrepareRecipe.Loader recipeLoader;

        public Builder marketplace(RecipeMarketplace marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public Builder recipeInstallDir(@Nullable Path recipeInstallDir) {
            this.recipeInstallDir = recipeInstallDir;
            return this;
        }

        public Builder npxPath(Path npxPath) {
            if (Files.notExists(npxPath, new LinkOption[0]) || Files.isDirectory(npxPath, new LinkOption[0])) {
                throw new IllegalArgumentException("Invalid npx executable " + npxPath.toAbsolutePath().normalize());
            }
            this.npxPath = npxPath;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder log(@Nullable Path log) {
            this.log = log;
            return this;
        }

        public Builder metricsCsv(@Nullable Path metricsCsv) {
            this.metricsCsv = metricsCsv;
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.environment.putAll(environment);
            return this;
        }

        public Builder traceRpcMessages(boolean verboseLogging) {
            this.traceRpcMessages = verboseLogging;
            return this;
        }

        public Builder traceRpcMessages() {
            return this.traceRpcMessages(true);
        }

        public Builder inspectBrk(Path rewriteSourcePath, int inspectBrk) {
            this.inspectBrk = inspectBrk;
            this.inspectBrkRewriteSourcePath = rewriteSourcePath;
            return this;
        }

        public Builder inspectBrk(Path rewriteDistPath) {
            return this.inspectBrk(rewriteDistPath, 9229);
        }

        public Builder maxHeapSize(@Nullable Integer maxHeapSize) {
            this.maxHeapSize = maxHeapSize;
            return this;
        }

        public Builder workingDirectory(@Nullable Path workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder recipeLoader(PrepareRecipe.Loader recipeLoader) {
            this.recipeLoader = recipeLoader;
            return this;
        }

        @Override
        public JavaScriptRewriteRpc get() {
            Stream<String> cmd;
            if (this.inspectBrk != null) {
                Path serverJs = Objects.requireNonNull(this.inspectBrkRewriteSourcePath).resolve("dist/rpc/server.js");
                cmd = Stream.of("node", "--enable-source-maps", "--inspect-brk=" + this.inspectBrk, this.maxHeapSize != null ? "--max-old-space-size=" + this.maxHeapSize : null, serverJs.toAbsolutePath().normalize().toString(), this.log == null ? null : "--log-file=" + this.log.toAbsolutePath().normalize(), this.traceRpcMessages ? "--trace-rpc-messages" : null, this.recipeInstallDir == null ? null : "--recipe-install-dir=" + this.recipeInstallDir.toAbsolutePath().normalize());
            } else {
                String version = StringUtils.readFully((InputStream)this.getClass().getResourceAsStream("/META-INF/version.txt"));
                cmd = Stream.of(this.npxPath.toString(), version.endsWith("-SNAPSHOT") ? null : "--package=@openrewrite/rewrite@" + version, "rewrite-rpc", this.log == null ? null : "--log-file=" + this.log.toAbsolutePath().normalize(), this.metricsCsv == null ? null : "--metrics-csv=" + this.metricsCsv.toAbsolutePath().normalize(), this.traceRpcMessages ? "--trace-rpc-messages" : null, this.recipeInstallDir == null ? null : "--recipe-install-dir=" + this.recipeInstallDir.toAbsolutePath().normalize());
            }
            CharSequence[] cmdArr = (String[])cmd.filter(Objects::nonNull).toArray(String[]::new);
            RewriteRpcProcess process = new RewriteRpcProcess((String[])cmdArr);
            if (this.workingDirectory != null) {
                process.setWorkingDirectory(this.workingDirectory);
            }
            StringBuilder nodeOptions = new StringBuilder("--enable-source-maps");
            if (this.inspectBrk == null && this.maxHeapSize != null) {
                nodeOptions.append(" --max-old-space-size=").append(this.maxHeapSize);
            }
            process.environment().putAll(this.environment);
            process.environment().put("NODE_OPTIONS", nodeOptions.toString());
            if (this.npxPath.getParent() != null) {
                process.environment().put("PATH", this.npxPath.getParent() + File.pathSeparator + System.getenv("PATH"));
            }
            process.start();
            try {
                return (JavaScriptRewriteRpc)new JavaScriptRewriteRpc(process, this.marketplace, String.join((CharSequence)" ", cmdArr), process.environment()).livenessCheck(() -> ((RewriteRpcProcess)process).getLivenessCheck()).timeout(this.timeout).log(this.log == null ? null : new PrintStream(Files.newOutputStream(this.log, StandardOpenOption.APPEND, StandardOpenOption.CREATE))).recipeLoader(this.recipeLoader);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Generated
        public Builder() {
        }
    }
}

