/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.rpc.RpcCodec;
import org.openrewrite.rpc.RpcReceiveQueue;
import org.openrewrite.rpc.RpcSendQueue;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class Autodetect
extends NamedStyles
implements RpcCodec<Autodetect> {
    private static final String NAME = "org.openrewrite.javascript.Autodetect";
    private static final String DISPLAY_NAME = "Auto-detected";
    private static final String DESCRIPTION = "Automatically detect styles from a repository's existing code.";

    @JsonCreator
    public Autodetect(UUID id, Collection<Style> styles) {
        super(id, NAME, DISPLAY_NAME, DESCRIPTION, Collections.emptySet(), styles);
    }

    public Autodetect withId(UUID id) {
        return id == this.getId() ? this : new Autodetect(id, this.getStyles());
    }

    public Autodetect withStyles(Collection<Style> styles) {
        return styles == this.getStyles() ? this : new Autodetect(this.getId(), styles);
    }

    private static List<Style> stylesAsList(Autodetect a) {
        Collection styles = a.getStyles();
        return styles == null ? Collections.emptyList() : new ArrayList(styles);
    }

    public void rpcSend(Autodetect after, RpcSendQueue q) {
        q.getAndSend((Object)after, NamedStyles::getId);
        q.getAndSendList((Object)after, Autodetect::stylesAsList, s -> s.getClass().getName(), null);
    }

    public Autodetect rpcReceive(Autodetect before, RpcReceiveQueue q) {
        return before.withId((UUID)q.receiveAndGet((Object)before.getId(), UUID::fromString)).withStyles((Collection)q.receiveList(Autodetect.stylesAsList(before), null));
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Autodetect)) {
            return false;
        }
        Autodetect other = (Autodetect)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Autodetect;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

