/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.javascript.marker.NodeResolutionResult;
import org.openrewrite.javascript.table.NodeDependenciesInUse;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonKey;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class DependencyInsight
extends Recipe {
    private final transient NodeDependenciesInUse dependenciesInUse = new NodeDependenciesInUse(this);
    @Option(displayName="Package name pattern", description="A glob pattern to match npm package names. Use `*` as a wildcard.", example="@types/*")
    private final String packageNamePattern;
    @Option(displayName="Scope", description="Match dependencies in the specified scope. All scopes are searched by default.", valid={"dependencies", "devDependencies", "peerDependencies", "optionalDependencies", "bundledDependencies"}, example="dependencies", required=false)
    private final @Nullable String scope;
    @Option(displayName="Only direct", description="If enabled, transitive dependencies will not be considered. All dependencies are searched by default.", required=false, example="true")
    private final @Nullable Boolean onlyDirect;

    public String getDisplayName() {
        return "Node.js dependency insight";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s`", this.packageNamePattern);
    }

    public String getDescription() {
        return "Find direct and transitive npm dependencies matching a package name pattern. Results include dependencies that either directly match or transitively include a matching dependency.";
    }

    public Validated<Object> validate() {
        Validated v = super.validate();
        if (this.scope != null) {
            HashSet<String> validScopes = new HashSet<String>(Arrays.asList("dependencies", "devDependencies", "peerDependencies", "optionalDependencies", "bundledDependencies"));
            v = v.and(Validated.test((String)"scope", (String)"scope is a valid npm dependency scope", (Object)this.scope, validScopes::contains));
        }
        return v;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern packageNameMatcher = DependencyInsight.compileGlobPattern(this.packageNamePattern);
        return new JsonIsoVisitor<ExecutionContext>(){
            private @Nullable NodeResolutionResult resolution;
            private @Nullable String currentSection;
            private final Map<String, MatchInfo> matchedPackages = new HashMap<String, MatchInfo>();

            public Json.Document visitDocument(Json.Document document, ExecutionContext ctx) {
                if (!document.getSourcePath().toString().endsWith("package.json")) {
                    return document;
                }
                Optional nodeResolution = document.getMarkers().findFirst(NodeResolutionResult.class);
                if (!nodeResolution.isPresent()) {
                    return document;
                }
                this.resolution = (NodeResolutionResult)nodeResolution.get();
                this.matchedPackages.clear();
                Json.Document result = super.visitDocument(document, (Object)ctx);
                for (MatchInfo match : this.matchedPackages.values()) {
                    DependencyInsight.this.dependenciesInUse.insertRow(ctx, new NodeDependenciesInUse.Row(this.resolution.getName(), this.resolution.getPath(), match.packageName, match.version, match.versionConstraint, match.scope, match.direct, match.count, match.license));
                }
                return result;
            }

            public Json.Member visitMember(Json.Member member, ExecutionContext ctx) {
                NodeResolutionResult.Dependency dep;
                Json.Member m = super.visitMember(member, (Object)ctx);
                if (this.resolution == null) {
                    return m;
                }
                String keyName = this.getKeyName(m.getKey());
                if (keyName == null) {
                    return m;
                }
                if (this.isDependencySection(keyName)) {
                    String previousSection = this.currentSection;
                    this.currentSection = keyName;
                    m = super.visitMember(member, (Object)ctx);
                    this.currentSection = previousSection;
                    return m;
                }
                if (this.currentSection != null && (DependencyInsight.this.scope == null || DependencyInsight.this.scope.equals(this.currentSection)) && (dep = this.findDependency(keyName, this.currentSection)) != null) {
                    Set<String> transitiveMatches;
                    if (packageNameMatcher.matcher(keyName).matches()) {
                        this.recordMatch(dep, this.currentSection, true);
                        return this.markKey(m);
                    }
                    if (!Boolean.TRUE.equals(DependencyInsight.this.onlyDirect) && dep.getResolved() != null && !(transitiveMatches = this.findTransitiveMatches(dep.getResolved(), new HashSet<String>())).isEmpty()) {
                        for (String transitiveName : transitiveMatches) {
                            this.recordTransitiveMatch(transitiveName);
                        }
                        return this.markKey(m);
                    }
                }
                return m;
            }

            private boolean isDependencySection(String name) {
                return "dependencies".equals(name) || "devDependencies".equals(name) || "peerDependencies".equals(name) || "optionalDependencies".equals(name) || "bundledDependencies".equals(name);
            }

            private @Nullable String getKeyName(JsonKey key) {
                if (key instanceof Json.Literal) {
                    String source = ((Json.Literal)key).getSource();
                    if (source.startsWith("\"") && source.endsWith("\"")) {
                        return source.substring(1, source.length() - 1);
                    }
                    return source;
                }
                if (key instanceof Json.Identifier) {
                    return ((Json.Identifier)key).getName();
                }
                return null;
            }

            private @Nullable NodeResolutionResult.Dependency findDependency(String name, String section) {
                if (this.resolution == null) {
                    return null;
                }
                List<NodeResolutionResult.Dependency> deps = null;
                switch (section) {
                    case "dependencies": {
                        deps = this.resolution.getDependencies();
                        break;
                    }
                    case "devDependencies": {
                        deps = this.resolution.getDevDependencies();
                        break;
                    }
                    case "peerDependencies": {
                        deps = this.resolution.getPeerDependencies();
                        break;
                    }
                    case "optionalDependencies": {
                        deps = this.resolution.getOptionalDependencies();
                        break;
                    }
                    case "bundledDependencies": {
                        deps = this.resolution.getBundledDependencies();
                    }
                }
                if (deps == null) {
                    return null;
                }
                for (NodeResolutionResult.Dependency dep : deps) {
                    if (!name.equals(dep.getName())) continue;
                    return dep;
                }
                return null;
            }

            private Set<String> findTransitiveMatches(NodeResolutionResult.ResolvedDependency resolved, Set<String> visited) {
                String key = resolved.getName() + "@" + resolved.getVersion();
                if (visited.contains(key)) {
                    return Collections.emptySet();
                }
                visited.add(key);
                HashSet<String> matches = new HashSet<String>();
                ArrayList<NodeResolutionResult.Dependency> allDeps = new ArrayList<NodeResolutionResult.Dependency>();
                if (resolved.getDependencies() != null) {
                    allDeps.addAll(resolved.getDependencies());
                }
                if (resolved.getDevDependencies() != null) {
                    allDeps.addAll(resolved.getDevDependencies());
                }
                if (resolved.getPeerDependencies() != null) {
                    allDeps.addAll(resolved.getPeerDependencies());
                }
                if (resolved.getOptionalDependencies() != null) {
                    allDeps.addAll(resolved.getOptionalDependencies());
                }
                for (NodeResolutionResult.Dependency dep : allDeps) {
                    if (packageNameMatcher.matcher(dep.getName()).matches()) {
                        matches.add(dep.getName());
                    }
                    if (dep.getResolved() == null) continue;
                    matches.addAll(this.findTransitiveMatches(dep.getResolved(), visited));
                }
                return matches;
            }

            private void recordMatch(NodeResolutionResult.Dependency dep, String section, boolean direct) {
                MatchInfo existing = this.matchedPackages.get(dep.getName());
                if (existing != null) {
                    existing.incrementCount();
                    return;
                }
                NodeResolutionResult.ResolvedDependency resolved = dep.getResolved();
                String resolvedVersion = resolved != null ? resolved.getVersion() : dep.getVersionConstraint();
                String license = resolved != null ? resolved.getLicense() : null;
                this.matchedPackages.put(dep.getName(), new MatchInfo(dep.getName(), resolvedVersion, dep.getVersionConstraint(), section, direct, license));
            }

            private void recordTransitiveMatch(String packageName) {
                MatchInfo existing = this.matchedPackages.get(packageName);
                if (existing != null) {
                    existing.incrementCount();
                    return;
                }
                if (this.resolution != null && this.resolution.getResolvedDependencies() != null) {
                    for (NodeResolutionResult.ResolvedDependency resolved : this.resolution.getResolvedDependencies()) {
                        if (!packageName.equals(resolved.getName())) continue;
                        this.matchedPackages.put(packageName, new MatchInfo(packageName, resolved.getVersion(), null, "transitive", false, resolved.getLicense()));
                        return;
                    }
                }
                this.matchedPackages.put(packageName, new MatchInfo(packageName, null, null, "transitive", false, null));
            }

            private Json.Member markKey(Json.Member member) {
                JsonKey key = member.getKey();
                JsonKey markedKey = (JsonKey)key.withMarkers(key.getMarkers().addIfAbsent((Marker)new SearchResult(Tree.randomId(), null)));
                return member.withKey(markedKey);
            }
        };
    }

    private static Pattern compileGlobPattern(String glob) {
        StringBuilder regex = new StringBuilder("^");
        block5: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    regex.append(".*");
                    continue block5;
                }
                case '?': {
                    regex.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    regex.append("\\").append(c);
                    continue block5;
                }
                default: {
                    regex.append(c);
                }
            }
        }
        regex.append("$");
        return Pattern.compile(regex.toString());
    }

    @Generated
    public DependencyInsight(String packageNamePattern, @Nullable String scope, @Nullable Boolean onlyDirect) {
        this.packageNamePattern = packageNamePattern;
        this.scope = scope;
        this.onlyDirect = onlyDirect;
    }

    @Generated
    public NodeDependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    @Generated
    public String getPackageNamePattern() {
        return this.packageNamePattern;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable Boolean getOnlyDirect() {
        return this.onlyDirect;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyInsight(dependenciesInUse=" + (Object)((Object)this.getDependenciesInUse()) + ", packageNamePattern=" + this.getPackageNamePattern() + ", scope=" + this.getScope() + ", onlyDirect=" + this.getOnlyDirect() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyInsight)) {
            return false;
        }
        DependencyInsight other = (DependencyInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$onlyDirect = this.getOnlyDirect();
        Boolean other$onlyDirect = other.getOnlyDirect();
        if (this$onlyDirect == null ? other$onlyDirect != null : !((Object)this$onlyDirect).equals(other$onlyDirect)) {
            return false;
        }
        String this$packageNamePattern = this.getPackageNamePattern();
        String other$packageNamePattern = other.getPackageNamePattern();
        if (this$packageNamePattern == null ? other$packageNamePattern != null : !this$packageNamePattern.equals(other$packageNamePattern)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyInsight;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $onlyDirect = this.getOnlyDirect();
        result = result * 59 + ($onlyDirect == null ? 43 : ((Object)$onlyDirect).hashCode());
        String $packageNamePattern = this.getPackageNamePattern();
        result = result * 59 + ($packageNamePattern == null ? 43 : $packageNamePattern.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    private static class MatchInfo {
        final String packageName;
        final @Nullable String version;
        final @Nullable String versionConstraint;
        final String scope;
        final boolean direct;
        int count;
        final @Nullable String license;

        MatchInfo(String packageName, @Nullable String version, @Nullable String versionConstraint, String scope, boolean direct, @Nullable String license) {
            this.packageName = packageName;
            this.version = version;
            this.versionConstraint = versionConstraint;
            this.scope = scope;
            this.direct = direct;
            this.count = 1;
            this.license = license;
        }

        void incrementCount() {
            ++this.count;
        }
    }
}

