/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Parser;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.javascript.DependencyWorkspace;
import org.openrewrite.javascript.JavaScriptParser;
import org.openrewrite.javascript.PackageJsonParser;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.json.tree.Json;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

public class Assertions {
    private Assertions() {
    }

    public static SourceSpecs npm(Path relativeTo, SourceSpecs ... sources) {
        String packageJsonContent = null;
        for (SourceSpecs multiSpec : sources) {
            SourceSpec spec;
            Path sourcePath;
            if (!(multiSpec instanceof SourceSpec) || (sourcePath = (spec = (SourceSpec)multiSpec).getSourcePath()) == null || !"package.json".equals(sourcePath.toFile().getName())) continue;
            packageJsonContent = spec.getBefore();
            try {
                Path packageJson = relativeTo.resolve(sourcePath);
                Files.write(packageJson, Objects.requireNonNull(packageJsonContent).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                break;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (packageJsonContent != null) {
            Path workspaceDir = DependencyWorkspace.getOrCreateWorkspace(packageJsonContent);
            Path nodeModulesSource = workspaceDir.resolve("node_modules");
            Path nodeModulesTarget = relativeTo.resolve("node_modules");
            Path lockFileSource = workspaceDir.resolve("package-lock.json");
            Path lockFileTarget = relativeTo.resolve("package-lock.json");
            try {
                if (Files.exists(nodeModulesSource, new LinkOption[0]) && !Files.exists(nodeModulesTarget, new LinkOption[0])) {
                    Files.createSymbolicLink(nodeModulesTarget, nodeModulesSource, new FileAttribute[0]);
                }
                if (Files.exists(lockFileSource, new LinkOption[0]) && !Files.exists(lockFileTarget, new LinkOption[0])) {
                    Files.createSymbolicLink(lockFileTarget, lockFileSource, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create symlink for node_modules", e);
            }
        }
        return SourceSpecs.dir((String)relativeTo.toString(), (SourceSpecs[])sources);
    }

    public static SourceSpecs packageJson(@Language(value="json5") @Nullable String before) {
        return Assertions.packageJson(before, (SourceSpec<Json.Document> s) -> {});
    }

    public static SourceSpecs packageJson(@Language(value="json5") @Nullable String before, Consumer<SourceSpec<Json.Document>> spec) {
        SourceSpec json = new SourceSpec(Json.Document.class, null, (Parser.Builder)PackageJsonParser.builder(), before, SourceSpec.ValidateSource.noop, ctx -> {});
        json.path("package.json");
        spec.accept((SourceSpec<Json.Document>)json);
        return json;
    }

    public static SourceSpecs packageJson(@Language(value="json5") @Nullable String before, @Language(value="json5") @Nullable String after) {
        return Assertions.packageJson(before, after, s -> {});
    }

    public static SourceSpecs packageJson(@Language(value="json5") @Nullable String before, @Language(value="json5") @Nullable String after, Consumer<SourceSpec<Json.Document>> spec) {
        SourceSpec json = new SourceSpec(Json.Document.class, null, (Parser.Builder)PackageJsonParser.builder(), before, SourceSpec.ValidateSource.noop, ctx -> {});
        json.path("package.json");
        json.after(s -> after);
        spec.accept((SourceSpec<Json.Document>)json);
        return json;
    }

    public static SourceSpecs javascript(@Language(value="js") @Nullable String before) {
        return Assertions.javascript(before, (SourceSpec<JS.CompilationUnit> s) -> {});
    }

    public static SourceSpecs javascript(@Language(value="js") @Nullable String before, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        SourceSpec js = new SourceSpec(JS.CompilationUnit.class, null, (Parser.Builder)JavaScriptParser.builder(), before, SourceSpec.ValidateSource.noop, ctx -> {});
        Assertions.acceptSpec(spec, (SourceSpec<JS.CompilationUnit>)js);
        return js;
    }

    public static SourceSpecs javascript(@Language(value="js") @Nullable String before, @Language(value="js") @Nullable String after) {
        return Assertions.javascript(before, after, s -> {});
    }

    public static SourceSpecs javascript(@Language(value="js") @Nullable String before, @Language(value="js") @Nullable String after, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        SourceSpec js = new SourceSpec(JS.CompilationUnit.class, null, (Parser.Builder)JavaScriptParser.builder(), before, SourceSpec.ValidateSource.noop, ctx -> {}).after(s -> after);
        Assertions.acceptSpec(spec, (SourceSpec<JS.CompilationUnit>)js);
        return js;
    }

    public static SourceSpecs jsx(@Language(value="jsx") @Nullable String before) {
        return Assertions.javascript(before, (SourceSpec<JS.CompilationUnit> s) -> {});
    }

    public static SourceSpecs jsx(@Language(value="jsx") @Nullable String before, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.javascript(before, (SourceSpec<JS.CompilationUnit> spec2) -> {
            spec2.path(System.nanoTime() + ".jsx");
            spec.accept((SourceSpec<JS.CompilationUnit>)spec2);
        });
    }

    public static SourceSpecs jsx(@Language(value="jsx") @Nullable String before, @Language(value="jsx") @Nullable String after) {
        return Assertions.javascript(before, after, s -> {});
    }

    public static SourceSpecs jsx(@Language(value="jsx") @Nullable String before, @Language(value="jsx") @Nullable String after, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.javascript(before, after, spec2 -> {
            spec2.path(System.nanoTime() + ".jsx");
            spec.accept((SourceSpec<JS.CompilationUnit>)spec2);
        });
    }

    public static SourceSpecs typescript(@Language(value="ts") @Nullable String before) {
        return Assertions.typescript(before, (SourceSpec<JS.CompilationUnit> s) -> {});
    }

    public static SourceSpecs typescript(@Language(value="ts") @Nullable String before, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.javascript(before, (SourceSpec<JS.CompilationUnit> spec2) -> {
            spec2.path(System.nanoTime() + ".ts");
            spec.accept((SourceSpec<JS.CompilationUnit>)spec2);
        });
    }

    public static SourceSpecs typescript(@Language(value="ts") @Nullable String before, @Language(value="ts") @Nullable String after) {
        return Assertions.typescript(before, after, s -> {});
    }

    public static SourceSpecs typescript(@Language(value="ts") @Nullable String before, @Language(value="ts") @Nullable String after, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.javascript(before, after, spec2 -> {
            spec2.path(System.nanoTime() + ".tsx");
            spec.accept((SourceSpec<JS.CompilationUnit>)spec2);
        });
    }

    public static SourceSpecs tsx(@Language(value="tsx") @Nullable String before) {
        return Assertions.typescript(before, (SourceSpec<JS.CompilationUnit> s) -> {});
    }

    public static SourceSpecs tsx(@Language(value="tsx") @Nullable String before, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.typescript(before, (SourceSpec<JS.CompilationUnit> spec2) -> {
            spec2.path(System.nanoTime() + ".tsx");
            spec.accept((SourceSpec<JS.CompilationUnit>)spec2);
        });
    }

    public static SourceSpecs tsx(@Language(value="tsx") @Nullable String before, @Language(value="tsx") @Nullable String after) {
        return Assertions.tsx(before, after, s -> {});
    }

    public static SourceSpecs tsx(@Language(value="tsx") @Nullable String before, @Language(value="tsx") @Nullable String after, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.typescript(before, after, spec2 -> {
            spec2.path(System.nanoTime() + ".tsx");
            spec.accept((SourceSpec<JS.CompilationUnit>)spec2);
        });
    }

    private static void acceptSpec(Consumer<SourceSpec<JS.CompilationUnit>> spec, SourceSpec<JS.CompilationUnit> js) {
        ThrowingConsumer userSuppliedAfterRecipe = js.getAfterRecipe();
        js.afterRecipe(((Consumer)userSuppliedAfterRecipe)::accept);
        spec.accept(js);
    }
}

