/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.rpc;

import io.moderne.jsonrpc.JsonRpc;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.config.Environment;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.javascript.rpc.InstallRecipesByFile;
import org.openrewrite.javascript.rpc.InstallRecipesByPackage;
import org.openrewrite.javascript.rpc.InstallRecipesResponse;
import org.openrewrite.rpc.RewriteRpc;
import org.openrewrite.rpc.RewriteRpcProcess;
import org.openrewrite.rpc.RewriteRpcProcessManager;

public class JavaScriptRewriteRpc
extends RewriteRpc {
    private static final RewriteRpcProcessManager<JavaScriptRewriteRpc> MANAGER = new RewriteRpcProcessManager((Supplier)JavaScriptRewriteRpc.builder());

    JavaScriptRewriteRpc(JsonRpc jsonRpc, Environment marketplace) {
        super(jsonRpc, marketplace);
    }

    public static JavaScriptRewriteRpc getOrStart() {
        return (JavaScriptRewriteRpc)MANAGER.getOrStart();
    }

    public static void setFactory(Builder builder) {
        MANAGER.setFactory((Supplier)builder);
    }

    public static void shutdownCurrent() {
        MANAGER.shutdown();
    }

    public int installRecipes(File recipes) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByFile(recipes), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    public int installRecipes(String packageName) {
        return this.installRecipes(packageName, null);
    }

    public int installRecipes(String packageName, @Nullable String version) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByPackage(new InstallRecipesByPackage.Package(packageName, version)), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Supplier<JavaScriptRewriteRpc> {
        private Environment marketplace = Environment.builder().build();
        private Path npxPath = Paths.get("npx", new String[0]);
        private @Nullable Path log;
        private @Nullable Path recipeInstallDir;
        private Duration timeout = Duration.ofSeconds(30L);
        private boolean verboseLogging;
        private @Nullable Integer inspectBrk;
        private boolean profiler;
        private @Nullable Integer maxHeapSize;
        private @Nullable Path workingDirectory;

        public Builder marketplace(Environment marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public Builder recipeInstallDir(@Nullable Path recipeInstallDir) {
            this.recipeInstallDir = recipeInstallDir;
            return this;
        }

        public Builder npxPath(Path npxPath) {
            if (Files.notExists(npxPath, new LinkOption[0]) || Files.isDirectory(npxPath, new LinkOption[0])) {
                throw new IllegalArgumentException("Invalid npx executable " + npxPath.toAbsolutePath().normalize());
            }
            this.npxPath = npxPath;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder log(@Nullable Path log) {
            this.log = log;
            return this;
        }

        public Builder verboseLogging(boolean verboseLogging) {
            this.verboseLogging = verboseLogging;
            return this;
        }

        public Builder verboseLogging() {
            return this.verboseLogging(true);
        }

        public Builder inspectBrk(@Nullable Integer inspectBrk) {
            this.inspectBrk = inspectBrk;
            return this;
        }

        public Builder inspectBrk() {
            return this.inspectBrk(9229);
        }

        public Builder profiler(boolean profiler) {
            this.profiler = profiler;
            return this;
        }

        public Builder profiler() {
            return this.profiler(true);
        }

        public Builder maxHeapSize(@Nullable Integer maxHeapSize) {
            this.maxHeapSize = maxHeapSize;
            return this;
        }

        public Builder workingDirectory(@Nullable Path workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        @Override
        public JavaScriptRewriteRpc get() {
            Stream<String> cmd;
            if (this.inspectBrk != null) {
                Path serverJs = Paths.get("rewrite/dist/rpc/server.js", new String[0]);
                if (!Files.exists(serverJs, new LinkOption[0])) {
                    serverJs = Paths.get("node_modules/@openrewrite/rewrite/dist/rpc/server.js", new String[0]);
                }
                cmd = Stream.of("node", "--enable-source-maps", "--inspect-brk=" + this.inspectBrk, this.profiler ? "--prof" : null, this.maxHeapSize != null ? "--max-old-space-size=" + this.maxHeapSize : null, serverJs.toAbsolutePath().normalize().toString(), this.log == null ? null : "--log-file=" + this.log.toAbsolutePath().normalize(), this.verboseLogging ? "--verbose" : null, this.recipeInstallDir == null ? null : "--recipe-install-dir=" + this.recipeInstallDir.toAbsolutePath().normalize().toString());
            } else {
                String version = StringUtils.readFully((InputStream)this.getClass().getResourceAsStream("/META-INF/version.txt"));
                cmd = Stream.of(this.npxPath.toString(), version.endsWith("-SNAPSHOT") ? null : "--package=@openrewrite/rewrite@" + version, "rewrite-rpc", this.log == null ? null : "--log-file=" + this.log.toAbsolutePath().normalize(), this.verboseLogging ? "--verbose" : null, this.recipeInstallDir == null ? null : "--recipe-install-dir=" + this.recipeInstallDir.toAbsolutePath().normalize().toString(), this.profiler ? "--profile" : null);
            }
            RewriteRpcProcess process = new RewriteRpcProcess((String[])cmd.filter(Objects::nonNull).toArray(String[]::new));
            if (this.workingDirectory != null) {
                process.setWorkingDirectory(this.workingDirectory);
            }
            StringBuilder nodeOptions = new StringBuilder("--enable-source-maps");
            if (this.inspectBrk == null && this.maxHeapSize != null) {
                nodeOptions.append(" --max-old-space-size=").append(this.maxHeapSize);
            }
            process.environment().put("NODE_OPTIONS", nodeOptions.toString());
            process.start();
            return (JavaScriptRewriteRpc)new JavaScriptRewriteRpc(process.getRpcClient(), this.marketplace).livenessCheck(() -> ((RewriteRpcProcess)process).getLivenessCheck()).timeout(this.timeout);
        }

        @Generated
        public Builder() {
        }
    }
}

