/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.rpc;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.moderne.jsonrpc.JsonRpc;
import io.moderne.jsonrpc.formatter.JsonMessageFormatter;
import io.moderne.jsonrpc.formatter.MessageFormatter;
import io.moderne.jsonrpc.handler.HeaderDelimitedMessageHandler;
import io.moderne.jsonrpc.handler.MessageHandler;
import io.moderne.jsonrpc.handler.TraceMessageHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.config.Environment;
import org.openrewrite.internal.ManagedThreadLocal;
import org.openrewrite.javascript.rpc.InstallRecipesByFile;
import org.openrewrite.javascript.rpc.InstallRecipesByPackage;
import org.openrewrite.javascript.rpc.InstallRecipesResponse;
import org.openrewrite.rpc.RewriteRpc;

public class JavaScriptRewriteRpc
extends RewriteRpc {
    private final CloseableSupplier<JsonRpc> supplier;
    private static final ManagedThreadLocal<JavaScriptRewriteRpc> THREAD_LOCAL = new ManagedThreadLocal();

    private JavaScriptRewriteRpc(CloseableSupplier<JsonRpc> supplier, Environment marketplace, Duration timeout) {
        super((JsonRpc)supplier.get(), marketplace, timeout);
        this.supplier = supplier;
    }

    public static ManagedThreadLocal<JavaScriptRewriteRpc> current() {
        return THREAD_LOCAL;
    }

    public void close() {
        super.close();
        this.supplier.close();
    }

    public int installRecipes(File recipes) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByFile(recipes), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    public int installRecipes(String packageName) {
        return this.installRecipes(packageName, null);
    }

    public int installRecipes(String packageName, @Nullable String version) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByPackage(new InstallRecipesByPackage.Package(packageName, version)), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    public static Builder bundledInstallation(Environment marketplace) {
        return JavaScriptRewriteRpc.builder(marketplace);
    }

    public static Builder bundledInstallation(Environment marketplace, Path installationDirectory) {
        return JavaScriptRewriteRpc.builder(marketplace).installationDirectory(JavaScriptRewriteRpc.extractBundledInstallation(installationDirectory));
    }

    public static Builder builder(Environment marketplace) {
        return new Builder(marketplace);
    }

    private static Path extractBundledInstallation(Path extractionDirectory) {
        try {
            InputStream packageStream;
            Files.createDirectories(extractionDirectory, new FileAttribute[0]);
            boolean needsCleanup = JavaScriptRewriteRpc.shouldCleanExtractionDirectory(extractionDirectory);
            if (needsCleanup && Files.exists(extractionDirectory, new LinkOption[0])) {
                try (Stream<Path> stream = Files.walk(extractionDirectory, new FileVisitOption[0]);){
                    stream.sorted(Comparator.reverseOrder()).filter(path -> !path.equals(extractionDirectory)).map(Path::toFile).forEach(File::delete);
                }
            }
            if ((packageStream = JavaScriptRewriteRpc.class.getResourceAsStream("/production-package.zip")) == null) {
                throw new IllegalStateException("production-package.zip not found in resources");
            }
            try (ZipInputStream zipIn = new ZipInputStream(packageStream);){
                ZipEntry entry;
                while ((entry = zipIn.getNextEntry()) != null) {
                    if (!entry.isDirectory()) {
                        Path outputPath = extractionDirectory.resolve(entry.getName());
                        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                        Files.copy(zipIn, outputPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    zipIn.closeEntry();
                }
            }
            return extractionDirectory.resolve("node_modules/@openrewrite/rewrite/dist");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean shouldCleanExtractionDirectory(Path extractionDirectory) throws IOException {
        String existingPackageJsonContent;
        Path existingPackageJson = extractionDirectory.resolve("package.json");
        if (!Files.exists(existingPackageJson, new LinkOption[0])) {
            return false;
        }
        String bundledPackageJsonContent = JavaScriptRewriteRpc.getBundledPackageJsonContent();
        return !bundledPackageJsonContent.equals(existingPackageJsonContent = new String(Files.readAllBytes(existingPackageJson), StandardCharsets.UTF_8));
    }

    private static String getBundledPackageJsonContent() throws IOException {
        InputStream packageStream = JavaScriptRewriteRpc.class.getResourceAsStream("/production-package.zip");
        if (packageStream == null) {
            throw new IllegalStateException("package.json not found in resources");
        }
        try (ZipInputStream zipIn = new ZipInputStream(packageStream);){
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                if ("package.json".equals(entry.getName())) {
                    int byteCount;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    byte[] data = new byte[4096];
                    while ((byteCount = zipIn.read(data, 0, data.length)) != -1) {
                        buffer.write(data, 0, byteCount);
                    }
                    String string = new String(buffer.toByteArray(), StandardCharsets.UTF_8);
                    return string;
                }
                zipIn.closeEntry();
            }
        }
        throw new IllegalStateException("package.json not found in resources");
    }

    private static JsonRpc createRpcClient(InputStream inputStream, OutputStream outputStream, boolean trace) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Path.class, (JsonSerializer)new PathSerializer());
        module.addDeserializer(Path.class, (JsonDeserializer)new PathDeserializer());
        JsonMessageFormatter formatter = new JsonMessageFormatter(new Module[]{module});
        HeaderDelimitedMessageHandler handler = new HeaderDelimitedMessageHandler((MessageFormatter)formatter, inputStream, outputStream);
        if (trace) {
            handler = new TraceMessageHandler("client", (MessageHandler)handler);
        }
        return new JsonRpc((MessageHandler)handler);
    }

    private static interface CloseableSupplier<T>
    extends Supplier<T>,
    AutoCloseable {
        @Override
        public void close();
    }

    public static class Builder
    extends RewriteRpc.Builder<Builder> {
        private static volatile @Nullable Path bundledInstallationDirectory;
        private Path nodePath = Paths.get("node", new String[0]);
        private @Nullable Path installationDirectory;
        private int inspectPort;
        private int port;
        private boolean trace;
        private @Nullable Path logFile;

        private Builder(Environment marketplace) {
            super(marketplace);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Path getBundledInstallationDirectory() {
            if (bundledInstallationDirectory != null) return Objects.requireNonNull(bundledInstallationDirectory);
            Class<Builder> clazz = Builder.class;
            synchronized (Builder.class) {
                if (bundledInstallationDirectory != null) return Objects.requireNonNull(bundledInstallationDirectory);
                bundledInstallationDirectory = Builder.initializeBundledInstallationDirectory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return Objects.requireNonNull(bundledInstallationDirectory);
            }
        }

        private static Path initializeBundledInstallationDirectory() {
            try {
                Path tempDir = Files.createTempDirectory("javascript-rewrite-rpc", new FileAttribute[0]);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try (Stream<Path> stream = Files.walk(tempDir, new FileVisitOption[0]);){
                        stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }));
                return JavaScriptRewriteRpc.extractBundledInstallation(tempDir);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public Builder nodePath(Path nodePath) {
            this.nodePath = nodePath;
            return this;
        }

        public Builder installationDirectory(Path installationDirectory) {
            this.installationDirectory = installationDirectory;
            return this;
        }

        public Builder inspectAndBreak() {
            return this.inspectAndBreak(9229);
        }

        public Builder inspectAndBreak(int port) {
            this.inspectPort = port;
            return this;
        }

        public Builder socket(int port) {
            this.port = port;
            return this;
        }

        public Builder trace(boolean trace) {
            this.trace = trace;
            return this;
        }

        public Builder logFile(Path logFile) {
            this.logFile = logFile;
            return this;
        }

        public JavaScriptRewriteRpc build() {
            JavaScriptRewriteRpc rewriteRpc;
            if (this.port != 0) {
                rewriteRpc = new JavaScriptRewriteRpc(new CloseableSupplier<JsonRpc>(){
                    private Socket socket;

                    @Override
                    public JsonRpc get() {
                        try {
                            this.socket = new Socket("127.0.0.1", port);
                            return JavaScriptRewriteRpc.createRpcClient(this.socket.getInputStream(), this.socket.getOutputStream(), trace);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }

                    @Override
                    public void close() {
                        try {
                            this.socket.close();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }, this.marketplace, this.timeout);
            } else {
                Path effectiveInstallationDirectory = this.installationDirectory != null ? this.installationDirectory : Builder.getBundledInstallationDirectory();
                final ArrayList<String> command = new ArrayList<String>(Arrays.asList(this.nodePath.toString(), "--stack-size=4000", "--enable-source-maps"));
                if (this.inspectPort != 0) {
                    command.add("--inspect-brk=" + this.inspectPort);
                }
                command.add(effectiveInstallationDirectory.resolve("src/rpc/server.js").toString());
                if (this.logFile != null) {
                    command.add("--log-file=" + this.logFile);
                }
                rewriteRpc = new JavaScriptRewriteRpc(new CloseableSupplier<JsonRpc>(){
                    private @Nullable JavaScriptRewriteRpcProcess process;

                    @Override
                    public JsonRpc get() {
                        this.process = new JavaScriptRewriteRpcProcess(trace, command.toArray(new String[0]));
                        this.process.start();
                        return Objects.requireNonNull(this.process.rpcClient);
                    }

                    @Override
                    public void close() {
                        if (this.process != null) {
                            this.process.interrupt();
                            try {
                                this.process.join();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }, this.marketplace, this.timeout);
            }
            return rewriteRpc;
        }
    }

    private static class PathSerializer
    extends JsonSerializer<Path> {
        private PathSerializer() {
        }

        public void serialize(Path path, JsonGenerator g, SerializerProvider serializerProvider) throws IOException {
            g.writeString(path.toString());
        }
    }

    private static class PathDeserializer
    extends JsonDeserializer<Path> {
        private PathDeserializer() {
        }

        public Path deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String pathString = p.getValueAsString();
            return Paths.get(pathString, new String[0]);
        }
    }

    private static class JavaScriptRewriteRpcProcess
    extends Thread {
        private final boolean trace;
        private final String[] command;
        private @Nullable Process process;
        private @Nullable JsonRpc rpcClient;

        public JavaScriptRewriteRpcProcess(boolean trace, String ... command) {
            this.trace = trace;
            this.command = command;
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                ProcessBuilder pb = new ProcessBuilder(this.command);
                this.process = pb.start();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public synchronized void start() {
            super.start();
            while (this.process == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.rpcClient = JavaScriptRewriteRpc.createRpcClient(this.process.getInputStream(), this.process.getOutputStream(), this.trace);
        }

        @Generated
        public @Nullable JsonRpc getRpcClient() {
            return this.rpcClient;
        }
    }
}

