/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.rpc;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.java.internal.rpc.JavaReceiver;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.javascript.JavaScriptVisitor;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.JSX;
import org.openrewrite.rpc.RpcReceiveQueue;

public class JavaScriptReceiver
extends JavaScriptVisitor<RpcReceiveQueue> {
    private final JavaScriptReceiverDelegate delegate = new JavaScriptReceiverDelegate(this);

    public @Nullable J visit(@Nullable Tree tree, RpcReceiveQueue p) {
        if (tree instanceof JS) {
            return (J)super.visit(tree, (Object)p);
        }
        return this.delegate.visit(tree, p);
    }

    public J preVisit(J j, RpcReceiveQueue q) {
        if (j instanceof JS.ExpressionStatement || j instanceof JS.StatementExpression) {
            return (J)j.withId((UUID)q.receiveAndGet((Object)j.getId(), UUID::fromString));
        }
        return (J)((J)j.withId((UUID)q.receiveAndGet((Object)j.getId(), UUID::fromString))).withPrefix((Space)q.receive((Object)j.getPrefix(), space -> this.visitSpace((Space)space, q))).withMarkers(q.receiveMarkers(j.getMarkers()));
    }

    @Override
    public J visitJsCompilationUnit(JS.CompilationUnit cu, RpcReceiveQueue q) {
        return ((JS.CompilationUnit)cu.withSourcePath((Path)q.receiveAndGet((Object)cu.getSourcePath(), x$0 -> Paths.get(x$0, new String[0]))).withCharset((Charset)q.receiveAndGet((Object)cu.getCharset(), Charset::forName)).withCharsetBomMarked(((Boolean)q.receive((Object)cu.isCharsetBomMarked())).booleanValue()).withChecksum((Checksum)q.receive((Object)cu.getChecksum())).withFileAttributes((FileAttributes)q.receive((Object)cu.getFileAttributes()))).getPadding().withStatements(q.receiveList(cu.getPadding().getStatements(), stmt -> this.visitRightPadded((JRightPadded)stmt, q))).withEof((Space)q.receive((Object)cu.getEof(), space -> this.visitSpace((Space)space, q)));
    }

    @Override
    public J visitAlias(JS.Alias alias, RpcReceiveQueue q) {
        return alias.getPadding().withPropertyName((JRightPadded<J.Identifier>)((JRightPadded)q.receive(alias.getPadding().getPropertyName(), el -> this.visitRightPadded((JRightPadded)el, q)))).withAlias((Expression)q.receive((Object)alias.getAlias(), expr -> (Expression)this.visitNonNull((Tree)expr, q)));
    }

    @Override
    public J visitArrowFunction(JS.ArrowFunction arrowFunction, RpcReceiveQueue q) {
        return arrowFunction.withLeadingAnnotations(q.receiveList(arrowFunction.getLeadingAnnotations(), annot -> (J.Annotation)this.visitNonNull((Tree)annot, q))).withModifiers(q.receiveList(arrowFunction.getModifiers(), mod -> (J.Modifier)this.visitNonNull((Tree)mod, q))).withTypeParameters((J.TypeParameters)q.receive((Object)arrowFunction.getTypeParameters(), params -> (J.TypeParameters)this.visitNonNull((Tree)params, q))).withLambda((J.Lambda)q.receive((Object)arrowFunction.getLambda(), tree -> (J.Lambda)this.visitNonNull((Tree)tree, q))).withReturnTypeExpression((TypeTree)q.receive((Object)arrowFunction.getReturnTypeExpression(), tree -> (TypeTree)this.visitNonNull((Tree)tree, q)));
    }

    @Override
    public J visitAwait(JS.Await await, RpcReceiveQueue q) {
        return await.withExpression((Expression)q.receive((Object)await.getExpression(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).withType((JavaType)q.receive((Object)await.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitConditionalType(JS.ConditionalType conditionalType, RpcReceiveQueue q) {
        return conditionalType.withCheckType((Expression)q.receive((Object)conditionalType.getCheckType(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).getPadding().withCondition((JLeftPadded<J.Ternary>)((JLeftPadded)q.receive(conditionalType.getPadding().getCondition(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withType((JavaType)q.receive((Object)conditionalType.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitDelete(JS.Delete delete, RpcReceiveQueue q) {
        return delete.withExpression((Expression)q.receive((Object)delete.getExpression(), expr -> (Expression)this.visitNonNull((Tree)expr, q)));
    }

    @Override
    public J visitExpressionStatement(JS.ExpressionStatement expressionStatement, RpcReceiveQueue q) {
        return expressionStatement.withExpression((Expression)q.receive((Object)expressionStatement.getExpression(), expr -> (Expression)this.visitNonNull((Tree)expr, q)));
    }

    @Override
    public J visitExpressionWithTypeArguments(JS.ExpressionWithTypeArguments expressionWithTypeArguments, RpcReceiveQueue q) {
        return expressionWithTypeArguments.withClazz((J)q.receive((Object)expressionWithTypeArguments.getClazz(), el -> (J)this.visitNonNull((Tree)el, q))).getPadding().withTypeArguments((JContainer<Expression>)((JContainer)q.receive(expressionWithTypeArguments.getPadding().getTypeArguments(), el -> this.visitContainer((JContainer)el, q)))).withType((JavaType)q.receive((Object)expressionWithTypeArguments.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitFunctionType(JS.FunctionType functionType, RpcReceiveQueue q) {
        return functionType.withModifiers(q.receiveList(functionType.getModifiers(), mod -> (J.Modifier)this.visitNonNull((Tree)mod, q))).getPadding().withConstructorType((JLeftPadded<Boolean>)((JLeftPadded)q.receive(functionType.getPadding().getConstructorType(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withTypeParameters((J.TypeParameters)q.receive((Object)functionType.getTypeParameters(), params -> (J.TypeParameters)this.visitNonNull((Tree)params, q))).getPadding().withParameters((JContainer<Statement>)((JContainer)q.receive(functionType.getPadding().getParameters(), el -> this.visitContainer((JContainer)el, q)))).getPadding().withReturnType((JLeftPadded<Expression>)((JLeftPadded)q.receive(functionType.getPadding().getReturnType(), el -> this.visitLeftPadded((JLeftPadded)el, q))));
    }

    @Override
    public J visitInferType(JS.InferType inferType, RpcReceiveQueue q) {
        return inferType.getPadding().withTypeParameter((JLeftPadded<J>)((JLeftPadded)q.receive(inferType.getPadding().getTypeParameter(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withType((JavaType)q.receive((Object)inferType.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitImportType(JS.ImportType importType, RpcReceiveQueue q) {
        return importType.getPadding().withHasTypeof((JRightPadded<Boolean>)((JRightPadded)q.receive(importType.getPadding().getHasTypeof(), el -> this.visitRightPadded((JRightPadded)el, q)))).getPadding().withArgumentAndAttributes((JContainer<J>)((JContainer)q.receive(importType.getPadding().getArgumentAndAttributes(), el -> this.visitContainer((JContainer)el, q)))).getPadding().withQualifier((JLeftPadded<Expression>)((JLeftPadded)q.receive(importType.getPadding().getQualifier(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).getPadding().withTypeArguments((JContainer<Expression>)((JContainer)q.receive(importType.getPadding().getTypeArguments(), el -> this.visitContainer((JContainer)el, q)))).withType((JavaType)q.receive((Object)importType.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitImportDeclaration(JS.Import anImport, RpcReceiveQueue q) {
        return anImport.withImportClause((JS.ImportClause)q.receive((Object)anImport.getImportClause(), el -> (JS.ImportClause)this.visitNonNull((Tree)el, q))).getPadding().withModuleSpecifier((JLeftPadded<Expression>)((JLeftPadded)q.receive(anImport.getPadding().getModuleSpecifier(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withAttributes((JS.ImportAttributes)q.receive((Object)anImport.getAttributes(), el -> (JS.ImportAttributes)this.visitNonNull((Tree)el, q))).getPadding().withInitializer((JLeftPadded<Expression>)((JLeftPadded)q.receive(anImport.getPadding().getInitializer(), el -> this.visitLeftPadded((JLeftPadded)el, q))));
    }

    @Override
    public J visitImportClause(JS.ImportClause importClause, RpcReceiveQueue q) {
        return importClause.withTypeOnly((Boolean)q.receive((Object)importClause.isTypeOnly())).getPadding().withName((JRightPadded<J.Identifier>)((JRightPadded)q.receive(importClause.getPadding().getName(), el -> this.visitRightPadded((JRightPadded)el, q)))).withNamedBindings((Expression)q.receive((Object)importClause.getNamedBindings(), expr -> (Expression)this.visitNonNull((Tree)expr, q)));
    }

    @Override
    public J visitNamedImports(JS.NamedImports namedImports, RpcReceiveQueue q) {
        return namedImports.getPadding().withElements((JContainer<JS.ImportSpecifier>)((JContainer)q.receive(namedImports.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q)))).withType((JavaType)q.receive((Object)namedImports.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitImportSpecifier(JS.ImportSpecifier importSpecifier, RpcReceiveQueue q) {
        return importSpecifier.getPadding().withImportType((JLeftPadded<Boolean>)((JLeftPadded)q.receive(importSpecifier.getPadding().getImportType(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withSpecifier((Expression)q.receive((Object)importSpecifier.getSpecifier(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).withType((JavaType)q.receive((Object)importSpecifier.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitImportAttributes(JS.ImportAttributes importAttributes, RpcReceiveQueue q) {
        return importAttributes.withToken((JS.ImportAttributes.Token)((Object)q.receiveAndGet((Object)importAttributes.getToken(), RpcReceiveQueue.toEnum(JS.ImportAttributes.Token.class)))).getPadding().withElements((JContainer<Statement>)((JContainer)q.receive(importAttributes.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q))));
    }

    @Override
    public J visitImportTypeAttributes(JS.ImportTypeAttributes importTypeAttributes, RpcReceiveQueue q) {
        return importTypeAttributes.getPadding().withToken((JRightPadded<Expression>)((JRightPadded)q.receive(importTypeAttributes.getPadding().getToken(), el -> this.visitRightPadded((JRightPadded)el, q)))).getPadding().withElements((JContainer<JS.ImportAttribute>)((JContainer)q.receive(importTypeAttributes.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q)))).withEnd((Space)q.receive((Object)importTypeAttributes.getEnd(), space -> this.visitSpace((Space)space, q)));
    }

    @Override
    public J visitImportAttribute(JS.ImportAttribute importAttribute, RpcReceiveQueue q) {
        return importAttribute.withName((Expression)q.receive((Object)importAttribute.getName(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).getPadding().withValue((JLeftPadded<Expression>)((JLeftPadded)q.receive(importAttribute.getPadding().getValue(), el -> this.visitLeftPadded((JLeftPadded)el, q))));
    }

    @Override
    public J visitBinaryExtensions(JS.Binary binary, RpcReceiveQueue q) {
        return binary.withLeft((Expression)q.receive((Object)binary.getLeft(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).getPadding().withOperator((JLeftPadded<JS.Binary.Type>)((JLeftPadded)q.receive(binary.getPadding().getOperator(), el -> this.visitLeftPadded((JLeftPadded)el, q, RpcReceiveQueue.toEnum(JS.Binary.Type.class))))).withRight((Expression)q.receive((Object)binary.getRight(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).withType((JavaType)q.receive((Object)binary.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitLiteralType(JS.LiteralType literalType, RpcReceiveQueue q) {
        return literalType.withLiteral((Expression)q.receive((Object)literalType.getLiteral(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).withType((JavaType)q.receive((Object)literalType.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitMappedType(JS.MappedType mappedType, RpcReceiveQueue q) {
        return mappedType.getPadding().withPrefixToken((JLeftPadded<J.Literal>)((JLeftPadded)q.receive(mappedType.getPadding().getPrefixToken(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).getPadding().withHasReadonly((JLeftPadded<Boolean>)((JLeftPadded)q.receive(mappedType.getPadding().getHasReadonly(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withKeysRemapping((JS.MappedType.KeysRemapping)q.receive((Object)mappedType.getKeysRemapping(), el -> (JS.MappedType.KeysRemapping)this.visitNonNull((Tree)el, q))).getPadding().withSuffixToken((JLeftPadded<J.Literal>)((JLeftPadded)q.receive(mappedType.getPadding().getSuffixToken(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).getPadding().withHasQuestionToken((JLeftPadded<Boolean>)((JLeftPadded)q.receive(mappedType.getPadding().getHasQuestionToken(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).getPadding().withValueType((JContainer<TypeTree>)((JContainer)q.receive(mappedType.getPadding().getValueType(), el -> this.visitContainer((JContainer)el, q)))).withType((JavaType)q.receive((Object)mappedType.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitMappedTypeKeysRemapping(JS.MappedType.KeysRemapping keysRemapping, RpcReceiveQueue q) {
        return keysRemapping.getPadding().withTypeParameter((JRightPadded<JS.MappedType.Parameter>)((JRightPadded)q.receive(keysRemapping.getPadding().getTypeParameter(), el -> this.visitRightPadded((JRightPadded)el, q)))).getPadding().withNameType((JRightPadded<Expression>)((JRightPadded)q.receive(keysRemapping.getPadding().getNameType(), el -> this.visitRightPadded((JRightPadded)el, q))));
    }

    @Override
    public J visitMappedTypeParameter(JS.MappedType.Parameter mappedTypeParameter, RpcReceiveQueue q) {
        return mappedTypeParameter.withName((Expression)q.receive((Object)mappedTypeParameter.getName(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).getPadding().withIterateType((JLeftPadded<TypeTree>)((JLeftPadded)q.receive(mappedTypeParameter.getPadding().getIterateType(), el -> this.visitLeftPadded((JLeftPadded)el, q))));
    }

    @Override
    public J visitObjectBindingPattern(JS.ObjectBindingPattern objectBindingPattern, RpcReceiveQueue q) {
        return objectBindingPattern.withLeadingAnnotations(q.receiveList(objectBindingPattern.getLeadingAnnotations(), annot -> (J.Annotation)this.visitNonNull((Tree)annot, q))).withModifiers(q.receiveList(objectBindingPattern.getModifiers(), mod -> (J.Modifier)this.visitNonNull((Tree)mod, q))).withTypeExpression((TypeTree)q.receive((Object)objectBindingPattern.getTypeExpression(), tree -> (TypeTree)this.visitNonNull((Tree)tree, q))).getPadding().withBindings((JContainer<J>)((JContainer)q.receive(objectBindingPattern.getPadding().getBindings(), el -> this.visitContainer((JContainer)el, q)))).getPadding().withInitializer((JLeftPadded<Expression>)((JLeftPadded)q.receive(objectBindingPattern.getPadding().getInitializer(), el -> this.visitLeftPadded((JLeftPadded)el, q))));
    }

    @Override
    public J visitPropertyAssignment(JS.PropertyAssignment propertyAssignment, RpcReceiveQueue q) {
        return propertyAssignment.getPadding().withName((JRightPadded<Expression>)((JRightPadded)q.receive(propertyAssignment.getPadding().getName(), el -> this.visitRightPadded((JRightPadded)el, q)))).withAssigmentToken((JS.PropertyAssignment.AssigmentToken)((Object)q.receiveAndGet((Object)propertyAssignment.getAssigmentToken(), RpcReceiveQueue.toEnum(JS.PropertyAssignment.AssigmentToken.class)))).withInitializer((Expression)q.receive((Object)propertyAssignment.getInitializer(), expr -> (Expression)this.visitNonNull((Tree)expr, q)));
    }

    @Override
    public J visitSatisfiesExpression(JS.SatisfiesExpression satisfiesExpression, RpcReceiveQueue q) {
        return satisfiesExpression.withExpression((J)q.receive((Object)satisfiesExpression.getExpression(), el -> (J)this.visitNonNull((Tree)el, q))).getPadding().withSatisfiesType((JLeftPadded<Expression>)((JLeftPadded)q.receive(satisfiesExpression.getPadding().getSatisfiesType(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withType((JavaType)q.receive((Object)satisfiesExpression.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitScopedVariableDeclarations(JS.ScopedVariableDeclarations scopedVariableDeclarations, RpcReceiveQueue q) {
        return scopedVariableDeclarations.withModifiers(q.receiveList(scopedVariableDeclarations.getModifiers(), mod -> (J.Modifier)this.visitNonNull((Tree)mod, q))).getPadding().withVariables(q.receiveList(scopedVariableDeclarations.getPadding().getVariables(), el -> this.visitRightPadded((JRightPadded)el, q)));
    }

    @Override
    public J visitStatementExpression(JS.StatementExpression statementExpression, RpcReceiveQueue q) {
        return statementExpression.withStatement((Statement)q.receive((Object)statementExpression.getStatement(), stmt -> (Statement)this.visitNonNull((Tree)stmt, q)));
    }

    @Override
    public J visitTaggedTemplateExpression(JS.TaggedTemplateExpression taggedTemplateExpression, RpcReceiveQueue q) {
        return taggedTemplateExpression.getPadding().withTag((JRightPadded<Expression>)((JRightPadded)q.receive(taggedTemplateExpression.getPadding().getTag(), el -> this.visitRightPadded((JRightPadded)el, q)))).getPadding().withTypeArguments((JContainer<Expression>)((JContainer)q.receive(taggedTemplateExpression.getPadding().getTypeArguments(), el -> this.visitContainer((JContainer)el, q)))).withTemplateExpression((Expression)q.receive((Object)taggedTemplateExpression.getTemplateExpression(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).withType((JavaType)q.receive((Object)taggedTemplateExpression.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitTemplateExpression(JS.TemplateExpression templateExpression, RpcReceiveQueue q) {
        return templateExpression.withHead((J.Literal)q.receive((Object)templateExpression.getHead(), lit -> (J.Literal)this.visitNonNull((Tree)lit, q))).getPadding().withSpans(q.receiveList(templateExpression.getPadding().getSpans(), el -> this.visitRightPadded((JRightPadded)el, q))).withType((JavaType)q.receive((Object)templateExpression.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitTemplateExpressionSpan(JS.TemplateExpression.Span span, RpcReceiveQueue q) {
        return span.withExpression((J)q.receive((Object)span.getExpression(), el -> (J)this.visitNonNull((Tree)el, q))).withTail((J.Literal)q.receive((Object)span.getTail(), lit -> (J.Literal)this.visitNonNull((Tree)lit, q)));
    }

    @Override
    public J visitTrailingTokenStatement(JS.TrailingTokenStatement trailingTokenStatement, RpcReceiveQueue q) {
        return trailingTokenStatement.getPadding().withExpression((JRightPadded<J>)((JRightPadded)q.receive(trailingTokenStatement.getPadding().getExpression(), el -> this.visitRightPadded((JRightPadded)el, q)))).withType((JavaType)q.receive((Object)trailingTokenStatement.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitTuple(JS.Tuple tuple, RpcReceiveQueue q) {
        return tuple.getPadding().withElements((JContainer<J>)((JContainer)q.receive(tuple.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q)))).withType((JavaType)q.receive((Object)tuple.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitTypeDeclaration(JS.TypeDeclaration typeDeclaration, RpcReceiveQueue q) {
        return typeDeclaration.withModifiers(q.receiveList(typeDeclaration.getModifiers(), mod -> (J.Modifier)this.visitNonNull((Tree)mod, q))).getPadding().withName((JLeftPadded<J.Identifier>)((JLeftPadded)q.receive(typeDeclaration.getPadding().getName(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withTypeParameters((J.TypeParameters)q.receive((Object)typeDeclaration.getTypeParameters(), params -> (J.TypeParameters)this.visitNonNull((Tree)params, q))).getPadding().withInitializer((JLeftPadded<Expression>)((JLeftPadded)q.receive(typeDeclaration.getPadding().getInitializer(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withType((JavaType)q.receive((Object)typeDeclaration.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitTypeOf(JS.TypeOf typeOf, RpcReceiveQueue q) {
        return typeOf.withExpression((Expression)q.receive((Object)typeOf.getExpression(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).withType((JavaType)q.receive((Object)typeOf.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitTypeTreeExpression(JS.TypeTreeExpression typeTreeExpression, RpcReceiveQueue q) {
        return typeTreeExpression.withExpression((Expression)q.receive((Object)typeTreeExpression.getExpression(), expr -> (Expression)this.visitNonNull((Tree)expr, q)));
    }

    @Override
    public J visitAssignmentOperationExtensions(JS.AssignmentOperation assignmentOperation, RpcReceiveQueue q) {
        return assignmentOperation.withVariable((Expression)q.receive((Object)assignmentOperation.getVariable(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).getPadding().withOperator((JLeftPadded<JS.AssignmentOperation.Type>)((JLeftPadded)q.receive(assignmentOperation.getPadding().getOperator(), el -> this.visitLeftPadded((JLeftPadded)el, q, RpcReceiveQueue.toEnum(JS.AssignmentOperation.Type.class))))).withAssignment((Expression)q.receive((Object)assignmentOperation.getAssignment(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).withType((JavaType)q.receive((Object)assignmentOperation.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitIndexedAccessType(JS.IndexedAccessType indexedAccessType, RpcReceiveQueue q) {
        return indexedAccessType.withObjectType((TypeTree)q.receive((Object)indexedAccessType.getObjectType(), tree -> (TypeTree)this.visitNonNull((Tree)tree, q))).withIndexType((TypeTree)q.receive((Object)indexedAccessType.getIndexType(), tree -> (TypeTree)this.visitNonNull((Tree)tree, q))).withType((JavaType)q.receive((Object)indexedAccessType.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitIndexedAccessTypeIndexType(JS.IndexedAccessType.IndexType indexType, RpcReceiveQueue q) {
        return indexType.getPadding().withElement((JRightPadded<TypeTree>)((JRightPadded)q.receive(indexType.getPadding().getElement(), el -> this.visitRightPadded((JRightPadded)el, q)))).withType((JavaType)q.receive((Object)indexType.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitTypeQuery(JS.TypeQuery typeQuery, RpcReceiveQueue q) {
        return typeQuery.withTypeExpression((TypeTree)q.receive((Object)typeQuery.getTypeExpression(), tree -> (TypeTree)this.visitNonNull((Tree)tree, q))).getPadding().withTypeArguments((JContainer<Expression>)((JContainer)q.receive(typeQuery.getPadding().getTypeArguments(), el -> this.visitContainer((JContainer)el, q)))).withType((JavaType)q.receive((Object)typeQuery.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitTypeInfo(JS.TypeInfo typeInfo, RpcReceiveQueue q) {
        return typeInfo.withTypeIdentifier((TypeTree)q.receive((Object)typeInfo.getTypeIdentifier(), tree -> (TypeTree)this.visitNonNull((Tree)tree, q)));
    }

    @Override
    public J visitComputedPropertyName(JS.ComputedPropertyName computedPropertyName, RpcReceiveQueue q) {
        return computedPropertyName.getPadding().withExpression((JRightPadded<Expression>)((JRightPadded)q.receive(computedPropertyName.getPadding().getExpression(), el -> this.visitRightPadded((JRightPadded)el, q))));
    }

    @Override
    public J visitTypeOperator(JS.TypeOperator typeOperator, RpcReceiveQueue q) {
        return typeOperator.withOperator((JS.TypeOperator.Type)((Object)q.receiveAndGet((Object)typeOperator.getOperator(), RpcReceiveQueue.toEnum(JS.TypeOperator.Type.class)))).getPadding().withExpression((JLeftPadded<Expression>)((JLeftPadded)q.receive(typeOperator.getPadding().getExpression(), el -> this.visitLeftPadded((JLeftPadded)el, q))));
    }

    @Override
    public J visitTypePredicate(JS.TypePredicate typePredicate, RpcReceiveQueue q) {
        return typePredicate.getPadding().withAsserts((JLeftPadded<Boolean>)((JLeftPadded)q.receive(typePredicate.getPadding().getAsserts(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withParameterName((J.Identifier)q.receive((Object)typePredicate.getParameterName(), id -> (J.Identifier)this.visitNonNull((Tree)id, q))).getPadding().withExpression((JLeftPadded<Expression>)((JLeftPadded)q.receive(typePredicate.getPadding().getExpression(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withType((JavaType)q.receive((Object)typePredicate.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitUnion(JS.Union union, RpcReceiveQueue q) {
        return union.getPadding().withTypes(q.receiveList(union.getPadding().getTypes(), el -> this.visitRightPadded((JRightPadded)el, q))).withType((JavaType)q.receive((Object)union.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitIntersection(JS.Intersection intersection, RpcReceiveQueue q) {
        return intersection.getPadding().withTypes(q.receiveList(intersection.getPadding().getTypes(), el -> this.visitRightPadded((JRightPadded)el, q))).withType((JavaType)q.receive((Object)intersection.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitVoid(JS.Void void_, RpcReceiveQueue q) {
        return void_.withExpression((Expression)q.receive((Object)void_.getExpression(), expr -> (Expression)this.visitNonNull((Tree)expr, q)));
    }

    @Override
    public J visitWithStatement(JS.WithStatement withStatement, RpcReceiveQueue q) {
        return withStatement.withExpression((J.ControlParentheses<Expression>)((J.ControlParentheses)q.receive(withStatement.getExpression(), expr -> (J.ControlParentheses)this.visitNonNull((Tree)expr, q)))).getPadding().withBody((JRightPadded<Statement>)((JRightPadded)q.receive(withStatement.getPadding().getBody(), el -> this.visitRightPadded((JRightPadded)el, q))));
    }

    @Override
    public J visitJsxTag(JSX.Tag tag, RpcReceiveQueue q) {
        return tag.getPadding().withOpenName((JLeftPadded<NameTree>)((JLeftPadded)q.receive(tag.getPadding().getOpenName(), name1 -> this.visitLeftPadded((JLeftPadded)name1, q)))).withAfterName((Space)q.receive((Object)tag.getAfterName(), space2 -> this.visitSpace((Space)space2, q))).getPadding().withAttributes(q.receiveList(tag.getPadding().getAttributes(), attr -> this.visitRightPadded((JRightPadded)attr, q))).withSelfClosing((Space)q.receive((Object)tag.getSelfClosing(), space1 -> this.visitSpace((Space)space1, q))).withChildren(q.receiveList(tag.getChildren(), child -> (Expression)this.visitNonNull((Tree)child, q))).getPadding().withClosingName((JLeftPadded<J>)((JLeftPadded)q.receive(tag.getPadding().getClosingName(), name -> this.visitLeftPadded((JLeftPadded)name, q)))).withAfterClosingName((Space)q.receive((Object)tag.getAfterClosingName(), space -> this.visitSpace((Space)space, q)));
    }

    @Override
    public J visitJsxAttribute(JSX.Attribute attribute, RpcReceiveQueue q) {
        return attribute.withKey((NameTree)q.receive((Object)attribute.getKey(), key -> (NameTree)this.visitNonNull((Tree)key, q))).getPadding().withValue((JLeftPadded<Expression>)((JLeftPadded)q.receive(attribute.getPadding().getValue(), value -> this.visitLeftPadded((JLeftPadded)value, q))));
    }

    @Override
    public J visitJsxSpreadAttribute(JSX.SpreadAttribute spreadAttribute, RpcReceiveQueue q) {
        return spreadAttribute.withDots((Space)q.receive((Object)spreadAttribute.getDots(), dots -> this.visitSpace((Space)dots, q))).getPadding().withExpression((JRightPadded<Expression>)((JRightPadded)q.receive(spreadAttribute.getPadding().getExpression(), expr -> this.visitRightPadded((JRightPadded)expr, q))));
    }

    @Override
    public J visitJsxEmbeddedExpression(JSX.EmbeddedExpression embeddedExpression, RpcReceiveQueue q) {
        return embeddedExpression.getPadding().withExpression((JRightPadded<Expression>)((JRightPadded)q.receive(embeddedExpression.getPadding().getExpression(), expr -> this.visitRightPadded((JRightPadded)expr, q))));
    }

    @Override
    public J visitJsxNamespacedName(JSX.NamespacedName namespacedName, RpcReceiveQueue q) {
        return namespacedName.withNamespace((J.Identifier)q.receive((Object)namespacedName.getNamespace(), ns -> (J.Identifier)this.visitNonNull((Tree)ns, q))).getPadding().withName((JLeftPadded<J.Identifier>)((JLeftPadded)q.receive(namespacedName.getPadding().getName(), name -> this.visitLeftPadded((JLeftPadded)name, q))));
    }

    @Override
    public J visitIndexSignatureDeclaration(JS.IndexSignatureDeclaration indexSignatureDeclaration, RpcReceiveQueue q) {
        return indexSignatureDeclaration.withModifiers(q.receiveList(indexSignatureDeclaration.getModifiers(), mod -> (J.Modifier)this.visitNonNull((Tree)mod, q))).getPadding().withParameters((JContainer<J>)((JContainer)q.receive(indexSignatureDeclaration.getPadding().getParameters(), el -> this.visitContainer((JContainer)el, q)))).getPadding().withTypeExpression((JLeftPadded<Expression>)((JLeftPadded)q.receive(indexSignatureDeclaration.getPadding().getTypeExpression(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withType((JavaType)q.receive((Object)indexSignatureDeclaration.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitComputedPropertyMethodDeclaration(JS.ComputedPropertyMethodDeclaration computedPropMethod, RpcReceiveQueue q) {
        return computedPropMethod.withLeadingAnnotations(q.receiveList(computedPropMethod.getLeadingAnnotations(), annot -> (J.Annotation)this.visitNonNull((Tree)annot, q))).withModifiers(q.receiveList(computedPropMethod.getModifiers(), mod -> (J.Modifier)this.visitNonNull((Tree)mod, q))).withTypeParameters((J.TypeParameters)q.receive((Object)computedPropMethod.getTypeParameters(), params -> (J.TypeParameters)this.visitNonNull((Tree)params, q))).withReturnTypeExpression((TypeTree)q.receive((Object)computedPropMethod.getReturnTypeExpression(), tree -> (TypeTree)this.visitNonNull((Tree)tree, q))).withName((JS.ComputedPropertyName)q.receive((Object)computedPropMethod.getName(), expr -> (JS.ComputedPropertyName)this.visitNonNull((Tree)expr, q))).getPadding().withParameters((JContainer<Statement>)((JContainer)q.receive(computedPropMethod.getPadding().getParameters(), el -> this.visitContainer((JContainer)el, q)))).withBody((J.Block)q.receive((Object)computedPropMethod.getBody(), block -> (J.Block)this.visitNonNull((Tree)block, q))).withMethodType((JavaType.Method)q.receive((Object)computedPropMethod.getMethodType(), type -> (JavaType.Method)this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitForOfLoop(JS.ForOfLoop forOfLoop, RpcReceiveQueue q) {
        return forOfLoop.withAwait((Space)q.receive((Object)forOfLoop.getAwait(), v -> this.visitSpace((Space)v, q))).withLoop((J.ForEachLoop)q.receive((Object)forOfLoop.getLoop(), v -> (J.ForEachLoop)this.visitNonNull((Tree)v, q)));
    }

    @Override
    public J visitForInLoop(JS.ForInLoop forInLoop, RpcReceiveQueue q) {
        return forInLoop.withControl((J.ForEachLoop.Control)q.receive((Object)forInLoop.getControl(), el -> (J.ForEachLoop.Control)this.visitNonNull((Tree)el, q))).getPadding().withBody((JRightPadded<Statement>)((JRightPadded)q.receive(forInLoop.getPadding().getBody(), el -> this.visitRightPadded((JRightPadded)el, q))));
    }

    @Override
    public J visitNamespaceDeclaration(JS.NamespaceDeclaration namespaceDeclaration, RpcReceiveQueue q) {
        return namespaceDeclaration.withModifiers(q.receiveList(namespaceDeclaration.getModifiers(), mod -> (J.Modifier)this.visitNonNull((Tree)mod, q))).getPadding().withKeywordType((JLeftPadded<JS.NamespaceDeclaration.KeywordType>)((JLeftPadded)q.receive(namespaceDeclaration.getPadding().getKeywordType(), el -> this.visitLeftPadded((JLeftPadded)el, q, RpcReceiveQueue.toEnum(JS.NamespaceDeclaration.KeywordType.class))))).getPadding().withName((JRightPadded<Expression>)((JRightPadded)q.receive(namespaceDeclaration.getPadding().getName(), el -> this.visitRightPadded((JRightPadded)el, q)))).withBody((J.Block)q.receive((Object)namespaceDeclaration.getBody(), block -> (J.Block)this.visitNonNull((Tree)block, q)));
    }

    @Override
    public J visitTypeLiteral(JS.TypeLiteral typeLiteral, RpcReceiveQueue q) {
        return typeLiteral.withMembers((J.Block)q.receive((Object)typeLiteral.getMembers(), block -> (J.Block)this.visitNonNull((Tree)block, q))).withType((JavaType)q.receive((Object)typeLiteral.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitArrayBindingPattern(JS.ArrayBindingPattern arrayBindingPattern, RpcReceiveQueue q) {
        return arrayBindingPattern.getPadding().withElements((JContainer<Expression>)((JContainer)q.receive(arrayBindingPattern.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q)))).withType((JavaType)q.receive((Object)arrayBindingPattern.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitBindingElement(JS.BindingElement bindingElement, RpcReceiveQueue q) {
        return bindingElement.getPadding().withPropertyName((JRightPadded<Expression>)((JRightPadded)q.receive(bindingElement.getPadding().getPropertyName(), el -> this.visitRightPadded((JRightPadded)el, q)))).withName((TypedTree)q.receive((Object)bindingElement.getName(), el -> (TypedTree)this.visitNonNull((Tree)el, q))).getPadding().withInitializer((JLeftPadded<Expression>)((JLeftPadded)q.receive(bindingElement.getPadding().getInitializer(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withVariableType((JavaType.Variable)q.receive((Object)bindingElement.getVariableType(), type -> (JavaType.Variable)this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitExportDeclaration(JS.ExportDeclaration exportDeclaration, RpcReceiveQueue q) {
        return exportDeclaration.withModifiers(q.receiveList(exportDeclaration.getModifiers(), mod -> (J.Modifier)this.visitNonNull((Tree)mod, q))).getPadding().withTypeOnly((JLeftPadded<Boolean>)((JLeftPadded)q.receive(exportDeclaration.getPadding().getTypeOnly(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withExportClause((Expression)q.receive((Object)exportDeclaration.getExportClause(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).getPadding().withModuleSpecifier((JLeftPadded<Expression>)((JLeftPadded)q.receive(exportDeclaration.getPadding().getModuleSpecifier(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withAttributes((JS.ImportAttributes)q.receive((Object)exportDeclaration.getAttributes(), el -> (JS.ImportAttributes)this.visitNonNull((Tree)el, q)));
    }

    @Override
    public J visitExportAssignment(JS.ExportAssignment exportAssignment, RpcReceiveQueue q) {
        return exportAssignment.withExportEquals((Boolean)q.receive((Object)exportAssignment.isExportEquals())).getPadding().withExpression((JLeftPadded<Expression>)((JLeftPadded)q.receive(exportAssignment.getPadding().getExpression(), el -> this.visitLeftPadded((JLeftPadded)el, q))));
    }

    @Override
    public J visitNamedExports(JS.NamedExports namedExports, RpcReceiveQueue q) {
        return namedExports.getPadding().withElements((JContainer<Expression>)((JContainer)q.receive(namedExports.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q)))).withType((JavaType)q.receive((Object)namedExports.getType(), type -> this.visitType((JavaType)type, q)));
    }

    @Override
    public J visitExportSpecifier(JS.ExportSpecifier exportSpecifier, RpcReceiveQueue q) {
        return exportSpecifier.getPadding().withTypeOnly((JLeftPadded<Boolean>)((JLeftPadded)q.receive(exportSpecifier.getPadding().getTypeOnly(), el -> this.visitLeftPadded((JLeftPadded)el, q)))).withSpecifier((Expression)q.receive((Object)exportSpecifier.getSpecifier(), expr -> (Expression)this.visitNonNull((Tree)expr, q))).withType((JavaType)q.receive((Object)exportSpecifier.getType(), type -> this.visitType((JavaType)type, q)));
    }

    public Space visitSpace(Space space, RpcReceiveQueue q) {
        return this.delegate.visitSpace(space, q);
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, RpcReceiveQueue q) {
        return this.delegate.visitContainer(container, q);
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, RpcReceiveQueue q) {
        return this.delegate.visitLeftPadded(left, q);
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, RpcReceiveQueue q, Function<Object, T> elementMapping) {
        return this.delegate.visitLeftPadded(left, q, elementMapping);
    }

    public <T> JRightPadded<T> visitRightPadded(JRightPadded<T> right, RpcReceiveQueue q) {
        return this.delegate.visitRightPadded(right, q);
    }

    public JavaType visitType(JavaType javaType, RpcReceiveQueue q) {
        return this.delegate.visitType(javaType, q);
    }

    private static class JavaScriptReceiverDelegate
    extends JavaReceiver {
        private final JavaScriptReceiver delegate;

        public JavaScriptReceiverDelegate(JavaScriptReceiver delegate) {
            this.delegate = delegate;
        }

        public @Nullable J visit(@Nullable Tree tree, RpcReceiveQueue p) {
            if (tree instanceof JS) {
                return this.delegate.visit(tree, p);
            }
            return (J)super.visit(tree, (Object)p);
        }
    }
}

