/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueInteger;
import com.caoccao.javet.values.primitive.V8ValueLong;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.openrewrite.javascript.internal.tsc.TSCConversion;
import org.openrewrite.javascript.internal.tsc.TSCIndexInfo;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCNodeList;
import org.openrewrite.javascript.internal.tsc.TSCObjectCache;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;
import org.openrewrite.javascript.internal.tsc.TSCSignature;
import org.openrewrite.javascript.internal.tsc.TSCSymbol;
import org.openrewrite.javascript.internal.tsc.TSCSyntaxListNode;
import org.openrewrite.javascript.internal.tsc.TSCType;
import org.openrewrite.javascript.internal.tsc.TSCV8Backed;
import org.openrewrite.javascript.internal.tsc.generated.TSCSignatureKind;
import org.openrewrite.javascript.internal.tsc.generated.TSCSyntaxKind;

public final class TSCConversions {
    public static final TSCConversion<String> STRING = (context, value) -> {
        if (!(value instanceof V8ValueString)) {
            throw new IllegalArgumentException("expected V8 string");
        }
        return (String)((V8ValueString)value).getValue();
    };
    public static final TSCConversion<Boolean> BOOLEAN = (context, value) -> {
        if (value instanceof V8ValueBoolean) {
            return (Boolean)((V8ValueBoolean)value).getValue();
        }
        throw new IllegalArgumentException("expected V8 boolean");
    };
    public static final TSCConversion<Integer> INTEGER = (context, value) -> {
        if (value instanceof V8ValueInteger) {
            return (Integer)((V8ValueInteger)value).getValue();
        }
        throw new IllegalArgumentException("expected V8 integer");
    };
    public static final TSCConversion<Long> LONG = (context, value) -> {
        if (value instanceof V8ValueLong) {
            return (Long)((V8ValueLong)value).getValue();
        }
        if (value instanceof V8ValueInteger) {
            return ((Integer)((V8ValueInteger)value).getValue()).longValue();
        }
        throw new IllegalArgumentException("expected V8 long or integer");
    };
    public static final TSCConversion<TSCIndexInfo> INDEX_INFO = TSCConversions.builder(TSCIndexInfo::fromJS);
    public static final TSCConversion<List<TSCIndexInfo>> INDEX_INFO_LIST = TSCConversions.list(INDEX_INFO);
    public static final TSCConversion<TSCSyntaxKind> SYNTAX_KIND = TSCConversions.enumeration(TSCSyntaxKind::fromCode);
    public static final TSCConversion<TSCSignatureKind> SIGNATURE_KIND = TSCConversions.enumeration(TSCSignatureKind::fromCode);
    public static final TSCConversion<TSCType> TYPE = TSCConversions.cached(context -> context.typeCache);
    public static final TSCConversion<List<TSCType>> TYPE_LIST = TSCConversions.list(TYPE);
    public static final TSCConversion<TSCNode> NODE = TSCConversions.cached(context -> context.nodeCache);
    static final TSCConversion<TSCNodeList> NODE_LIST = TSCConversions.cached(context -> context.nodeListCache);
    public static final TSCConversion<TSCNode.TypeNode> TYPE_NODE = TSCConversions.cast(NODE, TSCNode.TypeNode.class);
    public static final TSCConversion<TSCSyntaxListNode> SYNTAX_LIST_NODE = TSCConversions.cast(NODE, TSCSyntaxListNode.class);
    public static final TSCConversion<TSCSymbol> SYMBOL = TSCConversions.cached(context -> context.symbolCache);
    public static final TSCConversion<List<TSCSymbol>> SYMBOL_LIST = TSCConversions.list(SYMBOL);
    public static final TSCConversion<TSCSignature> SIGNATURE = TSCConversions.cached(context -> context.signatureCache);
    public static final TSCConversion<List<TSCSignature>> SIGNATURE_LIST = TSCConversions.list(SIGNATURE);
    public static final TSCConversion<Object> AUTO = TSCConversions::autoConvert;
    private static final ThreadLocal<Integer> autoConversionDepth = ThreadLocal.withInitial(() -> 0);
    private static final int MAX_AUTO_CONVERSION_DEPTH = 10;

    private TSCConversions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object autoConvert(TSCProgramContext context, V8Value value) throws JavetException {
        int initialDepth = autoConversionDepth.get();
        if (initialDepth > 10) {
            return value.getV8Runtime().getConverter().toObject(value, true);
        }
        autoConversionDepth.set(initialDepth + 1);
        try {
            Object object;
            Object interfaceKind;
            if (value instanceof V8ValuePrimitive) {
                Object object2 = ((V8ValuePrimitive)value).getValue();
                return object2;
            }
            if (value instanceof V8ValueObject && (interfaceKind = context.getInstanceOfChecks().identifyInterfaceKind(value)) != null) {
                switch (interfaceKind) {
                    case Node: {
                        TSCNode tSCNode = NODE.convertUnsafe(context, value);
                        return tSCNode;
                    }
                    case Type: {
                        TSCType tSCType = TYPE.convertUnsafe(context, value);
                        return tSCType;
                    }
                    case Symbol: {
                        TSCSymbol tSCSymbol = SYMBOL.convertUnsafe(context, value);
                        return tSCSymbol;
                    }
                    case Signature: {
                        TSCSignature tSCSignature = SIGNATURE.convertUnsafe(context, value);
                        return tSCSignature;
                    }
                }
            }
            if (value instanceof V8ValueArray) {
                interfaceKind = TSCConversions.list(AUTO).convertUnsafe(context, value);
                return interfaceKind;
            }
            if (value instanceof V8ValueFunction) {
                V8ValueFunction copy = (V8ValueFunction)value.toClone();
                copy.setWeak();
                V8ValueFunction v8ValueFunction = copy;
                return v8ValueFunction;
            }
            if (value instanceof V8ValueObject) {
                object = TSCConversions.objectMap(AUTO).convertUnsafe(context, value);
                return object;
            }
            object = value.getV8Runtime().getConverter().toObject(value, true);
            return object;
        }
        finally {
            autoConversionDepth.set(initialDepth);
        }
    }

    public static <T> TSCConversion<List<T>> list(TSCConversion<T> of) {
        return (context, value) -> {
            if (!(value instanceof V8ValueArray)) {
                throw new IllegalArgumentException("expected V8 array");
            }
            V8ValueArray array = (V8ValueArray)value;
            ArrayList result = new ArrayList(array.getLength());
            array.forEach(element -> result.add(of.convertNonNull(context, element)));
            return result;
        };
    }

    public static <T> TSCConversion<Map<String, T>> objectMap(TSCConversion<T> ofValue) {
        return (context, value) -> {
            if (!(value instanceof V8ValueObject)) {
                throw new IllegalArgumentException("expected a V8 object");
            }
            LinkedHashMap primitives = new LinkedHashMap();
            LinkedHashMap objects = new LinkedHashMap();
            LinkedHashMap collections = new LinkedHashMap();
            V8ValueObject object = (V8ValueObject)value;
            IV8ValueArray propNames = object.getPropertyNames();
            for (int i = 0; i < propNames.getLength(); ++i) {
                String propName = propNames.getString((Object)i);
                Object propValue = ofValue.convertNullable(context, object.get((Object)propName));
                if (propValue == null || propValue instanceof Number || propValue instanceof String || propValue instanceof Enum) {
                    primitives.put(propName, propValue);
                    continue;
                }
                if (propValue instanceof Collection) {
                    collections.put(propName, propValue);
                    continue;
                }
                objects.put(propName, propValue);
            }
            LinkedHashMap converted = new LinkedHashMap();
            converted.putAll(primitives);
            converted.putAll(objects);
            converted.putAll(collections);
            return converted;
        };
    }

    static <T extends TSCV8Backed> TSCConversion<T> cached(Function<TSCProgramContext, TSCObjectCache<T>> getCache) {
        return (context, value) -> ((TSCObjectCache)getCache.apply(context)).getOrCreate(context, (V8ValueObject)value);
    }

    static <T extends TSCV8Backed, U extends T> TSCConversion<U> cast(TSCConversion<T> base, Class<U> subtype) {
        return (context, value) -> {
            TSCV8Backed object = (TSCV8Backed)base.convertUnsafe(context, value);
            if (!subtype.isInstance(object)) {
                throw new IllegalArgumentException("expected a " + subtype.getSimpleName() + ", but got a " + object.getClass().getSimpleName());
            }
            return object;
        };
    }

    static <T> TSCConversion<T> builder(BiFunction<TSCProgramContext, V8ValueObject, T> fromJS) {
        return (context, value) -> {
            if (!(value instanceof V8ValueObject)) {
                throw new IllegalArgumentException("expected V8 object");
            }
            return fromJS.apply(context, (V8ValueObject)value);
        };
    }

    static <T> TSCConversion<T> enumeration(IntFunction<T> fromCode) {
        return (context, value) -> {
            int code = INTEGER.convertNonNull(context, value);
            return fromCode.apply(code);
        };
    }
}

