/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.nio.file.Path;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;
import org.openrewrite.javascript.internal.tsc.TSCV8ValueHolder;
import org.openrewrite.javascript.internal.tsc.generated.TSCSyntaxKind;

public class TSCSourceFileContext
extends TSCV8ValueHolder {
    private final TSCProgramContext programContext;
    private final V8ValueObject scanner;
    private final Path relativeSourcePath;

    TSCSourceFileContext(TSCProgramContext programContext, String sourceText, Path relativeSourcePath) {
        this.programContext = programContext;
        this.relativeSourcePath = relativeSourcePath;
        try (V8ValueObject scannerV8 = (V8ValueObject)programContext.getCreateScannerFunction().call(null, new V8Value[0]);){
            this.scanner = this.lifecycleLinked(scannerV8);
            this.scanner.invokeVoid("setText", new Object[]{sourceText});
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
        this.resetScanner(0);
    }

    public Integer scannerTokenStart() {
        try {
            return this.scanner.invokeInteger("getTokenPos", new Object[0]);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer scannerTokenEnd() {
        try {
            return this.scanner.invokeInteger("getTextPos", new Object[0]);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public String scannerTokenText() {
        try {
            return this.scanner.invokeString("getTokenText", new Object[0]);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public void resetScanner(int offset) {
        try {
            this.scanner.invokeVoid("setTextPos", new Object[]{offset});
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public TSCSyntaxKind nextScannerSyntaxType() {
        try {
            int code = this.scanner.invokeInteger("scan", new Object[0]);
            return TSCSyntaxKind.fromCode(code);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public TSCProgramContext getProgramContext() {
        return this.programContext;
    }

    public Path getRelativeSourcePath() {
        return this.relativeSourcePath;
    }
}

