/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.search;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.javascript.table.JavaScriptSourceFile;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.quark.Quark;
import org.openrewrite.text.PlainText;

public final class FindJavaScriptSources
extends Recipe {
    private final transient JavaScriptSourceFile javaScriptSourceFile = new JavaScriptSourceFile(this);

    public String getDisplayName() {
        return "Find JavaScript sources and collect data metrics";
    }

    public String getDescription() {
        return "Use data table to collect source files types and counts of files with extensions `.js`, `.jsx`, `.mjs`, `.cjs`, `.ts`, `.tsx`, `.mts`, `.cts`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){
            final Set<String> jsExtensions = new HashSet<String>(Arrays.asList(".js", ".jsx", ".mjs", ".cjs"));
            final Set<String> tsExtensions = new HashSet<String>(Arrays.asList(".ts", ".tsx", ".mts", ".cts"));

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile s = (SourceFile)tree;
                String extension = s.getSourcePath().toString().substring(s.getSourcePath().toString().lastIndexOf("."));
                if (this.jsExtensions.contains(extension) || this.tsExtensions.contains(extension)) {
                    JavaScriptSourceFile.SourceFileType sourceFileType = null;
                    if (s instanceof Quark) {
                        sourceFileType = JavaScriptSourceFile.SourceFileType.Quark;
                    } else if (s instanceof PlainText) {
                        sourceFileType = JavaScriptSourceFile.SourceFileType.PlainText;
                    } else if (this.jsExtensions.contains(extension)) {
                        sourceFileType = JavaScriptSourceFile.SourceFileType.JavaScript;
                    } else if (this.tsExtensions.contains(extension)) {
                        sourceFileType = JavaScriptSourceFile.SourceFileType.TypeScript;
                    }
                    if (sourceFileType != null) {
                        FindJavaScriptSources.this.javaScriptSourceFile.insertRow(executionContext, new JavaScriptSourceFile.Row(s.getSourcePath().toString(), sourceFileType));
                        return SearchResult.found((Tree)s);
                    }
                }
                return super.visit(tree, (Object)executionContext);
            }
        };
    }

    public JavaScriptSourceFile getJavaScriptSourceFile() {
        return this.javaScriptSourceFile;
    }

    public String toString() {
        return "FindJavaScriptSources(javaScriptSourceFile=" + (Object)((Object)this.getJavaScriptSourceFile()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindJavaScriptSources)) {
            return false;
        }
        FindJavaScriptSources other = (FindJavaScriptSources)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindJavaScriptSources;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

