/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.javascript.internal.TSCMapper;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParsingExecutionContextView;

public class JavaScriptParser
implements Parser {
    private final Collection<NamedStyles> styles;
    private static final List<String> EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".js", ".jsx", ".mjs", ".cjs", ".ts", ".tsx", ".mts", ".cts"));

    private JavaScriptParser(Collection<NamedStyles> styles) {
        this.styles = styles;
    }

    public Stream<SourceFile> parse(String ... sources) {
        ArrayList<Parser.Input> inputs = new ArrayList<Parser.Input>(sources.length);
        int i = 0;
        while (i < sources.length) {
            Path path = Paths.get("f" + i + ".js", new String[0]);
            int j = i++;
            inputs.add(new Parser.Input(path, null, () -> new ByteArrayInputStream(sources[j].getBytes(StandardCharsets.UTF_8)), true));
        }
        return this.parseInputs(inputs, null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        List<SourceFile> outputs;
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        try (TSCMapper mapper = new TSCMapper(relativeTo, this.styles, (ExecutionContext)pctx){};){
            for (Parser.Input source : sources) {
                mapper.add(source);
            }
            outputs = mapper.build();
        }
        return outputs.stream();
    }

    public boolean accept(Path path) {
        if (path.toString().contains("/dist/")) {
            return false;
        }
        String filename = path.getFileName().toString().toLowerCase();
        for (String ext : EXTENSIONS) {
            if (!filename.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.js");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        Collection<NamedStyles> styles = new ArrayList<NamedStyles>();

        public Builder() {
            super(JS.CompilationUnit.class);
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public JavaScriptParser build() {
            return new JavaScriptParser(this.styles);
        }

        public String getDslName() {
            return "javascript";
        }
    }
}

