/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal;

import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.loader.JavetLibLoader;
import com.caoccao.javet.utils.JavetOSUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;

public class JavetNativeBridge {
    private static volatile boolean hasLoadedNativeLib = false;
    @Nullable
    private static volatile Throwable nativeLibError = null;
    private static final Object loadNativeLibLock = new Object();

    private JavetNativeBridge() {
    }

    public static Class<?>[] getClassesInitializedByBridge() {
        return new Class[]{JavetNativeBridge.class, JavetLibLoader.class, JavetOSUtils.class, JSRuntimeType.class, StringUtils.class};
    }

    public static String[] getPackagesInitializedByBridge() {
        return new String[]{"com.caoccao.javet.interop", "com.caoccao.javet.interop.loader", "com.caoccao.javet.values.reference", "com.caoccao.javet.enums", "com.caoccao.javet.utils", "com.caoccao.javet.exceptions"};
    }

    public static String getLibResourcePath() {
        try {
            return "/" + new JavetLibLoader(JSRuntimeType.V8).getLibFileName();
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getJavetClassNamesUsedByJNI() {
        List<String> list;
        block9: {
            InputStream is = JavetNativeBridge.class.getResourceAsStream("/javet-jni-classnames.txt");
            try {
                if (is == null) {
                    throw new IllegalStateException("javet-jni-classnames.txt does not exist");
                }
                list = Arrays.stream(StringUtils.readFully((InputStream)is).split("\n")).filter(name -> !name.isEmpty()).collect(Collectors.toList());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (!hasLoadedNativeLib) {
            Object object = loadNativeLibLock;
            synchronized (object) {
                if (!hasLoadedNativeLib) {
                    hasLoadedNativeLib = true;
                    JavetNativeBridge.actuallyInit();
                }
            }
        }
        if (nativeLibError != null) {
            throw new RuntimeException("error while loading Javet library", nativeLibError);
        }
    }

    private static void actuallyInit() {
        String nativeLibPath = JavetNativeBridge.getLibResourcePath();
        File tempFile = null;
        if (System.getProperty("org.graalvm.nativeimage.kind") != null) {
            try {
                block22: {
                    try {
                        tempFile = Files.createTempFile("libjavet", "", new FileAttribute[0]).toFile();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("error while creating temp file to extract Javet native library", e);
                    }
                    try (InputStream inputStream = JavetLibLoader.class.getResourceAsStream(nativeLibPath);
                         FileOutputStream outputStream = new FileOutputStream(tempFile);){
                        int length;
                        if (inputStream == null) {
                            throw new IllegalStateException("Could not find bundled resource for " + nativeLibPath);
                        }
                        byte[] buffer = new byte[4096];
                        while ((length = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, length);
                        }
                        if (!JavetOSUtils.IS_LINUX && !JavetOSUtils.IS_MACOS && !JavetOSUtils.IS_ANDROID) break block22;
                        try {
                            int result = Runtime.getRuntime().exec(new String[]{"chmod", "755", tempFile.getAbsolutePath()}).waitFor();
                            if (result != 0) {
                                throw new RuntimeException("attempt to chmod Javet library resulted in " + result);
                            }
                        }
                        catch (Throwable t) {
                            throw new RuntimeException("error while chmod-ing extracted Javet library (" + nativeLibPath + ")", t);
                        }
                    }
                }
                System.load(tempFile.getAbsolutePath());
            }
            catch (Throwable t) {
                System.err.println("Javet debugging information:");
                System.err.printf("   OS arch: %s%n", JavetOSUtils.OS_ARCH);
                System.err.printf("   OS name: %s%n", JavetOSUtils.OS_NAME);
                System.err.printf("  lib name: %s%n", nativeLibPath);
                if (tempFile != null) {
                    System.err.printf("  tmp path: %s%n", tempFile.getAbsolutePath());
                }
                t.printStackTrace();
                nativeLibError = t;
            }
        }
    }
}

