/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.javascript.internal.JavetNativeBridge;
import org.openrewrite.javascript.internal.TSCMapper;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.tree.ParsingExecutionContextView;

public class JavaScriptParser
implements Parser<JS.CompilationUnit> {
    private static final List<String> EXTENSIONS;

    public List<JS.CompilationUnit> parse(String ... sources) {
        ArrayList<Parser.Input> inputs = new ArrayList<Parser.Input>(sources.length);
        int i = 0;
        while (i < sources.length) {
            Path path = Paths.get("f" + i + ".js", new String[0]);
            int j = i++;
            inputs.add(new Parser.Input(path, null, () -> new ByteArrayInputStream(sources[j].getBytes(StandardCharsets.UTF_8)), true));
        }
        return this.parseInputs(inputs, null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public List<JS.CompilationUnit> parseInputs(Iterable<Parser.Input> inputs, final @Nullable Path relativeTo, ExecutionContext ogCtx) {
        List<JS.CompilationUnit> outputs;
        final ParsingExecutionContextView ctx = ParsingExecutionContextView.view((ExecutionContext)ogCtx);
        try (TSCMapper mapper = new TSCMapper(relativeTo){

            @Override
            protected void onParseFailure(Parser.Input input, Throwable error) {
                ctx.parseFailure(input, relativeTo, (Parser)JavaScriptParser.this, error);
                ctx.getOnError().accept(error);
            }
        };){
            for (Parser.Input input : inputs) {
                mapper.add(input, (ExecutionContext)ctx);
            }
            outputs = mapper.build();
        }
        return outputs;
    }

    public boolean accept(Path path) {
        String filename = path.getFileName().toString().toLowerCase();
        if (path.toString().contains("/dist/")) {
            return false;
        }
        for (String ext : EXTENSIONS) {
            if (!filename.endsWith("." + ext)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.js");
    }

    public static Builder builder() {
        return new Builder();
    }

    private JavaScriptParser() {
    }

    static {
        JavetNativeBridge.init();
        EXTENSIONS = Collections.unmodifiableList(Arrays.asList("js", "jsx", "mjs", "cjs", "ts", "tsx", "mts", "cts"));
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(JS.CompilationUnit.class);
        }

        public JavaScriptParser build() {
            return new JavaScriptParser();
        }

        public String getDslName() {
            return "javascript";
        }
    }
}

