/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import com.fasterxml.jackson.core.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.remote.ReceiverContext;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingExecutionContextView;
import org.openrewrite.remote.TreeReceiver;
import org.openrewrite.remote.java.RemotingClient;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class JavaScriptParser
implements Parser {
    private final Collection<NamedStyles> styles;
    private final boolean logCompilationWarningsAndErrors;
    private final JavaTypeCache typeCache;
    private final List<Path> nodePath;
    private final Path installationDir;
    private @Nullable Process nodeProcess;
    private @Nullable RemotingContext remotingContext;
    private @Nullable RemotingClient client;
    private static final List<String> EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".js", ".jsx", ".mjs", ".cjs", ".ts", ".tsx", ".mts", ".cts"));
    private static final List<String> EXCLUSIONS = Collections.unmodifiableList(Arrays.asList(".pnp.cjs", ".pnp.loader.mjs"));

    public Stream<SourceFile> parse(String ... sources) {
        ArrayList<Parser.Input> inputs = new ArrayList<Parser.Input>(sources.length);
        int i = 0;
        while (i < sources.length) {
            Path path = Paths.get("p" + i + ".ts", new String[0]);
            int j = i++;
            inputs.add(new Parser.Input(path, null, () -> new ByteArrayInputStream(sources[j].getBytes(StandardCharsets.UTF_8)), true));
        }
        return this.parseInputs(inputs, null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> inputs, @Nullable Path relativeTo, ExecutionContext ctx) {
        if (!this.ensureServerRunning(ctx)) {
            return PlainTextParser.builder().build().parseInputs(inputs, relativeTo, ctx);
        }
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        return this.acceptedInputs(inputs).map(input -> {
            Path path = input.getRelativePath(relativeTo);
            parsingListener.startedParsing(input);
            try (EncodingDetectingInputStream is = input.getSource(ctx);){
                SourceFile parsed = ((SourceFile)this.client.runUsingSocket((socket, messenger) -> Objects.requireNonNull((SourceFile)messenger.sendRequest(generator -> {
                    if (input.isSynthetic() || !Files.isRegularFile(input.getPath(), new LinkOption[0])) {
                        generator.writeString("parse-javascript-source");
                        generator.writeString(is.readFully());
                    } else {
                        generator.writeString("parse-javascript-file");
                        generator.writeString(input.getPath().toString());
                        generator.writeString(relativeTo.toString());
                    }
                }, parser -> {
                    Tree tree = new ReceiverContext((TreeReceiver)this.remotingContext.newReceiver((JsonParser)parser), this.remotingContext).receiveTree(null);
                    return (SourceFile)tree;
                }, socket)))).withSourcePath(path).withFileAttributes(FileAttributes.fromPath((Path)input.getPath())).withCharset(this.getCharset(ctx));
                if (parsed instanceof ParseError) {
                    ctx.getOnError().accept(new AssertionError(parsed));
                    SourceFile sourceFile2 = parsed;
                    return sourceFile2;
                }
                JS.CompilationUnit py = (JS.CompilationUnit)parsed;
                parsingListener.parsed(input, (SourceFile)py);
                SourceFile sourceFile = this.requirePrintEqualsInput(py, (Parser.Input)input, relativeTo, ctx);
                return sourceFile;
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
            }
        });
    }

    public boolean accept(Path path) {
        if (path.toString().contains("/dist/")) {
            return false;
        }
        String filename = path.getFileName().toString().toLowerCase();
        for (String ext : EXTENSIONS) {
            if (!filename.endsWith(ext) || EXCLUSIONS.contains(filename)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.ts");
    }

    public JavaScriptParser reset() {
        this.typeCache.clear();
        if (this.remotingContext != null) {
            this.remotingContext.reset();
            this.remotingContext = null;
        }
        if (this.nodeProcess != null) {
            this.nodeProcess.destroy();
            this.nodeProcess = null;
        }
        this.client = null;
        return this;
    }

    public static Builder usingRemotingInstallation(Path dir) {
        try {
            return JavaScriptParser.verifyRemotingInstallation(dir);
        }
        catch (IOException | InterruptedException var2) {
            return JavaScriptParser.builder();
        }
    }

    private static Builder verifyRemotingInstallation(Path dir) throws IOException, InterruptedException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        JavaScriptParser.exportResource("META-INF/package.json", dir.toFile());
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("npm", "install"));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = processBuilder.directory(dir.toFile()).start();
        int exitCode = process.waitFor();
        return new Builder().installationDir(dir);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void exportResource(String resourceName, File outputDir) throws IOException {
        try (InputStream stream = JavaScriptParser.class.getClassLoader().getResourceAsStream(resourceName);){
            if (stream == null) {
                throw new IllegalArgumentException("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            try (OutputStream resStreamOut = Files.newOutputStream(Paths.get(outputDir.getPath(), Paths.get(resourceName, new String[0]).getFileName().toString()), new OpenOption[0]);){
                int readBytes;
                while ((readBytes = stream.read(buffer)) > 0) {
                    resStreamOut.write(buffer, 0, readBytes);
                }
                resStreamOut.flush();
            }
        }
    }

    private boolean ensureServerRunning(ExecutionContext ctx) {
        if (this.client == null || !this.isAlive()) {
            try {
                this.initializeRemoting(ctx);
            }
            catch (IOException e) {
                return false;
            }
        } else {
            Objects.requireNonNull(this.remotingContext).reset();
        }
        return this.client != null && this.isAlive();
    }

    private boolean isAlive() {
        try {
            return (Boolean)Objects.requireNonNull(this.client).runUsingSocket((socket, messenger) -> {
                messenger.sendReset(socket);
                return true;
            });
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initializeRemoting(ExecutionContext ctx) throws IOException {
        RemotingExecutionContextView view = RemotingExecutionContextView.view((ExecutionContext)ctx);
        this.remotingContext = view.getRemotingContext();
        if (this.remotingContext == null) {
            this.remotingContext = new RemotingContext(JavaScriptParser.class.getClassLoader(), false);
            view.setRemotingContext(this.remotingContext);
        } else {
            this.remotingContext.reset();
        }
        int port = 54323;
        if (!JavaScriptParser.isServerRunning(port)) {
            ProcessBuilder processBuilder = new ProcessBuilder("node", "node_modules/@openrewrite/rewrite-remote/dist/server.js", Integer.toString(port));
            if (!this.nodePath.isEmpty()) {
                Map<String, String> environment = processBuilder.environment();
                environment.compute("NODE_PATH", (k, current) -> (current != null ? current + File.pathSeparator : "") + this.nodePath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
            }
            processBuilder.directory(this.installationDir.toFile());
            if (System.getProperty("os.name").startsWith("Windows")) {
                processBuilder.redirectOutput(new File("NUL"));
                processBuilder.redirectError(new File("NUL"));
            } else {
                processBuilder.redirectOutput(new File("/dev/null"));
                processBuilder.redirectError(new File("/dev/null"));
            }
            this.nodeProcess = processBuilder.start();
            for (int i = 0; i < 5 && this.nodeProcess.isAlive() && !JavaScriptParser.isServerRunning(port); ++i) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.nodeProcess == null || !this.nodeProcess.isAlive()) {
                this.remotingContext = null;
                return;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.nodeProcess != null && this.nodeProcess.isAlive()) {
                    this.nodeProcess.destroy();
                }
            }));
        }
        this.client = RemotingClient.create((ExecutionContext)ctx, JavaScriptParser.class, () -> {
            try {
                return new Socket(InetAddress.getLoopbackAddress(), port);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static boolean isServerRunning(int port) {
        boolean bl;
        Socket ignored = new Socket(InetAddress.getLoopbackAddress(), port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }

    @Generated
    private JavaScriptParser(Collection<NamedStyles> styles, boolean logCompilationWarningsAndErrors, JavaTypeCache typeCache, List<Path> nodePath, Path installationDir) {
        this.styles = styles;
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
        this.typeCache = typeCache;
        this.nodePath = nodePath;
        this.installationDir = installationDir;
    }

    public static class Builder
    extends Parser.Builder {
        private JavaTypeCache typeCache = new JavaTypeCache();
        private boolean logCompilationWarningsAndErrors;
        private final Collection<NamedStyles> styles = new ArrayList<NamedStyles>();
        private List<Path> nodePath = new ArrayList<Path>();
        private Path installationDir;

        public Builder() {
            super(JS.CompilationUnit.class);
        }

        public Builder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return this;
        }

        public Builder typeCache(JavaTypeCache typeCache) {
            this.typeCache = typeCache;
            return this;
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public Builder nodePath(List<Path> path) {
            this.nodePath = new ArrayList<Path>(path);
            return this;
        }

        public Builder installationDir(Path installationDir) {
            this.installationDir = installationDir;
            return this;
        }

        public JavaScriptParser build() {
            return new JavaScriptParser(this.styles, this.logCompilationWarningsAndErrors, this.typeCache, this.nodePath, this.installationDir);
        }

        public String getDslName() {
            return "javascript";
        }
    }
}

