/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openrewrite.DebugOnly;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.javascript.internal.tsc.TSCConversion;
import org.openrewrite.javascript.internal.tsc.TSCConversions;
import org.openrewrite.javascript.internal.tsc.TSCGlobals;
import org.openrewrite.javascript.internal.tsc.TSCIndexInfo;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCNodeList;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;
import org.openrewrite.javascript.internal.tsc.TSCSignature;
import org.openrewrite.javascript.internal.tsc.TSCSymbol;
import org.openrewrite.javascript.internal.tsc.TSCSyntaxListNode;
import org.openrewrite.javascript.internal.tsc.TSCType;
import org.openrewrite.javascript.internal.tsc.TSCTypeChecker;
import org.openrewrite.javascript.internal.tsc.generated.TSCSyntaxKind;

public interface TSCV8Backed {
    public static TSCV8Backed temporary(final TSCProgramContext programContext, final V8ValueObject objectV8) {
        return new TSCV8Backed(){

            @Override
            public TSCProgramContext getProgramContext() {
                return programContext;
            }

            @Override
            public V8ValueObject getBackingV8Object() {
                return objectV8;
            }
        };
    }

    public TSCProgramContext getProgramContext();

    default public TSCTypeChecker getTypeChecker() {
        return this.getProgramContext().getTypeChecker();
    }

    default public TSCGlobals getTS() {
        return this.getProgramContext().getTypeScriptGlobals();
    }

    public V8ValueObject getBackingV8Object();

    @DebugOnly
    default public Object getDebugInfo() {
        return new DebugInfo(this.getAllPropertiesForDebugging());
    }

    default public V8Value getPropertyUnsafe(String name) {
        try {
            if (name.endsWith("()")) {
                return this.getBackingV8Object().invoke(name.substring(0, name.length() - 2), new V8Value[0]);
            }
            return this.getBackingV8Object().get((Object)name);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    default public V8Value invokeMethodUnsafe(String name, Object ... args) {
        Object[] converted = null;
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof TSCV8Backed)) continue;
            if (converted == null) {
                converted = (Object[])args.clone();
            }
            converted[i] = ((TSCV8Backed)args[i]).getBackingV8Object();
        }
        if (converted == null) {
            converted = args;
        }
        try {
            return this.getBackingV8Object().invoke(name, converted);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    default public <T> T invokeMethodNullable(String name, TSCConversion<T> conversion, Object ... args) {
        try (V8Value valueV8 = this.invokeMethodUnsafe(name, args);){
            T t = conversion.convertNullable(this.getProgramContext(), valueV8);
            return t;
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T invokeMethodNonNull(String name, TSCConversion<T> conversion, Object ... args) {
        try (V8Value valueV8 = this.invokeMethodUnsafe(name, args);){
            T t = conversion.convertNonNull(this.getProgramContext(), valueV8);
            return t;
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    default public boolean invokeMethodBoolean(String name, Object ... args) {
        return this.invokeMethodNonNull(name, TSCConversions.BOOLEAN, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    default public <T> T getPropertyNullable(String name, TSCConversion<T> conversion) {
        try (V8Value value = this.getPropertyUnsafe(name);){
            T t = conversion.convertNullable(this.getProgramContext(), value);
            return t;
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T getPropertyNonNull(String name, TSCConversion<T> conversion) {
        try (V8Value value = this.getPropertyUnsafe(name);){
            T t = conversion.convertNonNull(this.getProgramContext(), value);
            return t;
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    default public boolean getBooleanProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.BOOLEAN);
    }

    @Nullable
    default public Boolean getOptionalBooleanProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.BOOLEAN);
    }

    default public int getIntProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.INTEGER);
    }

    @Nullable
    default public Integer getOptionalIntProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.INTEGER);
    }

    default public long getLongProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.LONG);
    }

    @Nullable
    default public Long getOptionalLongProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.LONG);
    }

    default public String getStringProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.STRING);
    }

    @Nullable
    default public String getOptionalStringProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.STRING);
    }

    default public TSCSyntaxKind getSyntaxKindProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.SYNTAX_KIND);
    }

    @Nullable
    default public TSCSyntaxKind getOptionalSyntaxKindProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.SYNTAX_KIND);
    }

    default public TSCNode getNodeProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.NODE);
    }

    @Nullable
    default public TSCNode getOptionalNodeProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.NODE);
    }

    default public TSCNodeList getNodeListProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.NODE_LIST);
    }

    @Nullable
    default public TSCNodeList getOptionalNodeListProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.NODE_LIST);
    }

    default public TSCNode.TypeNode getTypeNodeProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.TYPE_NODE);
    }

    @Nullable
    default public TSCNode.TypeNode getOptionalTypeNodeProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.TYPE_NODE);
    }

    default public TSCSyntaxListNode getSyntaxListProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.SYNTAX_LIST_NODE);
    }

    @Nullable
    default public TSCSyntaxListNode getOptionalSyntaxListProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.SYNTAX_LIST_NODE);
    }

    default public TSCType getTypeProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.TYPE);
    }

    @Nullable
    default public TSCType getOptionalTypeProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.TYPE);
    }

    default public List<TSCType> getTypeListProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.TYPE_LIST);
    }

    @Nullable
    default public List<TSCType> getOptionalTypeListProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.TYPE_LIST);
    }

    default public TSCSymbol getSymbolProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.SYMBOL);
    }

    @Nullable
    default public TSCSymbol getOptionalSymbolProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.SYMBOL);
    }

    default public List<TSCSymbol> getSymbolListProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.SYMBOL_LIST);
    }

    @Nullable
    default public List<TSCSymbol> getOptionalSymbolListProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.SYMBOL_LIST);
    }

    default public TSCSignature getSignatureProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.SIGNATURE);
    }

    @Nullable
    default public TSCSignature getOptionalSignatureProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.SIGNATURE);
    }

    default public List<TSCSignature> getSignatureListProperty(String name) {
        return this.getPropertyNonNull(name, TSCConversions.SIGNATURE_LIST);
    }

    @Nullable
    default public List<TSCSignature> getOptionalSignatureListProperty(String name) {
        return this.getPropertyNullable(name, TSCConversions.SIGNATURE_LIST);
    }

    default public TSCIndexInfo getIndexInfoProperty(String name) {
        TSCIndexInfo tSCIndexInfo;
        block8: {
            V8Value v8Value = this.getPropertyUnsafe(name);
            try {
                tSCIndexInfo = TSCIndexInfo.fromJS(this.getProgramContext(), (V8ValueObject)v8Value);
                if (v8Value == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (v8Value != null) {
                        try {
                            v8Value.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JavetException e) {
                    throw new RuntimeException(e);
                }
            }
            v8Value.close();
        }
        return tSCIndexInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    default public TSCIndexInfo getOptionalIndexInfoProperty(String name) {
        try (V8Value v8Value = this.getPropertyUnsafe(name);){
            if (v8Value.isNullOrUndefined()) {
                TSCIndexInfo tSCIndexInfo2 = null;
                return tSCIndexInfo2;
            }
            TSCIndexInfo tSCIndexInfo = TSCIndexInfo.fromJS(this.getProgramContext(), (V8ValueObject)v8Value);
            return tSCIndexInfo;
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    default public List<TSCIndexInfo> getIndexInfoListProperty(String name) {
        ArrayList<TSCIndexInfo> arrayList;
        block8: {
            V8Value v8Value = this.getPropertyUnsafe(name);
            try {
                V8ValueArray v8Array = (V8ValueArray)v8Value;
                ArrayList<TSCIndexInfo> result = new ArrayList<TSCIndexInfo>(v8Array.getLength());
                ((V8ValueArray)v8Value).forEach(childV8Value -> result.add(TSCIndexInfo.fromJS(this.getProgramContext(), (V8ValueObject)childV8Value)));
                arrayList = result;
                if (v8Value == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (v8Value != null) {
                        try {
                            v8Value.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JavetException e) {
                    throw new RuntimeException(e);
                }
            }
            v8Value.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    default public List<TSCIndexInfo> getOptionalIndexInfoListProperty(String name) {
        try (V8Value v8Value = this.getPropertyUnsafe(name);){
            if (v8Value.isNullOrUndefined()) {
                List<TSCIndexInfo> list = null;
                return list;
            }
            V8ValueArray v8Array = (V8ValueArray)v8Value;
            ArrayList<TSCIndexInfo> result = new ArrayList<TSCIndexInfo>(v8Array.getLength());
            ((V8ValueArray)v8Value).forEach(childV8Value -> result.add(TSCIndexInfo.fromJS(this.getProgramContext(), (V8ValueObject)childV8Value)));
            ArrayList<TSCIndexInfo> arrayList = result;
            return arrayList;
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    default public boolean hasProperty(String propertyName) {
        boolean bl;
        block8: {
            V8Value value = this.getPropertyUnsafe(propertyName);
            try {
                boolean bl2 = bl = !value.isUndefined();
                if (value == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (value != null) {
                        try {
                            value.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JavetException ignored) {
                    return false;
                }
            }
            value.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    default public String getConstructorName() {
        try (V8Value constructor = this.getPropertyUnsafe("constructor");){
            if (constructor.isNullOrUndefined()) {
                String string = null;
                return string;
            }
            if (!(constructor instanceof V8ValueFunction)) {
                String string = null;
                return string;
            }
            String string = ((V8ValueFunction)constructor).getPropertyString((Object)"name");
            return string;
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @DebugOnly
    default public Map<String, Object> getAllPropertiesForDebugging() {
        return this.as(TSCConversions.objectMap(TSCConversions.AUTO));
    }

    default public List<String> getOwnPropertyNames() {
        try {
            return this.getBackingV8Object().getOwnPropertyNameStrings();
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    default public List<String> getAllPropertyNames() {
        ArrayList<String> arrayList;
        block9: {
            IV8ValueArray propertyNames = this.getBackingV8Object().getPropertyNames();
            try {
                ArrayList<String> result = new ArrayList<String>(propertyNames.getLength());
                for (int i = 0; i < propertyNames.getLength(); ++i) {
                    result.add(propertyNames.getString((Object)i));
                }
                arrayList = result;
                if (propertyNames == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (propertyNames != null) {
                        try {
                            propertyNames.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JavetException e) {
                    throw new RuntimeException(e);
                }
            }
            propertyNames.close();
        }
        return arrayList;
    }

    default public <T> T as(TSCConversion<T> conversion) {
        return conversion.convertNonNull(this.getProgramContext(), (V8Value)this.getBackingV8Object());
    }

    public static final class DebugInfo {
        private final Map<String, Object> properties;

        @ConstructorProperties(value={"properties"})
        public DebugInfo(Map<String, Object> properties) {
            this.properties = properties;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebugInfo)) {
                return false;
            }
            DebugInfo other = (DebugInfo)o;
            Map<String, Object> this$properties = this.getProperties();
            Map<String, Object> other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "TSCV8Backed.DebugInfo(properties=" + this.getProperties() + ")";
        }
    }

    public static interface Wrapper
    extends TSCV8Backed {
        public TSCV8Backed wrapped();

        @Override
        default public TSCProgramContext getProgramContext() {
            return this.wrapped().getProgramContext();
        }

        @Override
        default public V8ValueObject getBackingV8Object() {
            return this.wrapped().getBackingV8Object();
        }
    }
}

