/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.format.LineBreaks;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.format.AutodetectGeneralFormatStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.openrewrite.style.StyleHelper;

public class NormalizeLineBreaksVisitor<P>
extends JavaIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final GeneralFormatStyle style;
    private final JavadocVisitor<Integer> lineBreakJavadocVisitor = new JavadocVisitor<Integer>(new JavaVisitor()){

        @Override
        public Javadoc visitLineBreak(Javadoc.LineBreak lineBreak, Integer integer) {
            return lineBreak.withMargin(LineBreaks.normalizeNewLines((String)lineBreak.getMargin(), (boolean)NormalizeLineBreaksVisitor.this.style.isUseCRLFNewLines()));
        }
    };

    public NormalizeLineBreaksVisitor(JavaSourceFile cu, @Nullable Tree stopAfter) {
        this(cu.getMarkers().findAll(NamedStyles.class), cu, stopAfter);
    }

    public NormalizeLineBreaksVisitor(List<NamedStyles> styles, JavaSourceFile cu, @Nullable Tree stopAfter) {
        this(NormalizeLineBreaksVisitor.getStyle(GeneralFormatStyle.class, styles, () -> AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(cu)), stopAfter);
    }

    public NormalizeLineBreaksVisitor(GeneralFormatStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        Space s = space.withWhitespace(LineBreaks.normalizeNewLines((String)space.getWhitespace(), (boolean)this.style.isUseCRLFNewLines()));
        return s.withComments(ListUtils.map(s.getComments(), comment -> {
            Comment c = comment;
            if (c.isMultiline()) {
                if (c instanceof Javadoc) {
                    c = c.withSuffix(LineBreaks.normalizeNewLines((String)c.getSuffix(), (boolean)this.style.isUseCRLFNewLines()));
                    return (Comment)this.lineBreakJavadocVisitor.visitNonNull((Javadoc)((Object)c), 0);
                }
                TextComment textComment = (TextComment)c;
                c = textComment.withText(LineBreaks.normalizeNewLines((String)textComment.getText(), (boolean)this.style.isUseCRLFNewLines()));
            }
            return c.withSuffix(LineBreaks.normalizeNewLines((String)c.getSuffix(), (boolean)this.style.isUseCRLFNewLines()));
        }));
    }

    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return tree;
    }

    public @Nullable J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    private static <S extends Style> S getStyle(Class<S> styleClass, List<NamedStyles> styles, Supplier<S> defaultStyle) {
        Style style = NamedStyles.merge(styleClass, styles);
        if (style != null) {
            return (S)((Style)StyleHelper.merge((Object)((Style)defaultStyle.get()), (Object)style));
        }
        return (S)((Style)defaultStyle.get());
    }
}

