/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;

public class MinimumViableSpacingVisitor<P>
extends JavaIsoVisitor<P> {
    private final @Nullable Tree stopAfter;

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        Space before;
        J.ClassDeclaration.Padding padding;
        JContainer<J.TypeParameter> typeParameters;
        J c = super.visitClassDeclaration(classDecl, (Object)p);
        boolean first = ((J.ClassDeclaration)c).getLeadingAnnotations().isEmpty();
        if (!((J.ClassDeclaration)c).getModifiers().isEmpty()) {
            if (!first && Space.firstPrefix(((J.ClassDeclaration)c).getModifiers()).getWhitespace().isEmpty()) {
                c = ((J.ClassDeclaration)c).withModifiers(Space.formatFirstPrefix(((J.ClassDeclaration)c).getModifiers(), ((J.ClassDeclaration)c).getModifiers().iterator().next().getPrefix().withWhitespace(" ")));
            }
            if (((J.ClassDeclaration)c).getModifiers().size() > 1) {
                c = ((J.ClassDeclaration)c).withModifiers(ListUtils.map(((J.ClassDeclaration)c).getModifiers(), (index, modifier) -> {
                    if (index > 0 && modifier.getPrefix().getWhitespace().isEmpty()) {
                        return modifier.withPrefix(modifier.getPrefix().withWhitespace(" "));
                    }
                    return modifier;
                }));
            }
            first = false;
        }
        if (((J.ClassDeclaration)c).getPadding().getKind().getPrefix().isEmpty()) {
            if (!first) {
                c = ((J.ClassDeclaration)c).getPadding().withKind(((J.ClassDeclaration)c).getPadding().getKind().withPrefix(((J.ClassDeclaration)c).getPadding().getKind().getPrefix().withWhitespace(" ")));
            }
            first = false;
        }
        if (!first && ((J.ClassDeclaration)c).getName().getPrefix().getWhitespace().isEmpty()) {
            c = ((J.ClassDeclaration)c).withName(((J.ClassDeclaration)c).getName().withPrefix(((J.ClassDeclaration)c).getName().getPrefix().withWhitespace(" ")));
        }
        if (!((typeParameters = (padding = ((J.ClassDeclaration)c).getPadding()).getTypeParameters()) == null || typeParameters.getElements().isEmpty() || first || typeParameters.getBefore().getWhitespace().isEmpty())) {
            c = padding.withTypeParameters(typeParameters.withBefore(typeParameters.getBefore().withWhitespace(" ")));
        }
        if (((J.ClassDeclaration)c).getPadding().getExtends() != null && (before = ((J.ClassDeclaration)c).getPadding().getExtends().getBefore()).getWhitespace().isEmpty() && ((J.ClassDeclaration)(c = ((J.ClassDeclaration)c).getPadding().withExtends(((J.ClassDeclaration)c).getPadding().getExtends().withBefore(before.withWhitespace(" "))))).getExtends().getPrefix().isEmpty()) {
            c = ((J.ClassDeclaration)c).withExtends((TypeTree)((J.ClassDeclaration)c).getExtends().withPrefix(((J.ClassDeclaration)c).getExtends().getPrefix().withWhitespace(" ")));
        }
        if (((J.ClassDeclaration)c).getPadding().getImplements() != null && (before = ((J.ClassDeclaration)c).getPadding().getImplements().getBefore()).getWhitespace().isEmpty()) {
            c = ((J.ClassDeclaration)c).getPadding().withImplements(((J.ClassDeclaration)c).getPadding().getImplements().withBefore(before.withWhitespace(" ")));
            c = ((J.ClassDeclaration)c).withImplements(ListUtils.mapFirst(((J.ClassDeclaration)c).getImplements(), anImplements -> {
                if (anImplements.getPrefix().getWhitespace().isEmpty()) {
                    return (TypeTree)anImplements.withPrefix(anImplements.getPrefix().withWhitespace(" "));
                }
                return anImplements;
            }));
        }
        return c;
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        if (method.getName().getComments().isEmpty() && method.getName().getPrefix().getWhitespace().contains("\n")) {
            method = method.withName(method.getName().withPrefix(Space.EMPTY));
        }
        return super.visitMethodInvocation(method, (Object)p);
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        Space before;
        J.TypeParameters typeParameters;
        J m = super.visitMethodDeclaration(method, (Object)p);
        boolean first = ((J.MethodDeclaration)m).getLeadingAnnotations().isEmpty();
        if (!((J.MethodDeclaration)m).getModifiers().isEmpty()) {
            if (!first && Space.firstPrefix(((J.MethodDeclaration)m).getModifiers()).getWhitespace().isEmpty()) {
                m = ((J.MethodDeclaration)m).withModifiers(Space.formatFirstPrefix(((J.MethodDeclaration)m).getModifiers(), ((J.MethodDeclaration)m).getModifiers().iterator().next().getPrefix().withWhitespace(" ")));
            }
            if (((J.MethodDeclaration)m).getModifiers().size() > 1) {
                m = ((J.MethodDeclaration)m).withModifiers(ListUtils.map(((J.MethodDeclaration)m).getModifiers(), (index, modifier) -> {
                    if (index > 0 && modifier.getPrefix().getWhitespace().isEmpty()) {
                        return modifier.withPrefix(modifier.getPrefix().withWhitespace(" "));
                    }
                    return modifier;
                }));
            }
            first = false;
        }
        if ((typeParameters = ((J.MethodDeclaration)m).getAnnotations().getTypeParameters()) != null && !typeParameters.getTypeParameters().isEmpty()) {
            if (!first && typeParameters.getPrefix().getWhitespace().isEmpty()) {
                m = ((J.MethodDeclaration)m).getAnnotations().withTypeParameters(typeParameters.withPrefix(typeParameters.getPrefix().withWhitespace(" ")));
            }
            first = false;
        }
        if (((J.MethodDeclaration)m).getReturnTypeExpression() != null && ((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix().getWhitespace().isEmpty()) {
            if (!first) {
                TypeTree returnTypeExpression = ((J.MethodDeclaration)m).getReturnTypeExpression();
                if (returnTypeExpression instanceof J.AnnotatedType) {
                    J.AnnotatedType annotatedType = (J.AnnotatedType)returnTypeExpression;
                    List annotations = ListUtils.mapFirst(annotatedType.getAnnotations(), annotation -> annotation.withPrefix(annotation.getPrefix().withWhitespace(" ")));
                    m = ((J.MethodDeclaration)m).withReturnTypeExpression(annotatedType.withAnnotations(annotations));
                } else {
                    m = ((J.MethodDeclaration)m).withReturnTypeExpression((TypeTree)returnTypeExpression.withPrefix(returnTypeExpression.getPrefix().withWhitespace(" ")));
                }
            }
            first = false;
        }
        if (!first && ((J.MethodDeclaration)m).getName().getPrefix().getWhitespace().isEmpty()) {
            m = ((J.MethodDeclaration)m).withName(((J.MethodDeclaration)m).getName().withPrefix(((J.MethodDeclaration)m).getName().getPrefix().withWhitespace(" ")));
        }
        if (((J.MethodDeclaration)m).getPadding().getThrows() != null && (before = ((J.MethodDeclaration)m).getPadding().getThrows().getBefore()).getWhitespace().isEmpty()) {
            m = ((J.MethodDeclaration)m).getPadding().withThrows(((J.MethodDeclaration)m).getPadding().getThrows().withBefore(before.withWhitespace(" ")));
            m = ((J.MethodDeclaration)m).withThrows(ListUtils.mapFirst(((J.MethodDeclaration)m).getThrows(), aThrows -> {
                if (aThrows.getPrefix().getWhitespace().isEmpty()) {
                    return (NameTree)aThrows.withPrefix(aThrows.getPrefix().withWhitespace(" "));
                }
                return aThrows;
            }));
        }
        return m;
    }

    @Override
    public J.Return visitReturn(J.Return return_, P p) {
        J r = super.visitReturn(return_, (Object)p);
        if (((J.Return)r).getExpression() != null && ((J.Return)r).getExpression().getPrefix().getWhitespace().isEmpty() && !return_.getMarkers().findFirst(ImplicitReturn.class).isPresent()) {
            r = ((J.Return)r).withExpression((Expression)((J.Return)r).getExpression().withPrefix(((J.Return)r).getExpression().getPrefix().withWhitespace(" ")));
        }
        return r;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J firstEnclosing;
        boolean hasModifiers;
        J v = super.visitVariableDeclarations(multiVariable, (Object)p);
        boolean hasLeadingAnnotations = !((J.VariableDeclarations)v).getLeadingAnnotations().isEmpty();
        boolean bl = hasModifiers = !((J.VariableDeclarations)v).getModifiers().isEmpty();
        if (hasModifiers) {
            v = ((J.VariableDeclarations)v).withModifiers(ListUtils.map(((J.VariableDeclarations)v).getModifiers(), (index, modifier) -> {
                if ((index != 0 || hasLeadingAnnotations) && modifier.getPrefix().isEmpty()) {
                    modifier = modifier.withPrefix(modifier.getPrefix().withWhitespace(" "));
                }
                return modifier;
            }));
        }
        if ((hasLeadingAnnotations || hasModifiers) && ((J.VariableDeclarations)v).getTypeExpression() != null && ((J.VariableDeclarations)v).getTypeExpression().getPrefix().isEmpty()) {
            v = ((J.VariableDeclarations)v).withTypeExpression((TypeTree)((J.VariableDeclarations)v).getTypeExpression().withPrefix(((J.VariableDeclarations)v).getTypeExpression().getPrefix().withWhitespace(" ")));
        }
        if (!((firstEnclosing = (J)this.getCursor().getParentOrThrow().firstEnclosing(J.class)) instanceof J.Lambda.Parameters) && Space.firstPrefix(((J.VariableDeclarations)v).getVariables()).isEmpty()) {
            v = ((J.VariableDeclarations)v).withVariables(Space.formatFirstPrefix(((J.VariableDeclarations)v).getVariables(), ((J.VariableDeclarations)v).getVariables().iterator().next().getPrefix().withWhitespace(" ")));
        }
        return v;
    }

    @Override
    public J.Yield visitYield(J.Yield yield, P p) {
        J y = super.visitYield(yield, (Object)p);
        return ((J.Yield)y).withValue((Expression)((J.Yield)y).getValue().withPrefix(((J.Yield)y).getValue().getPrefix().withWhitespace(" ")));
    }

    @Override
    public J.Case visitCase(J.Case _case, P p) {
        J c = super.visitCase(_case, (Object)p);
        if (((J.Case)c).getGuard() != null) {
            JContainer.Padding<J> padding = ((J.Case)c).getPadding().getCaseLabels().getPadding();
            return ((J.Case)c).getPadding().withCaseLabels(padding.withElements(ListUtils.mapLast(padding.getElements(), last -> last != null && last.getAfter().isEmpty() ? last.withAfter(last.getAfter().withWhitespace(" ")) : last)));
        }
        return c;
    }

    @Override
    public J.Import visitImport(J.Import _import, P p) {
        J i = super.visitImport(_import, (Object)p);
        if (((J.Import)i).getQualid().getPrefix().isEmpty()) {
            return ((J.Import)i).withQualid(((J.Import)i).getQualid().withPrefix(((J.Import)i).getQualid().getPrefix().withWhitespace(" ")));
        }
        return i;
    }

    public @Nullable J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    public @Nullable J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    @Generated
    public MinimumViableSpacingVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }
}

