/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.naming;

import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.naming.AbstractAccessControlNameCheck;
import org.openrewrite.tools.checkstyle.utils.AnnotationUtil;

public class MethodNameCheck
extends AbstractAccessControlNameCheck {
    public static final String MSG_KEY = "method.name.equals.class.name";
    private static final String OVERRIDE = "Override";
    private static final String CANONICAL_OVERRIDE = "java.lang.Override";
    private boolean allowClassName;

    public MethodNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{9};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!AnnotationUtil.containsAnnotation(ast, OVERRIDE) && !AnnotationUtil.containsAnnotation(ast, CANONICAL_OVERRIDE)) {
            super.visitToken(ast);
        }
        if (!this.allowClassName) {
            DetailAST method = ast.findFirstToken(58);
            DetailAST classDefOrNew = ast.getParent().getParent();
            DetailAST classIdent = classDefOrNew.findFirstToken(58);
            if (classIdent != null && method.getText().equals(classIdent.getText())) {
                this.log(method, MSG_KEY, method.getText());
            }
        }
    }

    public void setAllowClassName(boolean allowClassName) {
        this.allowClassName = allowClassName;
    }
}

