/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class FieldsOfTypeUses
extends DataTable<Row> {
    public FieldsOfTypeUses(Recipe recipe) {
        super(recipe, "Fields of type uses", "Information about fields that match a specific type.");
    }

    public static final class Row {
        @Column(displayName="Source file", description="The source file that contains the field declaration.")
        private final String sourceFile;
        @Column(displayName="Field name", description="The name of the field.")
        private final String fieldName;
        @Column(displayName="Field type", description="The declared type of the field.")
        private final String fieldType;
        @Column(displayName="Concrete field type", description="The concrete type of the field, which may be a subtype of a searched type.")
        private final String concreteFieldType;
        @Column(displayName="Field modifiers", description="The modifiers of the field.")
        private final String fieldModifiers;
        @Column(displayName="Field declaration", description="The source code of the field declaration.")
        private final String fieldDeclaration;

        @Generated
        public Row(String sourceFile, String fieldName, String fieldType, String concreteFieldType, String fieldModifiers, String fieldDeclaration) {
            this.sourceFile = sourceFile;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.concreteFieldType = concreteFieldType;
            this.fieldModifiers = fieldModifiers;
            this.fieldDeclaration = fieldDeclaration;
        }

        @Generated
        public String getSourceFile() {
            return this.sourceFile;
        }

        @Generated
        public String getFieldName() {
            return this.fieldName;
        }

        @Generated
        public String getFieldType() {
            return this.fieldType;
        }

        @Generated
        public String getConcreteFieldType() {
            return this.concreteFieldType;
        }

        @Generated
        public String getFieldModifiers() {
            return this.fieldModifiers;
        }

        @Generated
        public String getFieldDeclaration() {
            return this.fieldDeclaration;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourceFile = this.getSourceFile();
            String other$sourceFile = other.getSourceFile();
            if (this$sourceFile == null ? other$sourceFile != null : !this$sourceFile.equals(other$sourceFile)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            String this$fieldType = this.getFieldType();
            String other$fieldType = other.getFieldType();
            if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
                return false;
            }
            String this$concreteFieldType = this.getConcreteFieldType();
            String other$concreteFieldType = other.getConcreteFieldType();
            if (this$concreteFieldType == null ? other$concreteFieldType != null : !this$concreteFieldType.equals(other$concreteFieldType)) {
                return false;
            }
            String this$fieldModifiers = this.getFieldModifiers();
            String other$fieldModifiers = other.getFieldModifiers();
            if (this$fieldModifiers == null ? other$fieldModifiers != null : !this$fieldModifiers.equals(other$fieldModifiers)) {
                return false;
            }
            String this$fieldDeclaration = this.getFieldDeclaration();
            String other$fieldDeclaration = other.getFieldDeclaration();
            return !(this$fieldDeclaration == null ? other$fieldDeclaration != null : !this$fieldDeclaration.equals(other$fieldDeclaration));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourceFile = this.getSourceFile();
            result = result * 59 + ($sourceFile == null ? 43 : $sourceFile.hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            String $fieldType = this.getFieldType();
            result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
            String $concreteFieldType = this.getConcreteFieldType();
            result = result * 59 + ($concreteFieldType == null ? 43 : $concreteFieldType.hashCode());
            String $fieldModifiers = this.getFieldModifiers();
            result = result * 59 + ($fieldModifiers == null ? 43 : $fieldModifiers.hashCode());
            String $fieldDeclaration = this.getFieldDeclaration();
            result = result * 59 + ($fieldDeclaration == null ? 43 : $fieldDeclaration.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "FieldsOfTypeUses.Row(sourceFile=" + this.getSourceFile() + ", fieldName=" + this.getFieldName() + ", fieldType=" + this.getFieldType() + ", concreteFieldType=" + this.getConcreteFieldType() + ", fieldModifiers=" + this.getFieldModifiers() + ", fieldDeclaration=" + this.getFieldDeclaration() + ")";
        }
    }
}

