/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.rpc;

import java.util.List;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.rpc.RpcReceiveQueue;

public class JavaTypeReceiver
extends JavaTypeVisitor<RpcReceiveQueue> {
    private final String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    public JavaType visitAnnotation(JavaType.Annotation annotation, RpcReceiveQueue q) {
        JavaType.FullyQualified type = (JavaType.FullyQualified)q.receive((Object)annotation.getType(), v -> (JavaType.FullyQualified)this.visit((JavaType)v, q));
        return annotation.unsafeSet(type, null);
    }

    @Override
    public JavaType visitMultiCatch(JavaType.MultiCatch multiCatch, RpcReceiveQueue q) {
        return multiCatch.withThrowableTypes(q.receiveList(multiCatch.getThrowableTypes(), v -> this.visit((JavaType)v, q)));
    }

    @Override
    public JavaType visitIntersection(JavaType.Intersection intersection, RpcReceiveQueue q) {
        return intersection.withBounds(q.receiveList(intersection.getBounds(), v -> this.visit((JavaType)v, q)));
    }

    @Override
    public JavaType visitClass(JavaType.Class aClass, RpcReceiveQueue q) {
        long flags = ((Number)q.receive((Object)aClass.getFlagsBitMap())).longValue();
        JavaType.FullyQualified.Kind kind = (JavaType.FullyQualified.Kind)((Object)q.receiveAndGet((Object)aClass.getKind(), k -> JavaType.FullyQualified.Kind.valueOf(k.toString())));
        String fqn = (String)q.receive((Object)aClass.getFullyQualifiedName());
        List typeParameters = q.receiveList(aClass.getTypeParameters(), v -> this.visit((JavaType)v, q));
        JavaType.FullyQualified supertype = (JavaType.FullyQualified)q.receive((Object)aClass.getSupertype(), v -> (JavaType.FullyQualified)this.visit((JavaType)v, q));
        JavaType.FullyQualified owningClass = (JavaType.FullyQualified)q.receive((Object)aClass.getOwningClass(), v -> (JavaType.FullyQualified)this.visit((JavaType)v, q));
        List annotations = q.receiveList(aClass.getAnnotations(), v -> (JavaType.FullyQualified)this.visit((JavaType)v, q));
        List interfaces = q.receiveList(aClass.getInterfaces(), v -> (JavaType.FullyQualified)this.visit((JavaType)v, q));
        List members = q.receiveList(aClass.getMembers(), v -> (JavaType.Variable)this.visit((JavaType)v, q));
        List methods = q.receiveList(aClass.getMethods(), v -> (JavaType.Method)this.visit((JavaType)v, q));
        return aClass.unsafeSet(flags, kind, fqn, typeParameters, supertype, owningClass, annotations, interfaces, members, methods);
    }

    @Override
    public JavaType visitParameterized(JavaType.Parameterized parameterized, RpcReceiveQueue q) {
        JavaType.FullyQualified type = (JavaType.FullyQualified)q.receive((Object)parameterized.getType(), v -> (JavaType.FullyQualified)this.visit((JavaType)v, q));
        List typeParameters = q.receiveList(parameterized.getTypeParameters(), v -> this.visit((JavaType)v, q));
        return parameterized.unsafeSet(type, typeParameters);
    }

    @Override
    public JavaType visitGenericTypeVariable(JavaType.GenericTypeVariable generic, RpcReceiveQueue q) {
        String name = (String)q.receive((Object)generic.getName());
        JavaType.GenericTypeVariable.Variance variance = (JavaType.GenericTypeVariable.Variance)((Object)q.receiveAndGet((Object)generic.getVariance(), v -> JavaType.GenericTypeVariable.Variance.valueOf(v.toString())));
        List bounds = q.receiveList(generic.getBounds(), v -> this.visit((JavaType)v, q));
        return generic.unsafeSet(name, variance, bounds);
    }

    @Override
    public JavaType visitArray(JavaType.Array array, RpcReceiveQueue q) {
        JavaType elemType = (JavaType)q.receive((Object)array.getElemType(), v -> this.visit((JavaType)v, q));
        List annotations = q.receiveList(array.getAnnotations(), v -> (JavaType.FullyQualified)this.visit((JavaType)v, q));
        return array.unsafeSet(elemType, (JavaType.FullyQualified[])ListUtils.arrayOrNullIfEmpty((List)annotations, (Object[])JavaType.EMPTY_FULLY_QUALIFIED_ARRAY));
    }

    @Override
    public JavaType visitPrimitive(JavaType.Primitive primitive, RpcReceiveQueue q) {
        String keyword = (String)q.receive((Object)primitive.getKeyword());
        JavaType.Primitive p = JavaType.Primitive.fromKeyword(keyword);
        if (p == null) {
            throw new IllegalArgumentException("Unknown primitive type keyword: " + keyword);
        }
        return p;
    }

    @Override
    public JavaType visitMethod(JavaType.Method method, RpcReceiveQueue q) {
        JavaType.FullyQualified declaringType = (JavaType.FullyQualified)q.receive((Object)method.getDeclaringType(), v -> (JavaType.FullyQualified)this.visit((JavaType)v, q));
        String name = (String)q.receive((Object)method.getName(), null);
        long flags = ((Number)q.receive((Object)method.getFlagsBitMap())).longValue();
        JavaType returnType = (JavaType)q.receive((Object)method.getReturnType(), v -> this.visit((JavaType)v, q));
        List parameterNames = q.receiveList(method.getParameterNames(), null);
        List parameterTypes = q.receiveList(method.getParameterTypes(), v -> this.visit((JavaType)v, q));
        List thrownExceptions = q.receiveList(method.getThrownExceptions(), v -> this.visit((JavaType)v, q));
        List annotations = q.receiveList(method.getAnnotations(), v -> (JavaType.FullyQualified)this.visit((JavaType)v, q));
        List defaultValue = q.receiveList(method.getDefaultValue(), null);
        List declaredFormalTypeNames = q.receiveList(method.getDeclaredFormalTypeNames(), null);
        method.unsafeSet(name, flags, declaringType, returnType, (String[])ListUtils.arrayOrNullIfEmpty((List)parameterNames, (Object[])this.EMPTY_STRING_ARRAY), (JavaType[])ListUtils.arrayOrNullIfEmpty((List)parameterTypes, (Object[])JavaType.EMPTY_JAVA_TYPE_ARRAY), (JavaType[])ListUtils.arrayOrNullIfEmpty((List)thrownExceptions, (Object[])JavaType.EMPTY_JAVA_TYPE_ARRAY), (JavaType.FullyQualified[])ListUtils.arrayOrNullIfEmpty((List)annotations, (Object[])JavaType.EMPTY_FULLY_QUALIFIED_ARRAY), defaultValue, (String[])ListUtils.arrayOrNullIfEmpty((List)declaredFormalTypeNames, (Object[])this.EMPTY_STRING_ARRAY));
        return method;
    }

    @Override
    public JavaType visitVariable(JavaType.Variable variable, RpcReceiveQueue q) {
        String name = (String)q.receive((Object)variable.getName());
        JavaType owner = (JavaType)q.receive((Object)variable.getOwner(), v -> this.visit((JavaType)v, q));
        JavaType type = (JavaType)q.receive((Object)variable.getType(), v -> this.visit((JavaType)v, q));
        List annotations = q.receiveList(variable.getAnnotations(), v -> (JavaType.FullyQualified)this.visit((JavaType)v, q));
        return variable.unsafeSet(name, owner, type, (JavaType.FullyQualified[])ListUtils.arrayOrNullIfEmpty((List)annotations, (Object[])JavaType.EMPTY_FULLY_QUALIFIED_ARRAY));
    }
}

