/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.openrewrite.java.internal.parser.AnnotationDeserializer;

class AnnotationAttributeApplier {
    AnnotationAttributeApplier() {
    }

    public static void applyAttributes(AnnotationVisitor av, @Nullable List<AnnotationDeserializer.AttributeInfo> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (AnnotationDeserializer.AttributeInfo attribute : attributes) {
            AnnotationAttributeApplier.applyParsedValue(av, attribute.getName(), attribute.getValue());
        }
    }

    public static void applyParsedValue(AnnotationVisitor av, @Nullable String attributeName, Object parsedValue) {
        if (parsedValue instanceof Boolean || parsedValue instanceof Character || parsedValue instanceof Number) {
            av.visit(attributeName, parsedValue);
        } else if (parsedValue instanceof String) {
            String stringValue = (String)parsedValue;
            if (stringValue.startsWith("\"") && stringValue.endsWith("\"")) {
                stringValue = stringValue.substring(1, stringValue.length() - 1);
            }
            av.visit(attributeName, (Object)stringValue);
        } else if (parsedValue instanceof AnnotationDeserializer.ClassConstant) {
            String classDescriptor = ((AnnotationDeserializer.ClassConstant)parsedValue).getDescriptor();
            av.visit(attributeName, (Object)Type.getType((String)classDescriptor));
        } else if (parsedValue instanceof AnnotationDeserializer.EnumConstant) {
            AnnotationDeserializer.EnumConstant enumConstant = (AnnotationDeserializer.EnumConstant)parsedValue;
            av.visitEnum(attributeName, enumConstant.getEnumDescriptor(), enumConstant.getConstantName());
        } else if (parsedValue instanceof AnnotationDeserializer.AnnotationInfo) {
            AnnotationAttributeApplier.applyNestedAnnotation(av, attributeName, (AnnotationDeserializer.AnnotationInfo)parsedValue);
        } else if (parsedValue instanceof Object[]) {
            AnnotationAttributeApplier.applyArrayAttribute(av, attributeName, (Object[])parsedValue);
        }
    }

    private static void applyNestedAnnotation(AnnotationVisitor av, @Nullable String attributeName, AnnotationDeserializer.AnnotationInfo nestedAnnotationInfo) {
        AnnotationVisitor nestedAv = av.visitAnnotation(attributeName, nestedAnnotationInfo.getDescriptor());
        if (nestedAv != null) {
            AnnotationAttributeApplier.applyAttributes(nestedAv, nestedAnnotationInfo.getAttributes());
            nestedAv.visitEnd();
        }
    }

    private static void applyArrayAttribute(AnnotationVisitor av, @Nullable String attributeName, Object[] arrayValues) {
        AnnotationVisitor arrayVisitor = av.visitArray(attributeName);
        if (arrayVisitor != null) {
            for (Object arrayValue : arrayValues) {
                AnnotationAttributeApplier.applyParsedValue(arrayVisitor, null, arrayValue);
            }
            arrayVisitor.visitEnd();
        }
    }
}

