/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.format.AutoFormatVisitor;
import org.openrewrite.style.NamedStyles;

public final class AutoFormat
extends Recipe {
    @Option(displayName="Style", description="See https://docs.openrewrite.org/concepts-and-explanations/styles for a description on styles.", example="type: specs.openrewrite.org/v1beta/style\nname: com.yourorg.YesTabsNoStarImports\nstyleConfigs:\n  - org.openrewrite.java.style.TabsAndIndentsStyle:\n      useTabCharacter: true", required=false)
    private final @Nullable String style;

    public String getDisplayName() {
        return "Format Java code";
    }

    public String getDescription() {
        return "Format Java code using a standard comprehensive set of Java formatting recipes.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AutoFormatVisitor<ExecutionContext>(null, this.computeNamedStyles());
    }

    private NamedStyles[] computeNamedStyles() {
        if (this.style == null) {
            return new NamedStyles[0];
        }
        return new YamlResourceLoader((InputStream)new ByteArrayInputStream(this.style.getBytes()), URI.create("AutoFormat$style"), new Properties()).listStyles().toArray(new NamedStyles[0]);
    }

    @Generated
    public AutoFormat(@Nullable String style) {
        this.style = style;
    }

    @Generated
    public @Nullable String getStyle() {
        return this.style;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AutoFormat(style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoFormat)) {
            return false;
        }
        AutoFormat other = (AutoFormat)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AutoFormat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }
}

