/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.JavaType;

public class JavaTypeVisitor<P> {
    private Cursor cursor = new Cursor(null, (Object)"root");

    public <JT extends JavaType> @Nullable List<JT> visit(@Nullable List<JT> javaTypes, P p) {
        return ListUtils.map(javaTypes, jt -> this.visit((JavaType)jt, p));
    }

    public @Nullable JavaType preVisit(JavaType javaType, P p) {
        return javaType;
    }

    public @Nullable JavaType postVisit(JavaType javaType, P p) {
        return javaType;
    }

    public JavaType visitNonNull(JavaType javaType, P p) {
        JavaType t = this.visit(javaType, p);
        assert (t != null);
        return t;
    }

    public JavaType visit(@Nullable JavaType javaType, P p) {
        if (javaType != null) {
            this.cursor = new Cursor(this.cursor, (Object)javaType);
            if ((javaType = this.preVisit(javaType, p)) instanceof JavaType.Array) {
                javaType = this.visitArray((JavaType.Array)javaType, p);
            } else if (javaType instanceof JavaType.Annotation) {
                javaType = this.visitAnnotation((JavaType.Annotation)javaType, p);
            } else if (javaType instanceof JavaType.Class) {
                javaType = this.visitClass((JavaType.Class)javaType, p);
            } else if (javaType instanceof JavaType.GenericTypeVariable) {
                javaType = this.visitGenericTypeVariable((JavaType.GenericTypeVariable)javaType, p);
            } else if (javaType instanceof JavaType.Intersection) {
                javaType = this.visitIntersection((JavaType.Intersection)javaType, p);
            } else if (javaType instanceof JavaType.MultiCatch) {
                javaType = this.visitMultiCatch((JavaType.MultiCatch)javaType, p);
            } else if (javaType instanceof JavaType.Parameterized) {
                javaType = this.visitParameterized((JavaType.Parameterized)javaType, p);
            } else if (javaType instanceof JavaType.Primitive) {
                javaType = this.visitPrimitive((JavaType.Primitive)javaType, p);
            } else if (javaType instanceof JavaType.Method) {
                javaType = this.visitMethod((JavaType.Method)javaType, p);
            } else if (javaType instanceof JavaType.Variable) {
                javaType = this.visitVariable((JavaType.Variable)javaType, p);
            } else if (javaType instanceof JavaType.Unknown) {
                javaType = this.visitUnknown((JavaType.Unknown)javaType, p);
            }
            if (javaType != null) {
                javaType = this.postVisit(javaType, p);
            }
            this.cursor = this.cursor.getParentOrThrow();
            return javaType;
        }
        return null;
    }

    public JavaType visitMultiCatch(JavaType.MultiCatch multiCatch, P p) {
        multiCatch.unsafeSet(this.visit(multiCatch.getThrowableTypes(), p));
        return multiCatch;
    }

    public JavaType visitAnnotation(JavaType.Annotation annotation, P p) {
        annotation.unsafeSet((JavaType.FullyQualified)this.visit(annotation.getType(), p), (JavaType.Annotation.ElementValue[])ListUtils.arrayOrNullIfEmpty(annotation.getValues(), (Object[])JavaType.EMPTY_ANNOTATION_VALUE_ARRAY));
        return annotation;
    }

    public JavaType visitArray(JavaType.Array array, P p) {
        array.unsafeSet(this.visit(array.getElemType(), p), (JavaType.FullyQualified[])ListUtils.arrayOrNullIfEmpty(this.visit(array.getAnnotations(), p), (Object[])JavaType.EMPTY_FULLY_QUALIFIED_ARRAY));
        return array;
    }

    public JavaType visitClass(JavaType.Class aClass, P p) {
        aClass.unsafeSet(this.visit(aClass.getTypeParameters(), p), (JavaType.FullyQualified)this.visit(aClass.getSupertype(), p), (JavaType.FullyQualified)this.visit(aClass.getOwningClass(), p), ListUtils.map(aClass.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)), ListUtils.map(aClass.getInterfaces(), i -> (JavaType.FullyQualified)this.visit((JavaType)i, p)), ListUtils.map(aClass.getMembers(), m -> (JavaType.Variable)this.visit((JavaType)m, p)), ListUtils.map(aClass.getMethods(), m -> (JavaType.Method)this.visit((JavaType)m, p)));
        return aClass;
    }

    public JavaType visitGenericTypeVariable(JavaType.GenericTypeVariable generic, P p) {
        generic.unsafeSet(generic.getName(), generic.getVariance(), this.visit(generic.getBounds(), p));
        return generic;
    }

    public JavaType visitIntersection(JavaType.Intersection intersection, P p) {
        intersection.unsafeSet(this.visit(intersection.getBounds(), p));
        return intersection;
    }

    public JavaType visitMethod(JavaType.Method method, P p) {
        method.unsafeSet((JavaType.FullyQualified)this.visit(method.getDeclaringType(), p), this.visit(method.getReturnType(), p), this.visit(method.getParameterTypes(), p), this.visit(method.getThrownExceptions(), p), ListUtils.map(method.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
        return method;
    }

    public JavaType visitParameterized(JavaType.Parameterized parameterized, P p) {
        parameterized.unsafeSet((JavaType.FullyQualified)this.visit(parameterized.getType(), p), this.visit(parameterized.getTypeParameters(), p));
        return parameterized;
    }

    public JavaType visitPrimitive(JavaType.Primitive primitive, P p) {
        return primitive;
    }

    public JavaType visitUnknown(JavaType.Unknown unknown, P p) {
        return unknown;
    }

    public JavaType visitVariable(JavaType.Variable variable, P p) {
        variable.unsafeSet(this.visit(variable.getOwner(), p), this.visit(variable.getType(), p), ListUtils.map(variable.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
        return variable;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }
}

