/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

public final class AddCommentToMethodInvocations
extends Recipe {
    @Option(displayName="Comment", description="The comment to add.", example="This is a comment.")
    private final String comment;
    @Option(displayName="Method pattern", description="A pattern to match methods to add the comment to. A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method invocations. For example, to find all method invocations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.", example="java.util.List add*(..)")
    private final String methodPattern;

    public String getDisplayName() {
        return "Add comment to method invocations";
    }

    public String getDescription() {
        return "Add a comment to method invocations in a Java source file.";
    }

    public Validated<Object> validate() {
        return super.validate().and(MethodMatcher.validate(this.methodPattern));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern);
        return Preconditions.check(new UsesMethod(methodMatcher), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                return (J.MethodInvocation)this.handleMethodCallComment(m, ctx);
            }

            @Override
            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J nc = super.visitNewClass(newClass, ctx);
                return (J.NewClass)this.handleMethodCallComment(nc, ctx);
            }

            private <T extends MethodCall> T handleMethodCallComment(T t, ExecutionContext ctx) {
                if (methodMatcher.matches(t)) {
                    String prefixWhitespace = t.getPrefix().getWhitespace();
                    String newCommentText = AddCommentToMethodInvocations.this.comment.trim().replaceAll("\\R", " * ").replace("*/", "*");
                    if (this.doesNotHaveComment(newCommentText, t.getComments())) {
                        TextComment textComment = new TextComment(true, " " + newCommentText + " ", prefixWhitespace, Markers.EMPTY);
                        return (T)((MethodCall)t.withComments(ListUtils.concat(t.getComments(), (Object)textComment)));
                    }
                }
                return t;
            }

            private boolean doesNotHaveComment(String lookFor, List<Comment> comments) {
                for (Comment c : comments) {
                    if (!(c instanceof TextComment) || !lookFor.trim().equals(((TextComment)c).getText().trim())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Generated
    public AddCommentToMethodInvocations(String comment, String methodPattern) {
        this.comment = comment;
        this.methodPattern = methodPattern;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddCommentToMethodInvocations(comment=" + this.getComment() + ", methodPattern=" + this.getMethodPattern() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddCommentToMethodInvocations)) {
            return false;
        }
        AddCommentToMethodInvocations other = (AddCommentToMethodInvocations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddCommentToMethodInvocations;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

