/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.util.CheckClassAdapter;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaParserExecutionContextView;
import org.openrewrite.java.internal.parser.AnnotationApplier;
import org.openrewrite.java.internal.parser.AnnotationCollectorHelper;
import org.openrewrite.java.internal.parser.AnnotationDeserializer;
import org.openrewrite.java.internal.parser.AnnotationSerializer;
import org.openrewrite.java.internal.parser.JavaParserCaller;
import org.openrewrite.java.internal.parser.JavaParserClasspathLoader;
import org.openrewrite.java.internal.parser.TsvEscapeUtils;
import org.openrewrite.java.internal.parser.TypeAnnotationSupport;

@Incubating(since="8.44.0")
public final class TypeTable
implements JavaParserClasspathLoader {
    public static final String VERIFY_CLASS_WRITING = "org.openrewrite.java.TypeTableClassWritingVerification";
    public static final String DEFAULT_RESOURCE_PATH = "META-INF/rewrite/classpath.tsv.gz";
    private static final Map<GroupArtifactVersion, CompletableFuture<Path>> classesDirByArtifact = new ConcurrentHashMap<GroupArtifactVersion, CompletableFuture<Path>>();

    public static @Nullable TypeTable fromClasspath(ExecutionContext ctx, Collection<String> artifactNames) {
        try {
            ClassLoader classLoader = JavaParserCaller.findCaller().getClassLoader();
            Vector<URL> combinedResources = new Vector<URL>();
            Enumeration<URL> e = classLoader.getResources(DEFAULT_RESOURCE_PATH);
            while (e.hasMoreElements()) {
                combinedResources.add(e.nextElement());
            }
            e = classLoader.getResources(DEFAULT_RESOURCE_PATH.replace(".gz", ".zip"));
            while (e.hasMoreElements()) {
                combinedResources.add(e.nextElement());
            }
            if (!combinedResources.isEmpty()) {
                return new TypeTable(ctx, combinedResources.elements(), artifactNames);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    TypeTable(ExecutionContext ctx, URL url, Collection<String> artifactNames) {
        TypeTable.read(url, artifactNames, ctx);
    }

    TypeTable(ExecutionContext ctx, Enumeration<URL> resources, Collection<String> artifactNames) {
        while (resources.hasMoreElements()) {
            TypeTable.read(resources.nextElement(), artifactNames, ctx);
        }
    }

    private static void read(URL url, Collection<String> artifactNames, ExecutionContext ctx) {
        Collection<String> missingArtifacts = TypeTable.artifactsNotYetWritten(artifactNames);
        if (missingArtifacts.isEmpty()) {
            return;
        }
        Reader.Options options = Reader.Options.builder().artifactPrefixes(artifactNames).build();
        try (InputStream is = url.openStream();
             GZIPInputStream inflate = new GZIPInputStream(is);){
            new Reader(ctx).read(inflate, options);
        }
        catch (ZipException e) {
            try (InputStream is2 = url.openStream();
                 InflaterInputStream inflate2 = new InflaterInputStream(is2);){
                new Reader(ctx).read(inflate2, options);
            }
            catch (IOException e1) {
                throw new UncheckedIOException(e1);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Collection<String> artifactsNotYetWritten(Collection<String> artifactNames) {
        ArrayList<String> notWritten = new ArrayList<String>(artifactNames);
        for (String artifactName : artifactNames) {
            Pattern artifactPattern = Pattern.compile(artifactName + ".*");
            for (GroupArtifactVersion groupArtifactVersion : classesDirByArtifact.keySet()) {
                if (!artifactPattern.matcher(groupArtifactVersion.getArtifactId() + "-" + groupArtifactVersion.getVersion()).matches()) continue;
                notWritten.remove(artifactName);
            }
        }
        return notWritten;
    }

    private static boolean isValidConstantValueType(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        return value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean || value instanceof Character || value instanceof Byte || value instanceof Short;
    }

    private static Path getClassesDir(ExecutionContext ctx, GroupArtifactVersion gav) {
        Path jarsFolder = JavaParserExecutionContextView.view(ctx).getParserClasspathDownloadTarget().toPath().resolve(".tt");
        if (!jarsFolder.toFile().mkdirs() && !Files.exists(jarsFolder, new LinkOption[0])) {
            throw new UncheckedIOException(new IOException("Failed to create directory " + jarsFolder));
        }
        Path classesDir = jarsFolder;
        for (String g : gav.getGroupId().split("\\.")) {
            classesDir = classesDir.resolve(g);
        }
        if (!(classesDir = classesDir.resolve(gav.getArtifactId()).resolve(gav.getVersion())).toFile().mkdirs() && !Files.exists(classesDir, new LinkOption[0])) {
            throw new UncheckedIOException(new IOException("Failed to create directory " + classesDir));
        }
        return classesDir;
    }

    public static Writer newWriter(OutputStream out) {
        try {
            return new Writer(out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public @Nullable Path load(String artifactName) {
        for (Map.Entry<GroupArtifactVersion, CompletableFuture<Path>> gavAndClassesDir : classesDirByArtifact.entrySet()) {
            GroupArtifactVersion gav = gavAndClassesDir.getKey();
            if (!Pattern.compile(artifactName + ".*").matcher(gav.getArtifactId() + "-" + gav.getVersion()).matches()) continue;
            return gavAndClassesDir.getValue().join();
        }
        return null;
    }

    private static String serializeParameterAnnotations(List<String> parameterAnnotations, String descriptor) {
        if (parameterAnnotations.isEmpty()) {
            return "";
        }
        Type methodType = Type.getMethodType((String)descriptor);
        int paramCount = methodType.getArgumentTypes().length;
        TreeMap<Integer, List> annotationsByParam = new TreeMap<Integer, List>();
        for (String paramAnnotation : parameterAnnotations) {
            int colonIdx = paramAnnotation.indexOf(58);
            if (colonIdx <= 0) continue;
            int paramIndex = Integer.parseInt(paramAnnotation.substring(0, colonIdx));
            String annotation = paramAnnotation.substring(colonIdx + 1);
            annotationsByParam.computeIfAbsent(paramIndex, k -> new ArrayList()).add(annotation);
        }
        if (annotationsByParam.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < paramCount; ++i) {
            List annotations;
            if (i > 0) {
                result.append('|');
            }
            if ((annotations = (List)annotationsByParam.get(i)) == null || annotations.isEmpty()) continue;
            for (String annotation : annotations) {
                result.append(PipeDelimitedJoiner.escapePipes(annotation));
            }
        }
        return result.toString();
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof TypeTable;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @NonNull
    @Generated
    public String toString() {
        return "TypeTable()";
    }

    static final class GroupArtifactVersion {
        private final String groupId;
        private final String artifactId;
        private final String version;

        @Generated
        public GroupArtifactVersion(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupArtifactVersion)) {
                return false;
            }
            GroupArtifactVersion other = (GroupArtifactVersion)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TypeTable.GroupArtifactVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
        }
    }

    public static class Reader {
        private static final int NESTED_TYPE_ACCESS_MASK = 30239;
        private final ExecutionContext ctx;

        public void read(InputStream is, Options options) throws IOException {
            this.parseTsvAndProcess(is, options, this::writeClassesDir);
        }

        public void read(InputStream is, Options options, Supplier<ClassVisitor> visitorSupplier) throws IOException {
            this.parseTsvAndProcess(is, options, (gav, classes, nestedTypes) -> {
                for (ClassDefinition classDef : classes.values()) {
                    this.processClass(classDef, nestedTypes.getOrDefault(classDef.getName(), Collections.emptyList()), (ClassVisitor)visitorSupplier.get());
                }
            });
        }

        public void parseTsvAndProcess(InputStream is, Options options, ClassesProcessor processor) throws IOException {
            AtomicReference<@Nullable V> matchedGav = new AtomicReference();
            HashMap<String, ClassDefinition> classesByName = new HashMap<String, ClassDefinition>();
            HashMap<String, List<ClassDefinition>> nestedTypesByOwner = new HashMap<String, List<ClassDefinition>>();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(is));){
                AtomicReference<@Nullable V> lastGav = new AtomicReference();
                in.lines().skip(1L).forEach(line -> {
                    String[] fields = line.split("\t", -1);
                    GroupArtifactVersion rowGav = new GroupArtifactVersion(fields[0], fields[1], fields[2]);
                    if (!Objects.equals(rowGav, lastGav.get())) {
                        if (matchedGav.get() != null) {
                            processor.accept((GroupArtifactVersion)matchedGav.get(), classesByName, nestedTypesByOwner);
                        }
                        matchedGav.set(null);
                        classesByName.clear();
                        nestedTypesByOwner.clear();
                        String artifactVersion = fields[1] + "-" + fields[2];
                        if (options.getArtifactMatcher().test(artifactVersion)) {
                            matchedGav.set(rowGav);
                        }
                    }
                    lastGav.set(rowGav);
                    if (matchedGav.get() != null) {
                        int memberAccess;
                        String className = fields[4];
                        ClassDefinition classDefinition = classesByName.computeIfAbsent(className, name -> new ClassDefinition(Integer.parseInt(fields[3]), (String)name, fields[5].isEmpty() ? null : fields[5], fields[6].isEmpty() ? null : fields[6], fields[7].isEmpty() ? null : fields[7].split("\\|"), fields.length > 14 && !fields[14].isEmpty() ? fields[14] : null, fields.length > 17 && !fields[17].isEmpty() ? fields[17] : null));
                        int lastIndexOf$ = className.lastIndexOf(36);
                        if (lastIndexOf$ != -1) {
                            String ownerName = className.substring(0, lastIndexOf$);
                            nestedTypesByOwner.computeIfAbsent(ownerName, k -> new ArrayList(4)).add(classDefinition);
                        }
                        if ((memberAccess = Integer.parseInt(fields[8])) != -1) {
                            classDefinition.addMember(new Member(classDefinition, memberAccess, fields[9], fields[10], fields[11].isEmpty() ? null : fields[11], fields[12].isEmpty() ? null : fields[12].split("\\|"), fields[13].isEmpty() ? null : fields[13].split("\\|"), fields.length > 14 && !fields[14].isEmpty() ? fields[14] : null, fields.length > 15 && !fields[15].isEmpty() ? fields[15] : null, fields.length > 16 && !fields[16].isEmpty() ? TsvEscapeUtils.splitAnnotationList(fields[16], '|') : null, fields.length > 17 && !fields[17].isEmpty() ? fields[17] : null));
                        }
                    }
                });
            }
            if (matchedGav.get() != null) {
                processor.accept((GroupArtifactVersion)matchedGav.get(), classesByName, nestedTypesByOwner);
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void writeClassesDir(@Nullable GroupArtifactVersion gav, Map<String, ClassDefinition> classes, Map<String, List<ClassDefinition>> nestedTypesByOwner) {
            if (gav == null) {
                return;
            }
            CompletableFuture<@Nullable Path> future = new CompletableFuture<Path>();
            if (classesDirByArtifact.putIfAbsent(gav, future) != null) {
                return;
            }
            Path classesDir = TypeTable.getClassesDir(this.ctx, gav);
            try {
                classes.values().forEach(classDef -> {
                    @Nullable Path classFile = classesDir.resolve(classDef.getName() + ".class");
                    if (!classFile.getParent().toFile().mkdirs() && !Files.exists(classFile.getParent(), new LinkOption[0])) {
                        throw new UncheckedIOException(new IOException("Failed to create directory " + classesDir.getParent()));
                    }
                    ClassWriter cw = new ClassWriter(1);
                    ClassWriter classWriter = (Boolean)this.ctx.getMessage(TypeTable.VERIFY_CLASS_WRITING, (Object)false) != false ? new CheckClassAdapter((ClassVisitor)cw) : cw;
                    this.processClass((ClassDefinition)classDef, nestedTypesByOwner.getOrDefault(classDef.getName(), Collections.emptyList()), (ClassVisitor)classWriter);
                    try {
                        Files.write(classFile, cw.toByteArray(), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
                future.complete(classesDir);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        }

        private void processClass(ClassDefinition classDef, List<ClassDefinition> nestedTypes, ClassVisitor classVisitor) {
            classVisitor.visit(52, classDef.getAccess(), classDef.getName(), classDef.getSignature(), classDef.getSuperclassSignature(), classDef.getSuperinterfaceSignatures());
            if (classDef.getAnnotations() != null) {
                AnnotationApplier.applyAnnotations(classDef.getAnnotations(), (arg_0, arg_1) -> ((ClassVisitor)classVisitor).visitAnnotation(arg_0, arg_1));
            }
            for (ClassDefinition innerClassDef : nestedTypes) {
                classVisitor.visitInnerClass(innerClassDef.getName(), classDef.getName(), innerClassDef.getName().substring(classDef.getName().length() + 1), innerClassDef.getAccess() & 0x761F);
            }
            for (Member member : classDef.getMembers()) {
                FieldVisitor fv;
                Object parsedValue;
                if (member.getDescriptor().startsWith("(")) {
                    AnnotationVisitor annotationDefaultVisitor;
                    String[] parameterNames;
                    MethodVisitor mv = classVisitor.visitMethod(member.getAccess(), member.getName(), member.getDescriptor(), member.getSignature(), member.getExceptions());
                    if (mv == null) continue;
                    if (member.getAnnotations() != null) {
                        AnnotationApplier.applyAnnotations(member.getAnnotations(), (arg_0, arg_1) -> ((MethodVisitor)mv).visitAnnotation(arg_0, arg_1));
                    }
                    if (member.getParameterAnnotations() != null && !member.getParameterAnnotations().isEmpty()) {
                        String[] paramAnnotations = TsvEscapeUtils.splitAnnotationList(member.getParameterAnnotations(), '|');
                        for (int i = 0; i < paramAnnotations.length; ++i) {
                            int paramIndex = i;
                            String annotationsPart = paramAnnotations[i];
                            if (annotationsPart.isEmpty()) continue;
                            AnnotationApplier.applyAnnotations(annotationsPart, (descriptor, visible) -> mv.visitParameterAnnotation(paramIndex, descriptor, visible));
                        }
                    }
                    if (member.getTypeAnnotations() != null) {
                        for (String typeAnnotation : member.getTypeAnnotations()) {
                            TypeAnnotationSupport.TypeAnnotationInfo info = TypeAnnotationSupport.TypeAnnotationInfo.parse(typeAnnotation);
                            AnnotationApplier.applyAnnotation(info.annotation, (descriptor, visible) -> mv.visitTypeAnnotation(info.typeRef, info.typePath, descriptor, visible));
                        }
                    }
                    if ((parameterNames = member.getParameterNames()) != null) {
                        for (String parameterName : parameterNames) {
                            mv.visitParameter(parameterName, 0);
                        }
                    }
                    if (member.getConstantValue() != null && (annotationDefaultVisitor = mv.visitAnnotationDefault()) != null) {
                        AnnotationSerializer.processAnnotationDefaultValue(annotationDefaultVisitor, AnnotationDeserializer.parseValue(member.getConstantValue()));
                        annotationDefaultVisitor.visitEnd();
                    }
                    this.writeMethodBody(member, mv);
                    mv.visitEnd();
                    continue;
                }
                Object constantValue = null;
                if ((member.getAccess() & 0x18) == 24 && member.getConstantValue() != null && TypeTable.isValidConstantValueType(parsedValue = AnnotationDeserializer.parseValue(member.getConstantValue()))) {
                    constantValue = parsedValue;
                }
                if ((fv = classVisitor.visitField(member.getAccess(), member.getName(), member.getDescriptor(), member.getSignature(), constantValue)) == null) continue;
                if (member.getAnnotations() != null) {
                    AnnotationApplier.applyAnnotations(member.getAnnotations(), (arg_0, arg_1) -> ((FieldVisitor)fv).visitAnnotation(arg_0, arg_1));
                }
                if (member.getTypeAnnotations() != null) {
                    for (String typeAnnotation : member.getTypeAnnotations()) {
                        TypeAnnotationSupport.TypeAnnotationInfo info = TypeAnnotationSupport.TypeAnnotationInfo.parse(typeAnnotation);
                        AnnotationApplier.applyAnnotation(info.annotation, (descriptor, visible) -> fv.visitTypeAnnotation(info.typeRef, info.typePath, descriptor, visible));
                    }
                }
                fv.visitEnd();
            }
            classVisitor.visitEnd();
        }

        private void writeMethodBody(Member member, MethodVisitor mv) {
            if ((member.getAccess() & 0x400) == 0) {
                mv.visitCode();
                if ("<init>".equals(member.getName())) {
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(183, member.getClassDefinition().getSuperclassSignature(), "<init>", "()V", false);
                }
                Type returnType = Type.getReturnType((String)member.getDescriptor());
                switch (returnType.getSort()) {
                    case 0: {
                        mv.visitInsn(177);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        mv.visitInsn(3);
                        mv.visitInsn(172);
                        break;
                    }
                    case 7: {
                        mv.visitInsn(9);
                        mv.visitInsn(173);
                        break;
                    }
                    case 6: {
                        mv.visitInsn(11);
                        mv.visitInsn(174);
                        break;
                    }
                    case 8: {
                        mv.visitInsn(14);
                        mv.visitInsn(175);
                        break;
                    }
                    case 9: 
                    case 10: {
                        mv.visitInsn(1);
                        mv.visitInsn(176);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown return type: " + returnType);
                    }
                }
                mv.visitMaxs(0, 0);
            }
        }

        @Generated
        public Reader(ExecutionContext ctx) {
            this.ctx = ctx;
        }

        @FunctionalInterface
        static interface ClassesProcessor {
            public void accept(@Nullable GroupArtifactVersion var1, Map<String, ClassDefinition> var2, Map<String, List<ClassDefinition>> var3);
        }

        public static class Options {
            private final Predicate<String> artifactMatcher;

            public static Options matchAll() {
                return Options.builder().build();
            }

            @Generated
            private static Predicate<String> $default$artifactMatcher() {
                return gav -> true;
            }

            @NonNull
            @Generated
            public static Builder builder() {
                return new Builder();
            }

            @Generated
            private Options(Predicate<String> artifactMatcher) {
                this.artifactMatcher = artifactMatcher;
            }

            @Generated
            Predicate<String> getArtifactMatcher() {
                return this.artifactMatcher;
            }

            public static class Builder {
                @Generated
                private boolean artifactMatcher$set;
                @Generated
                private Predicate<String> artifactMatcher$value;

                public Builder artifactPrefixes(Collection<String> artifactPrefixes) {
                    Set patterns = artifactPrefixes.stream().map(prefix -> Pattern.compile(prefix + ".*")).collect(Collectors.toSet());
                    this.artifactMatcher(artifactVersion -> patterns.stream().anyMatch(pattern -> pattern.matcher((CharSequence)artifactVersion).matches()));
                    return this;
                }

                @Generated
                Builder() {
                }

                @NonNull
                @Generated
                public Builder artifactMatcher(Predicate<String> artifactMatcher) {
                    this.artifactMatcher$value = artifactMatcher;
                    this.artifactMatcher$set = true;
                    return this;
                }

                @NonNull
                @Generated
                public Options build() {
                    Predicate artifactMatcher$value = this.artifactMatcher$value;
                    if (!this.artifactMatcher$set) {
                        artifactMatcher$value = Options.$default$artifactMatcher();
                    }
                    return new Options(artifactMatcher$value);
                }

                @NonNull
                @Generated
                public String toString() {
                    return "TypeTable.Reader.Options.Builder(artifactMatcher$value=" + this.artifactMatcher$value + ")";
                }
            }
        }
    }

    public static class Writer
    implements AutoCloseable {
        private final PrintStream out;
        private final GZIPOutputStream deflater;

        public Writer(OutputStream out) throws IOException {
            this.deflater = new GZIPOutputStream(out);
            this.out = new PrintStream(this.deflater);
            this.out.println("groupId\tartifactId\tversion\tclassAccess\tclassName\tclassSignature\tclassSuperclassSignature\tclassSuperinterfaceSignatures\taccess\tname\tdescriptor\tsignature\tparameterNames\texceptions\telementAnnotations\tparameterAnnotations\ttypeAnnotations\tconstantValue");
        }

        public Jar jar(String groupId, String artifactId, String version) {
            return new Jar(groupId, artifactId, version);
        }

        @Override
        public void close() throws IOException {
            this.deflater.flush();
            this.out.close();
        }

        public final class Jar {
            private final String groupId;
            private final String artifactId;
            private final String version;

            public void write(Path jar) {
                try (JarFile jarFile = new JarFile(jar.toFile());){
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".class")) continue;
                        InputStream inputStream = jarFile.getInputStream(entry);
                        try {
                            this.writeClass(inputStream);
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public void writeClass(InputStream classInputStream) throws IOException {
                new ClassReader(classInputStream).accept(new ClassVisitor(589824){
                    @Nullable ClassDefinition classDefinition;

                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        int lastIndexOf$ = name.lastIndexOf(36);
                        if (lastIndexOf$ != -1 && lastIndexOf$ < name.length() - 1 && !Character.isJavaIdentifierStart(name.charAt(lastIndexOf$ + 1))) {
                            this.classDefinition = null;
                        } else {
                            this.classDefinition = new ClassDefinition(Jar.this, access, name, signature, superName, interfaces);
                            super.visit(version, access, name, signature, superName, interfaces);
                        }
                    }

                    public @Nullable AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        if (this.classDefinition != null) {
                            return AnnotationCollectorHelper.createCollector(descriptor, Objects.requireNonNull(this.classDefinition).classAnnotations);
                        }
                        return null;
                    }

                    public @Nullable AnnotationVisitor visitTypeAnnotation(final int typeRef, final TypePath typePath, String descriptor, boolean visible) {
                        if (this.classDefinition != null) {
                            final ArrayList<String> tempCollector = new ArrayList<String>();
                            AnnotationVisitor collector = AnnotationCollectorHelper.createCollector(descriptor, tempCollector);
                            return new AnnotationVisitor(589824, collector){

                                public void visitEnd() {
                                    super.visitEnd();
                                    if (!tempCollector.isEmpty()) {
                                        String annotation = (String)tempCollector.get(0);
                                        String formatted = TypeAnnotationSupport.formatTypeAnnotation(typeRef, typePath, annotation);
                                        classDefinition.classTypeAnnotations.add(formatted);
                                    }
                                }
                            };
                        }
                        return null;
                    }

                    public @Nullable FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                        if (this.classDefinition != null) {
                            final Member member = new Member(access, name, descriptor, signature, null, null);
                            if ((access & 0x18) == 24 && TypeTable.isValidConstantValueType(value)) {
                                member.constantValue = AnnotationSerializer.convertConstantValueWithType(value, descriptor);
                            }
                            return new FieldVisitor(589824){

                                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                                    return AnnotationCollectorHelper.createCollector(descriptor, member.elementAnnotations);
                                }

                                public AnnotationVisitor visitTypeAnnotation(final int typeRef, final TypePath typePath, String descriptor, boolean visible) {
                                    final ArrayList<String> tempCollector = new ArrayList<String>();
                                    AnnotationVisitor collector = AnnotationCollectorHelper.createCollector(descriptor, tempCollector);
                                    return new AnnotationVisitor(589824, collector){

                                        public void visitEnd() {
                                            super.visitEnd();
                                            if (!tempCollector.isEmpty()) {
                                                String annotation = (String)tempCollector.get(0);
                                                String formatted = TypeAnnotationSupport.formatTypeAnnotation(typeRef, typePath, annotation);
                                                member.typeAnnotations.add(formatted);
                                            }
                                        }
                                    };
                                }

                                public void visitEnd() {
                                    classDefinition.addField(member);
                                }
                            };
                        }
                        return null;
                    }

                    public @Nullable MethodVisitor visitMethod(int access, @Nullable String name, String descriptor, @Nullable String signature, String @Nullable [] exceptions) {
                        if (this.classDefinition != null && (0x1002 & access) == 0 && name != null && !"<clinit>".equals(name)) {
                            final Member member = new Member(access, name, descriptor, signature, exceptions, null);
                            return new MethodVisitor(589824){

                                public void visitParameter(@Nullable String name, int access) {
                                    if (name != null) {
                                        member.parameterNames.add(name);
                                    }
                                }

                                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                                    return AnnotationCollectorHelper.createCollector(descriptor, member.elementAnnotations);
                                }

                                public AnnotationVisitor visitParameterAnnotation(final int parameter, String descriptor, boolean visible) {
                                    final ArrayList<String> tempCollector = new ArrayList<String>();
                                    AnnotationVisitor collector = AnnotationCollectorHelper.createCollector(descriptor, tempCollector);
                                    return new AnnotationVisitor(589824, collector){

                                        public void visitEnd() {
                                            super.visitEnd();
                                            if (!tempCollector.isEmpty()) {
                                                member.parameterAnnotations.add(parameter + ":" + (String)tempCollector.get(0));
                                            }
                                        }
                                    };
                                }

                                public AnnotationVisitor visitTypeAnnotation(final int typeRef, final TypePath typePath, String descriptor, boolean visible) {
                                    final ArrayList<String> tempCollector = new ArrayList<String>();
                                    AnnotationVisitor collector = AnnotationCollectorHelper.createCollector(descriptor, tempCollector);
                                    return new AnnotationVisitor(589824, collector){

                                        public void visitEnd() {
                                            super.visitEnd();
                                            if (!tempCollector.isEmpty()) {
                                                String annotation = (String)tempCollector.get(0);
                                                String formatted = TypeAnnotationSupport.formatTypeAnnotation(typeRef, typePath, annotation);
                                                member.typeAnnotations.add(formatted);
                                            }
                                        }
                                    };
                                }

                                public AnnotationVisitor visitAnnotationDefault() {
                                    final ArrayList nested = new ArrayList();
                                    return new AnnotationVisitor(589824){

                                        public void visit(String name, Object value) {
                                            member.constantValue = AnnotationSerializer.convertAnnotationValueToString(value);
                                        }

                                        public AnnotationVisitor visitArray(String name) {
                                            return new AnnotationVisitor(589824){
                                                final List<String> arrayValues;
                                                {
                                                    this.arrayValues = new ArrayList<String>();
                                                }

                                                public void visit(String name, Object value) {
                                                    this.arrayValues.add(AnnotationSerializer.convertAnnotationValueToString(value));
                                                }

                                                public void visitEnd() {
                                                    member.constantValue = "[" + String.join((CharSequence)",", this.arrayValues) + "]";
                                                }
                                            };
                                        }

                                        public void visitEnum(String name, String descriptor, String value) {
                                            member.constantValue = "e" + descriptor + "." + value;
                                        }

                                        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                                            return AnnotationCollectorHelper.createCollector(descriptor, nested);
                                        }

                                        public void visitEnd() {
                                            if (!nested.isEmpty()) {
                                                member.constantValue = AnnotationSerializer.serializeArray(nested.toArray(new String[0]));
                                            }
                                        }
                                    };
                                }

                                public void visitEnd() {
                                    classDefinition.addMethod(member);
                                }
                            };
                        }
                        return null;
                    }

                    public void visitEnd() {
                        if (this.classDefinition != null && !"module-info".equals(this.classDefinition.className)) {
                            this.classDefinition.writeClass();
                        }
                    }
                }, 5);
            }

            @Generated
            public Jar(String groupId, String artifactId, String version) {
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
            }

            @Generated
            public String getGroupId() {
                return this.groupId;
            }

            @Generated
            public String getArtifactId() {
                return this.artifactId;
            }

            @Generated
            public String getVersion() {
                return this.version;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Jar)) {
                    return false;
                }
                Jar other = (Jar)o;
                String this$groupId = this.getGroupId();
                String other$groupId = other.getGroupId();
                if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                    return false;
                }
                String this$artifactId = this.getArtifactId();
                String other$artifactId = other.getArtifactId();
                if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                    return false;
                }
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                return !(this$version == null ? other$version != null : !this$version.equals(other$version));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $groupId = this.getGroupId();
                result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
                String $artifactId = this.getArtifactId();
                result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "TypeTable.Writer.Jar(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
            }
        }

        private final class Member {
            private final int access;
            private final String name;
            private final String descriptor;
            private final @Nullable String signature;
            private final String @Nullable [] exceptions;
            private final List<String> parameterNames = new ArrayList<String>(4);
            private final List<String> elementAnnotations = new ArrayList<String>(4);
            private final List<String> parameterAnnotations = new ArrayList<String>(4);
            private final List<String> typeAnnotations = new ArrayList<String>(4);
            private @Nullable String constantValue;

            private void writeMember(Jar jar, ClassDefinition classDefinition) {
                if ((0x1002 & this.access) == 0) {
                    Writer.this.out.printf("%s\t%s\t%s\t%d\t%s\t%s\t%s\t%s\t%d\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s%n", jar.groupId, jar.artifactId, jar.version, classDefinition.classAccess, classDefinition.className, classDefinition.classSignature == null ? "" : classDefinition.classSignature, classDefinition.classSuperclassName, classDefinition.classSuperinterfaceSignatures == null ? "" : String.join((CharSequence)"|", classDefinition.classSuperinterfaceSignatures), this.access, this.name, this.descriptor, this.signature == null ? "" : this.signature, this.parameterNames.isEmpty() ? "" : String.join((CharSequence)"|", this.parameterNames), this.exceptions == null ? "" : String.join((CharSequence)"|", this.exceptions), this.elementAnnotations.isEmpty() ? "" : String.join((CharSequence)"", this.elementAnnotations), TypeTable.serializeParameterAnnotations(this.parameterAnnotations, this.descriptor), this.typeAnnotations.isEmpty() ? "" : PipeDelimitedJoiner.joinWithPipes(this.typeAnnotations), this.constantValue == null ? "" : this.constantValue);
                }
            }

            @Generated
            public Member(int access, String name, @Nullable String descriptor, @Nullable String signature, String @Nullable [] exceptions, String constantValue) {
                this.access = access;
                this.name = name;
                this.descriptor = descriptor;
                this.signature = signature;
                this.exceptions = exceptions;
                this.constantValue = constantValue;
            }

            @Generated
            public int getAccess() {
                return this.access;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getDescriptor() {
                return this.descriptor;
            }

            @Generated
            public @Nullable String getSignature() {
                return this.signature;
            }

            @Generated
            public String @Nullable [] getExceptions() {
                return this.exceptions;
            }

            @Generated
            public List<String> getParameterNames() {
                return this.parameterNames;
            }

            @Generated
            public List<String> getElementAnnotations() {
                return this.elementAnnotations;
            }

            @Generated
            public List<String> getParameterAnnotations() {
                return this.parameterAnnotations;
            }

            @Generated
            public List<String> getTypeAnnotations() {
                return this.typeAnnotations;
            }

            @Generated
            public @Nullable String getConstantValue() {
                return this.constantValue;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Member)) {
                    return false;
                }
                Member other = (Member)o;
                if (this.getAccess() != other.getAccess()) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$descriptor = this.getDescriptor();
                String other$descriptor = other.getDescriptor();
                if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
                    return false;
                }
                String this$signature = this.getSignature();
                String other$signature = other.getSignature();
                if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                    return false;
                }
                if (!Arrays.deepEquals(this.getExceptions(), other.getExceptions())) {
                    return false;
                }
                List<String> this$parameterNames = this.getParameterNames();
                List<String> other$parameterNames = other.getParameterNames();
                if (this$parameterNames == null ? other$parameterNames != null : !((Object)this$parameterNames).equals(other$parameterNames)) {
                    return false;
                }
                List<String> this$elementAnnotations = this.getElementAnnotations();
                List<String> other$elementAnnotations = other.getElementAnnotations();
                if (this$elementAnnotations == null ? other$elementAnnotations != null : !((Object)this$elementAnnotations).equals(other$elementAnnotations)) {
                    return false;
                }
                List<String> this$parameterAnnotations = this.getParameterAnnotations();
                List<String> other$parameterAnnotations = other.getParameterAnnotations();
                if (this$parameterAnnotations == null ? other$parameterAnnotations != null : !((Object)this$parameterAnnotations).equals(other$parameterAnnotations)) {
                    return false;
                }
                List<String> this$typeAnnotations = this.getTypeAnnotations();
                List<String> other$typeAnnotations = other.getTypeAnnotations();
                if (this$typeAnnotations == null ? other$typeAnnotations != null : !((Object)this$typeAnnotations).equals(other$typeAnnotations)) {
                    return false;
                }
                String this$constantValue = this.getConstantValue();
                String other$constantValue = other.getConstantValue();
                return !(this$constantValue == null ? other$constantValue != null : !this$constantValue.equals(other$constantValue));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getAccess();
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $descriptor = this.getDescriptor();
                result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
                String $signature = this.getSignature();
                result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
                result = result * 59 + Arrays.deepHashCode(this.getExceptions());
                List<String> $parameterNames = this.getParameterNames();
                result = result * 59 + ($parameterNames == null ? 43 : ((Object)$parameterNames).hashCode());
                List<String> $elementAnnotations = this.getElementAnnotations();
                result = result * 59 + ($elementAnnotations == null ? 43 : ((Object)$elementAnnotations).hashCode());
                List<String> $parameterAnnotations = this.getParameterAnnotations();
                result = result * 59 + ($parameterAnnotations == null ? 43 : ((Object)$parameterAnnotations).hashCode());
                List<String> $typeAnnotations = this.getTypeAnnotations();
                result = result * 59 + ($typeAnnotations == null ? 43 : ((Object)$typeAnnotations).hashCode());
                String $constantValue = this.getConstantValue();
                result = result * 59 + ($constantValue == null ? 43 : $constantValue.hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "TypeTable.Writer.Member(access=" + this.getAccess() + ", name=" + this.getName() + ", descriptor=" + this.getDescriptor() + ", signature=" + this.getSignature() + ", exceptions=" + Arrays.deepToString(this.getExceptions()) + ", parameterNames=" + this.getParameterNames() + ", elementAnnotations=" + this.getElementAnnotations() + ", parameterAnnotations=" + this.getParameterAnnotations() + ", typeAnnotations=" + this.getTypeAnnotations() + ", constantValue=" + this.getConstantValue() + ")";
            }
        }

        final class ClassDefinition {
            private final Jar jar;
            private final int classAccess;
            private final String className;
            private final @Nullable String classSignature;
            private final @Nullable String classSuperclassName;
            private final String @Nullable [] classSuperinterfaceSignatures;
            private final List<String> classAnnotations = new ArrayList<String>(4);
            private final List<String> classTypeAnnotations = new ArrayList<String>(4);
            private final List<Member> members = new ArrayList<Member>();

            public void writeClass() {
                if ((0x1002 & this.classAccess) == 0) {
                    Writer.this.out.printf("%s\t%s\t%s\t%d\t%s\t%s\t%s\t%s\t%d\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s%n", this.jar.groupId, this.jar.artifactId, this.jar.version, this.classAccess, this.className, this.classSignature == null ? "" : this.classSignature, this.classSuperclassName, this.classSuperinterfaceSignatures == null ? "" : String.join((CharSequence)"|", this.classSuperinterfaceSignatures), -1, "", "", "", "", "", this.classAnnotations.isEmpty() ? "" : String.join((CharSequence)"", this.classAnnotations), "", this.classTypeAnnotations.isEmpty() ? "" : PipeDelimitedJoiner.joinWithPipes(this.classTypeAnnotations), "");
                    for (Member member : this.members) {
                        member.writeMember(this.jar, this);
                    }
                }
            }

            void addMethod(Member member) {
                this.members.add(member);
            }

            void addField(Member member) {
                this.members.add(member);
            }

            @Generated
            public ClassDefinition(Jar jar, int classAccess, @Nullable String className, @Nullable String classSignature, @Nullable String classSuperclassName, String[] classSuperinterfaceSignatures) {
                this.jar = jar;
                this.classAccess = classAccess;
                this.className = className;
                this.classSignature = classSignature;
                this.classSuperclassName = classSuperclassName;
                this.classSuperinterfaceSignatures = classSuperinterfaceSignatures;
            }

            @Generated
            public Jar getJar() {
                return this.jar;
            }

            @Generated
            public int getClassAccess() {
                return this.classAccess;
            }

            @Generated
            public String getClassName() {
                return this.className;
            }

            @Generated
            public @Nullable String getClassSignature() {
                return this.classSignature;
            }

            @Generated
            public @Nullable String getClassSuperclassName() {
                return this.classSuperclassName;
            }

            @Generated
            public String @Nullable [] getClassSuperinterfaceSignatures() {
                return this.classSuperinterfaceSignatures;
            }

            @Generated
            public List<String> getClassAnnotations() {
                return this.classAnnotations;
            }

            @Generated
            public List<String> getClassTypeAnnotations() {
                return this.classTypeAnnotations;
            }

            @Generated
            public List<Member> getMembers() {
                return this.members;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ClassDefinition)) {
                    return false;
                }
                ClassDefinition other = (ClassDefinition)o;
                if (this.getClassAccess() != other.getClassAccess()) {
                    return false;
                }
                Jar this$jar = this.getJar();
                Jar other$jar = other.getJar();
                if (this$jar == null ? other$jar != null : !((Object)this$jar).equals(other$jar)) {
                    return false;
                }
                String this$className = this.getClassName();
                String other$className = other.getClassName();
                if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                    return false;
                }
                String this$classSignature = this.getClassSignature();
                String other$classSignature = other.getClassSignature();
                if (this$classSignature == null ? other$classSignature != null : !this$classSignature.equals(other$classSignature)) {
                    return false;
                }
                String this$classSuperclassName = this.getClassSuperclassName();
                String other$classSuperclassName = other.getClassSuperclassName();
                if (this$classSuperclassName == null ? other$classSuperclassName != null : !this$classSuperclassName.equals(other$classSuperclassName)) {
                    return false;
                }
                if (!Arrays.deepEquals(this.getClassSuperinterfaceSignatures(), other.getClassSuperinterfaceSignatures())) {
                    return false;
                }
                List<String> this$classAnnotations = this.getClassAnnotations();
                List<String> other$classAnnotations = other.getClassAnnotations();
                if (this$classAnnotations == null ? other$classAnnotations != null : !((Object)this$classAnnotations).equals(other$classAnnotations)) {
                    return false;
                }
                List<String> this$classTypeAnnotations = this.getClassTypeAnnotations();
                List<String> other$classTypeAnnotations = other.getClassTypeAnnotations();
                if (this$classTypeAnnotations == null ? other$classTypeAnnotations != null : !((Object)this$classTypeAnnotations).equals(other$classTypeAnnotations)) {
                    return false;
                }
                List<Member> this$members = this.getMembers();
                List<Member> other$members = other.getMembers();
                return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getClassAccess();
                Jar $jar = this.getJar();
                result = result * 59 + ($jar == null ? 43 : ((Object)$jar).hashCode());
                String $className = this.getClassName();
                result = result * 59 + ($className == null ? 43 : $className.hashCode());
                String $classSignature = this.getClassSignature();
                result = result * 59 + ($classSignature == null ? 43 : $classSignature.hashCode());
                String $classSuperclassName = this.getClassSuperclassName();
                result = result * 59 + ($classSuperclassName == null ? 43 : $classSuperclassName.hashCode());
                result = result * 59 + Arrays.deepHashCode(this.getClassSuperinterfaceSignatures());
                List<String> $classAnnotations = this.getClassAnnotations();
                result = result * 59 + ($classAnnotations == null ? 43 : ((Object)$classAnnotations).hashCode());
                List<String> $classTypeAnnotations = this.getClassTypeAnnotations();
                result = result * 59 + ($classTypeAnnotations == null ? 43 : ((Object)$classTypeAnnotations).hashCode());
                List<Member> $members = this.getMembers();
                result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "TypeTable.Writer.ClassDefinition(jar=" + this.getJar() + ", classAccess=" + this.getClassAccess() + ", className=" + this.getClassName() + ", classSignature=" + this.getClassSignature() + ", classSuperclassName=" + this.getClassSuperclassName() + ", classSuperinterfaceSignatures=" + Arrays.deepToString(this.getClassSuperinterfaceSignatures()) + ", classAnnotations=" + this.getClassAnnotations() + ", classTypeAnnotations=" + this.getClassTypeAnnotations() + ", members=" + this.getMembers() + ")";
            }
        }
    }

    private static class PipeDelimitedJoiner {
        private PipeDelimitedJoiner() {
        }

        static String joinWithPipes(List<String> items) {
            if (items.isEmpty()) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (String item : items) {
                if (!first) {
                    result.append('|');
                }
                first = false;
                result.append(PipeDelimitedJoiner.escapePipes(item));
            }
            return result.toString();
        }

        private static String escapePipes(String str) {
            if (!str.contains("|")) {
                return str;
            }
            return str.replace("|", "\\|");
        }
    }

    static final class Member {
        private final ClassDefinition classDefinition;
        private final int access;
        private final String name;
        private final String descriptor;
        private final @Nullable String signature;
        private final String @Nullable [] parameterNames;
        private final String @Nullable [] exceptions;
        private final @Nullable String annotations;
        private final @Nullable String parameterAnnotations;
        private final String @Nullable [] typeAnnotations;
        private final @Nullable String constantValue;

        @Generated
        public Member(ClassDefinition classDefinition, int access, String name, String descriptor, @Nullable String signature, String @Nullable [] parameterNames, String @Nullable [] exceptions, @Nullable String annotations, @Nullable String parameterAnnotations, String @Nullable [] typeAnnotations, @Nullable String constantValue) {
            this.classDefinition = classDefinition;
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.parameterNames = parameterNames;
            this.exceptions = exceptions;
            this.annotations = annotations;
            this.parameterAnnotations = parameterAnnotations;
            this.typeAnnotations = typeAnnotations;
            this.constantValue = constantValue;
        }

        @Generated
        public ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        @Generated
        public int getAccess() {
            return this.access;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescriptor() {
            return this.descriptor;
        }

        @Generated
        public @Nullable String getSignature() {
            return this.signature;
        }

        @Generated
        public String @Nullable [] getParameterNames() {
            return this.parameterNames;
        }

        @Generated
        public String @Nullable [] getExceptions() {
            return this.exceptions;
        }

        @Generated
        public @Nullable String getAnnotations() {
            return this.annotations;
        }

        @Generated
        public @Nullable String getParameterAnnotations() {
            return this.parameterAnnotations;
        }

        @Generated
        public String @Nullable [] getTypeAnnotations() {
            return this.typeAnnotations;
        }

        @Generated
        public @Nullable String getConstantValue() {
            return this.constantValue;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Member)) {
                return false;
            }
            Member other = (Member)o;
            if (this.getAccess() != other.getAccess()) {
                return false;
            }
            ClassDefinition this$classDefinition = this.getClassDefinition();
            ClassDefinition other$classDefinition = other.getClassDefinition();
            if (this$classDefinition == null ? other$classDefinition != null : !((Object)this$classDefinition).equals(other$classDefinition)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$descriptor = this.getDescriptor();
            String other$descriptor = other.getDescriptor();
            if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getParameterNames(), other.getParameterNames())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getExceptions(), other.getExceptions())) {
                return false;
            }
            String this$annotations = this.getAnnotations();
            String other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !this$annotations.equals(other$annotations)) {
                return false;
            }
            String this$parameterAnnotations = this.getParameterAnnotations();
            String other$parameterAnnotations = other.getParameterAnnotations();
            if (this$parameterAnnotations == null ? other$parameterAnnotations != null : !this$parameterAnnotations.equals(other$parameterAnnotations)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getTypeAnnotations(), other.getTypeAnnotations())) {
                return false;
            }
            String this$constantValue = this.getConstantValue();
            String other$constantValue = other.getConstantValue();
            return !(this$constantValue == null ? other$constantValue != null : !this$constantValue.equals(other$constantValue));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAccess();
            ClassDefinition $classDefinition = this.getClassDefinition();
            result = result * 59 + ($classDefinition == null ? 43 : ((Object)$classDefinition).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $descriptor = this.getDescriptor();
            result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getParameterNames());
            result = result * 59 + Arrays.deepHashCode(this.getExceptions());
            String $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : $annotations.hashCode());
            String $parameterAnnotations = this.getParameterAnnotations();
            result = result * 59 + ($parameterAnnotations == null ? 43 : $parameterAnnotations.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getTypeAnnotations());
            String $constantValue = this.getConstantValue();
            result = result * 59 + ($constantValue == null ? 43 : $constantValue.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TypeTable.Member(classDefinition=" + this.getClassDefinition() + ", access=" + this.getAccess() + ", name=" + this.getName() + ", descriptor=" + this.getDescriptor() + ", signature=" + this.getSignature() + ", parameterNames=" + Arrays.deepToString(this.getParameterNames()) + ", exceptions=" + Arrays.deepToString(this.getExceptions()) + ", annotations=" + this.getAnnotations() + ", parameterAnnotations=" + this.getParameterAnnotations() + ", typeAnnotations=" + Arrays.deepToString(this.getTypeAnnotations()) + ", constantValue=" + this.getConstantValue() + ")";
        }
    }

    static final class ClassDefinition {
        private final int access;
        private final String name;
        private final @Nullable String signature;
        private final @Nullable String superclassSignature;
        private final String @Nullable [] superinterfaceSignatures;
        private final @Nullable String annotations;
        private final @Nullable String constantValue;
        private @Nullable List<Member> members;

        public List<Member> getMembers() {
            return this.members != null ? this.members : Collections.emptyList();
        }

        public void addMember(Member member) {
            if (this.members == null) {
                this.members = new ArrayList<Member>();
            }
            this.members.add(member);
        }

        @Generated
        public int getAccess() {
            return this.access;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @Nullable String getSignature() {
            return this.signature;
        }

        @Generated
        public @Nullable String getSuperclassSignature() {
            return this.superclassSignature;
        }

        @Generated
        public String @Nullable [] getSuperinterfaceSignatures() {
            return this.superinterfaceSignatures;
        }

        @Generated
        public @Nullable String getAnnotations() {
            return this.annotations;
        }

        @Generated
        public @Nullable String getConstantValue() {
            return this.constantValue;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDefinition)) {
                return false;
            }
            ClassDefinition other = (ClassDefinition)o;
            if (this.getAccess() != other.getAccess()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            String this$superclassSignature = this.getSuperclassSignature();
            String other$superclassSignature = other.getSuperclassSignature();
            if (this$superclassSignature == null ? other$superclassSignature != null : !this$superclassSignature.equals(other$superclassSignature)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getSuperinterfaceSignatures(), other.getSuperinterfaceSignatures())) {
                return false;
            }
            String this$annotations = this.getAnnotations();
            String other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !this$annotations.equals(other$annotations)) {
                return false;
            }
            String this$constantValue = this.getConstantValue();
            String other$constantValue = other.getConstantValue();
            if (this$constantValue == null ? other$constantValue != null : !this$constantValue.equals(other$constantValue)) {
                return false;
            }
            List<Member> this$members = this.getMembers();
            List<Member> other$members = other.getMembers();
            return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAccess();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            String $superclassSignature = this.getSuperclassSignature();
            result = result * 59 + ($superclassSignature == null ? 43 : $superclassSignature.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getSuperinterfaceSignatures());
            String $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : $annotations.hashCode());
            String $constantValue = this.getConstantValue();
            result = result * 59 + ($constantValue == null ? 43 : $constantValue.hashCode());
            List<Member> $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TypeTable.ClassDefinition(access=" + this.getAccess() + ", name=" + this.getName() + ", signature=" + this.getSignature() + ", superclassSignature=" + this.getSuperclassSignature() + ", superinterfaceSignatures=" + Arrays.deepToString(this.getSuperinterfaceSignatures()) + ", annotations=" + this.getAnnotations() + ", constantValue=" + this.getConstantValue() + ")";
        }

        @Generated
        public ClassDefinition(int access, String name, @Nullable String signature, @Nullable String superclassSignature, String @Nullable [] superinterfaceSignatures, @Nullable String annotations, @Nullable String constantValue) {
            this.access = access;
            this.name = name;
            this.signature = signature;
            this.superclassSignature = superclassSignature;
            this.superinterfaceSignatures = superinterfaceSignatures;
            this.annotations = annotations;
            this.constantValue = constantValue;
        }
    }
}

