/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import java.util.ArrayList;
import org.jetbrains.annotations.VisibleForTesting;

class TsvEscapeUtils {
    TsvEscapeUtils() {
    }

    @VisibleForTesting
    static String[] splitAnnotationList(String input, char delimiter) {
        if (input.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = null;
        boolean escaped = false;
        int segmentStart = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (escaped) {
                if (current == null) {
                    current = new StringBuilder();
                    current.append(input, segmentStart, i - 1);
                }
                if (c == '|') {
                    current.append('|');
                } else {
                    current.append('\\').append(c);
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == delimiter) {
                if (current == null) {
                    result.add(input.substring(segmentStart, i));
                } else {
                    result.add(current.toString());
                    current = null;
                }
                segmentStart = i + 1;
                continue;
            }
            if (current == null) continue;
            current.append(c);
        }
        if (escaped) {
            if (current == null) {
                current = new StringBuilder();
                current.append(input, segmentStart, input.length() - 1);
            }
            current.append('\\');
        }
        if (current == null) {
            result.add(input.substring(segmentStart));
        } else {
            result.add(current.toString());
        }
        return result.toArray(new String[0]);
    }
}

