/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public class SimplifySingleElementAnnotation
extends Recipe {
    public String getDisplayName() {
        return "Simplify single-element annotation";
    }

    public String getDescription() {
        return "This recipe will remove the attribute `value` on single-element annotations. According to JLS, a _single-element annotation_, is a shorthand designed for use with single-element annotation types.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SimplifySingleElementAnnotationVisitor(null);
    }

    public static <J2 extends J> TreeVisitor<?, ExecutionContext> modifyOnly(J2 scope) {
        return new SimplifySingleElementAnnotationVisitor(scope);
    }

    private static final class SimplifySingleElementAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final @Nullable J scope;

        @Override
        public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext executionContext) {
            J an = super.visitAnnotation(annotation, executionContext);
            if (((J.Annotation)an).getArguments() != null && ((J.Annotation)an).getArguments().size() == 1 && (this.scope == null || ((J.Annotation)an).equals(this.scope))) {
                return ((J.Annotation)an).withArguments(ListUtils.mapFirst(((J.Annotation)an).getArguments(), v -> {
                    if (v instanceof J.Assignment && ((J.Assignment)v).getVariable() instanceof J.Identifier && "value".equals(((J.Identifier)((J.Assignment)v).getVariable()).getSimpleName())) {
                        J.NewArray na;
                        List<Expression> initializer;
                        Expression assignment = ((J.Assignment)v).getAssignment();
                        if (assignment instanceof J.NewArray && (initializer = (na = (J.NewArray)assignment).getInitializer()) != null && initializer.size() == 1 && !(initializer.get(0) instanceof J.Empty)) {
                            return (Expression)initializer.get(0).withPrefix(Space.EMPTY);
                        }
                        return (Expression)assignment.withPrefix(Space.EMPTY);
                    }
                    return v;
                }));
            }
            return an;
        }

        @Generated
        public SimplifySingleElementAnnotationVisitor(@Nullable J scope) {
            this.scope = scope;
        }

        @Generated
        public @Nullable J getScope() {
            return this.scope;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimplifySingleElementAnnotationVisitor)) {
                return false;
            }
            SimplifySingleElementAnnotationVisitor other = (SimplifySingleElementAnnotationVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            J this$scope = this.getScope();
            J other$scope = other.getScope();
            return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof SimplifySingleElementAnnotationVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            J $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "SimplifySingleElementAnnotation.SimplifySingleElementAnnotationVisitor(scope=" + this.getScope() + ")";
        }
    }
}

