/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.ParenthesizeVisitor;
import org.openrewrite.java.internal.grammar.TemplateParameterParser;
import org.openrewrite.java.internal.template.TemplateParameter;
import org.openrewrite.java.internal.template.TypeParameter;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;

public class Substitutions {
    private static final Pattern PATTERN_COMMENT = Pattern.compile("__p(\\d+)__");
    private static final List<String> VALID_MATCHERS = Arrays.asList("any", "anyArray");
    private final String code;
    private final Set<String> genericTypes;
    private final Object[] parameters;
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("#{", "}", null);
    private final Set<JavaType.GenericTypeVariable> typeVariables = Collections.newSetFromMap(new IdentityHashMap());

    public String substitute() {
        HashMap typedPatternByName;
        String previous;
        Map<String, JavaType.GenericTypeVariable> generics = TypeParameter.parseGenericTypes(this.genericTypes);
        this.typeVariables.addAll(generics.values());
        AtomicInteger requiredParameters = new AtomicInteger(0);
        AtomicInteger index = new AtomicInteger(0);
        String substituted = this.code;
        while (!(previous = substituted).equals(substituted = this.propertyPlaceholderHelper.replacePlaceholders(substituted, arg_0 -> this.lambda$substitute$0(typedPatternByName = new HashMap(), index, generics, requiredParameters, arg_0)))) {
        }
        if (this.parameters.length != requiredParameters.get()) {
            throw new IllegalArgumentException("This template requires " + requiredParameters.get() + " parameters.");
        }
        return substituted;
    }

    private String substituteTypedPattern(String key, int index, TemplateParameterParser.TypedPatternContext typedPattern, Map<String, JavaType.GenericTypeVariable> generics) {
        String fqn;
        JavaType.Primitive primitive;
        JavaType type;
        if (index >= this.parameters.length) {
            throw new IllegalArgumentException("This template requires more parameters.");
        }
        Object parameter = this.parameters[index];
        TemplateParameterParser.TypeContext param = typedPattern.patternType().type();
        String matcherName = typedPattern.patternType().matcherName().Identifier().getText();
        if (!VALID_MATCHERS.contains(matcherName)) {
            throw new IllegalArgumentException("Invalid template matcher '" + key + "'");
        }
        if (param != null) {
            type = TypeParameter.toJavaType(param, generics);
            if ("anyArray".equals(matcherName)) {
                type = new JavaType.Array(null, type, null);
            }
        } else {
            type = parameter instanceof J.NewClass && ((J.NewClass)parameter).getBody() != null && ((J.NewClass)parameter).getClazz() != null ? ((J.NewClass)parameter).getClazz().getType() : (parameter instanceof J.Empty && ((J.Empty)parameter).getMarkers().findFirst(TemplateParameter.class).isPresent() ? ((TemplateParameter)((J.Empty)parameter).getMarkers().findFirst(TemplateParameter.class).get()).getType() : (parameter instanceof TypedTree ? ((TypedTree)parameter).getType() : ("anyArray".equals(matcherName) ? new JavaType.Array(null, JavaType.ShallowClass.build("java.lang.Object"), null) : null)));
            this.extractTypeVariables(type);
        }
        String s = (primitive = JavaType.Primitive.fromKeyword(fqn = this.getTypeName(type))) == null || primitive == JavaType.Primitive.String ? this.newObjectParameter(fqn, index) : this.newPrimitiveParameter(fqn, index);
        this.parameters[index] = ((J)parameter).withPrefix(Space.EMPTY);
        return s;
    }

    protected String newObjectParameter(String fqn, int index) {
        return "__P__.<" + fqn + ">/*__p" + index + "__*/p()";
    }

    protected String newPrimitiveParameter(String fqn, int index) {
        return "__P__./*__p" + index + "__*/" + fqn + "p()";
    }

    private String getTypeName(@Nullable JavaType type) {
        if (type == null) {
            return "java.lang.Object";
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable genericType = (JavaType.GenericTypeVariable)type;
            if (!genericType.getName().equals("?")) {
                return genericType.getName();
            }
            if (genericType.getVariance() != JavaType.GenericTypeVariable.Variance.COVARIANT || genericType.getBounds().size() != 1) {
                return "java.lang.Object";
            }
            return TypeUtils.toString(genericType.getBounds().get(0));
        }
        return TypeUtils.toString(type).replace("$", ".");
    }

    private String substituteUntyped(Object parameter, int index) {
        if (parameter instanceof J) {
            if (parameter instanceof J.Annotation) {
                return "@SubAnnotation(" + index + ")";
            }
            if (parameter instanceof J.Block) {
                return "/*__p" + index + "__*/{}";
            }
            if (parameter instanceof J.Literal || parameter instanceof J.VariableDeclarations) {
                return ((J)parameter).printTrimmed();
            }
            throw new IllegalArgumentException("Template parameter " + index + " cannot be used in an untyped template substitution. Instead of \"#{}\", indicate the template parameter's type with \"#{any(" + Substitutions.typeHintFor(parameter) + ")}\".");
        }
        if (parameter instanceof JRightPadded) {
            return this.substituteUntyped(((JRightPadded)parameter).getElement(), index);
        }
        if (parameter instanceof JLeftPadded) {
            return this.substituteUntyped(((JLeftPadded)parameter).getElement(), index);
        }
        return parameter.toString();
    }

    private static String typeHintFor(Object j) {
        if (j instanceof TypedTree) {
            return Substitutions.typeHintFor(((TypedTree)j).getType());
        }
        return "";
    }

    private static String typeHintFor(@Nullable JavaType t) {
        if (t == null || t instanceof JavaType.GenericTypeVariable) {
            return "";
        }
        return TypeUtils.toString(t);
    }

    private void extractTypeVariables(@Nullable JavaType type) {
        if (type == null) {
            return;
        }
        final Set visited = Collections.newSetFromMap(new IdentityHashMap());
        new JavaTypeVisitor<Integer>(){

            @Override
            public JavaType visitAnnotation(JavaType.Annotation annotation, Integer p) {
                return annotation.getType();
            }

            @Override
            public JavaType visitArray(JavaType.Array array, Integer p) {
                this.visit(array.getElemType(), p);
                return array;
            }

            @Override
            public JavaType visitClass(JavaType.Class aClass, Integer p) {
                return aClass;
            }

            @Override
            public JavaType visitGenericTypeVariable(JavaType.GenericTypeVariable generic, Integer p) {
                if (!visited.add(generic)) {
                    return generic;
                }
                if (!generic.getName().equals("?")) {
                    Substitutions.this.typeVariables.add(generic);
                }
                return super.visitGenericTypeVariable(generic, p);
            }

            @Override
            public JavaType visitMethod(JavaType.Method method, Integer p) {
                return method;
            }

            @Override
            public JavaType visitParameterized(JavaType.Parameterized parameterized, Integer p) {
                for (JavaType typeParameter : parameterized.getTypeParameters()) {
                    this.visit(typeParameter, p);
                }
                return super.visitParameterized(parameterized, p);
            }

            @Override
            public JavaType visitVariable(JavaType.Variable variable, Integer p) {
                return variable;
            }
        }.visit(type, Integer.valueOf(0));
    }

    public <J2 extends J> List<J2> unsubstitute(List<J2> js) {
        return ListUtils.map(js, this::unsubstitute);
    }

    public <J2 extends J> @Nullable J2 unsubstitute(J2 j) {
        if (this.parameters.length == 0) {
            return j;
        }
        return (J2)((J)new JavaVisitor<Integer>(){

            @Override
            public J visitAnnotation(J.Annotation annotation, Integer integer) {
                if (TypeUtils.isOfClassType(annotation.getType(), "SubAnnotation")) {
                    J.Literal index = (J.Literal)annotation.getArguments().get(0);
                    J a2 = (J)Substitutions.this.parameters[(Integer)index.getValue()];
                    return a2.withPrefix(a2.getPrefix().withWhitespace(annotation.getPrefix().getWhitespace()));
                }
                return super.visitAnnotation(annotation, integer);
            }

            @Override
            public J visitBlock(J.Block block, Integer integer) {
                J param = this.maybeParameter(block);
                if (param != null) {
                    return param;
                }
                return super.visitBlock(block, integer);
            }

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                J param = this.maybeParameter(method.getName());
                if (param instanceof Expression) {
                    return ParenthesizeVisitor.maybeParenthesize((Expression)param, this.getCursor());
                }
                if (param != null) {
                    return param;
                }
                return super.visitMethodInvocation(method, integer);
            }

            @Override
            public <T extends J> J visitParentheses(J.Parentheses<T> parens, Integer integer) {
                J param = this.maybeParameter((J)parens.getTree());
                if (param instanceof Expression) {
                    return ParenthesizeVisitor.maybeParenthesize((Expression)param, this.getCursor());
                }
                if (param != null) {
                    return param;
                }
                return super.visitParentheses(parens, integer);
            }

            @Override
            public J visitLiteral(J.Literal literal, Integer integer) {
                J param = this.maybeParameter(literal);
                if (param instanceof Expression) {
                    return ParenthesizeVisitor.maybeParenthesize((Expression)param, this.getCursor());
                }
                if (param != null) {
                    return param;
                }
                return super.visitLiteral(literal, integer);
            }

            private @Nullable J maybeParameter(J j1) {
                Integer param = this.parameterIndex(j1.getPrefix());
                if (param != null) {
                    J j2 = (J)Substitutions.this.parameters[param];
                    return j2.withPrefix(j2.getPrefix().withWhitespace(j1.getPrefix().getWhitespace()));
                }
                return null;
            }

            private @Nullable Integer parameterIndex(Space space) {
                for (Comment comment : space.getComments()) {
                    Matcher matcher;
                    if (!(comment instanceof TextComment) || !(matcher = PATTERN_COMMENT.matcher(((TextComment)comment).getText())).matches()) continue;
                    return Integer.valueOf(matcher.group(1));
                }
                return null;
            }
        }.visitNonNull(j, 0));
    }

    @Generated
    public Substitutions(String code, Set<String> genericTypes, Object[] parameters) {
        this.code = code;
        this.genericTypes = genericTypes;
        this.parameters = parameters;
    }

    @NonNull
    @Generated
    public String toString() {
        return "Substitutions(code=" + this.code + ", genericTypes=" + this.genericTypes + ", parameters=" + Arrays.deepToString(this.parameters) + ", propertyPlaceholderHelper=" + this.propertyPlaceholderHelper + ", typeVariables=" + this.getTypeVariables() + ")";
    }

    @Generated
    public Set<JavaType.GenericTypeVariable> getTypeVariables() {
        return this.typeVariables;
    }

    private /* synthetic */ String lambda$substitute$0(Map typedPatternByName, AtomicInteger index, Map generics, AtomicInteger requiredParameters, String key) {
        String s;
        if (!key.isEmpty()) {
            TemplateParameterParser.MatcherPatternContext ctx = TypeParameter.parser(key).matcherPattern();
            TemplateParameterParser.TypedPatternContext typedPattern = ctx.typedPattern();
            if (typedPattern == null) {
                String paramName = ctx.parameterName().Identifier().getText();
                s = (String)typedPatternByName.get(paramName);
                if (s == null) {
                    throw new IllegalArgumentException("The parameter " + paramName + " must be defined before it is referenced.");
                }
            } else {
                int i = index.getAndIncrement();
                s = this.substituteTypedPattern(key, i, typedPattern, generics);
                if (ctx.typedPattern().parameterName() != null) {
                    String paramName = ctx.typedPattern().parameterName().Identifier().getText();
                    typedPatternByName.put(paramName, s);
                }
                requiredParameters.incrementAndGet();
            }
        } else {
            int i = index.getAndIncrement();
            s = this.substituteUntyped(this.parameters[i], i);
            requiredParameters.incrementAndGet();
        }
        return s;
    }
}

