/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.indentation;

import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentationCheck;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

public class LineWrappingHandler {
    private static final int[] IGNORED_LIST = new int[]{73, 136, 29, 94, 93};
    private final IndentationCheck indentCheck;

    public LineWrappingHandler(IndentationCheck instance) {
        this.indentCheck = instance;
    }

    public void checkIndentation(DetailAST firstNode, DetailAST lastNode) {
        this.checkIndentation(firstNode, lastNode, this.indentCheck.getLineWrappingIndentation());
    }

    private void checkIndentation(DetailAST firstNode, DetailAST lastNode, int indentLevel) {
        this.checkIndentation(firstNode, lastNode, indentLevel, -1, LineWrappingOptions.IGNORE_FIRST_LINE);
    }

    public void checkIndentation(DetailAST firstNode, DetailAST lastNode, int indentLevel, int startIndent, LineWrappingOptions ignoreFirstLine) {
        NavigableMap<Integer, DetailAST> firstNodesOnLines = this.collectFirstNodes(firstNode, lastNode);
        DetailAST firstLineNode = (DetailAST)firstNodesOnLines.get(firstNodesOnLines.firstKey());
        if (firstLineNode.getType() == 170) {
            this.checkForAnnotationIndentation(firstNodesOnLines, indentLevel);
        }
        if (ignoreFirstLine == LineWrappingOptions.IGNORE_FIRST_LINE) {
            firstNodesOnLines.remove(firstNodesOnLines.firstKey());
        }
        int firstNodeIndent = startIndent == -1 ? this.getLineStart(firstLineNode) : startIndent;
        int currentIndent = firstNodeIndent + indentLevel;
        for (DetailAST node : firstNodesOnLines.values()) {
            int currentType = node.getType();
            if (LineWrappingHandler.checkForNullParameterChild(node) || LineWrappingHandler.checkForMethodLparenNewLine(node)) continue;
            if (currentType == 77) {
                this.logWarningMessage(node, firstNodeIndent);
                continue;
            }
            if (TokenUtil.isOfType(currentType, IGNORED_LIST)) continue;
            this.logWarningMessage(node, currentIndent);
        }
    }

    public void checkForAnnotationIndentation(NavigableMap<Integer, DetailAST> firstNodesOnLines, int indentLevel) {
        DetailAST firstLineNode = (DetailAST)firstNodesOnLines.get(firstNodesOnLines.firstKey());
        for (DetailAST node = firstLineNode.getParent(); node != null; node = node.getNextSibling()) {
            if (node.getType() != 159) continue;
            DetailAST atNode = node.getFirstChild();
            NavigableMap<Integer, DetailAST> annotationLines = firstNodesOnLines.subMap(node.getLineNo(), true, LineWrappingHandler.getNextNodeLine(firstNodesOnLines, node), true);
            this.checkAnnotationIndentation(atNode, annotationLines, indentLevel);
        }
    }

    public static boolean checkForNullParameterChild(DetailAST node) {
        return node.getFirstChild() == null && node.getType() == 20;
    }

    public static boolean checkForMethodLparenNewLine(DetailAST node) {
        int parentType = node.getParent().getType();
        return parentType == 9 && node.getType() == 76;
    }

    private static Integer getNextNodeLine(NavigableMap<Integer, DetailAST> firstNodesOnLines, DetailAST node) {
        Integer nextNodeLine = firstNodesOnLines.higherKey(node.getLastChild().getLineNo());
        if (nextNodeLine == null) {
            nextNodeLine = (Integer)firstNodesOnLines.lastKey();
        }
        return nextNodeLine;
    }

    private NavigableMap<Integer, DetailAST> collectFirstNodes(DetailAST firstNode, DetailAST lastNode) {
        TreeMap<Integer, DetailAST> result = new TreeMap<Integer, DetailAST>();
        result.put(firstNode.getLineNo(), firstNode);
        DetailAST curNode = firstNode.getFirstChild();
        while (curNode != lastNode) {
            DetailAST firstTokenOnLine;
            if (curNode.getType() == 6 || curNode.getType() == 7) {
                curNode = curNode.getLastChild();
            }
            if ((firstTokenOnLine = (DetailAST)result.get(curNode.getLineNo())) == null || this.expandedTabsColumnNo(firstTokenOnLine) >= this.expandedTabsColumnNo(curNode)) {
                result.put(curNode.getLineNo(), curNode);
            }
            curNode = LineWrappingHandler.getNextCurNode(curNode);
        }
        return result;
    }

    private static DetailAST getNextCurNode(DetailAST curNode) {
        DetailAST nodeToVisit = curNode.getFirstChild();
        DetailAST currentNode = curNode;
        while (nodeToVisit == null) {
            nodeToVisit = currentNode.getNextSibling();
            if (nodeToVisit != null) continue;
            currentNode = currentNode.getParent();
        }
        return nodeToVisit;
    }

    private void checkAnnotationIndentation(DetailAST atNode, NavigableMap<Integer, DetailAST> firstNodesOnLines, int indentLevel) {
        int firstNodeIndent = this.getLineStart(atNode);
        int currentIndent = firstNodeIndent + indentLevel;
        Collection values = firstNodesOnLines.values();
        DetailAST lastAnnotationNode = atNode.getParent().getLastChild();
        int lastAnnotationLine = lastAnnotationNode.getLineNo();
        Iterator itr = values.iterator();
        while (firstNodesOnLines.size() > 1) {
            boolean isCurrentNodeCloseAnnotationAloneInLine;
            DetailAST node = (DetailAST)itr.next();
            DetailAST parentNode = node.getParent();
            boolean isArrayInitPresentInAncestors = LineWrappingHandler.isParentContainsTokenType(node, 162);
            boolean bl = isCurrentNodeCloseAnnotationAloneInLine = node.getLineNo() == lastAnnotationLine && LineWrappingHandler.isEndOfScope(lastAnnotationNode, node);
            if (!isArrayInitPresentInAncestors && (isCurrentNodeCloseAnnotationAloneInLine || node.getType() == 170 && (parentNode.getParent().getType() == 5 || parentNode.getParent().getType() == 158) || TokenUtil.areOnSameLine(node, atNode))) {
                this.logWarningMessage(node, firstNodeIndent);
            } else if (!isArrayInitPresentInAncestors) {
                this.logWarningMessage(node, currentIndent);
            }
            itr.remove();
        }
    }

    private static boolean isEndOfScope(DetailAST lastAnnotationNode, DetailAST node) {
        DetailAST checkNode = node;
        boolean endOfScope = true;
        block3: while (endOfScope && !checkNode.equals(lastAnnotationNode)) {
            switch (checkNode.getType()) {
                case 48: 
                case 73: {
                    while (checkNode.getNextSibling() == null) {
                        checkNode = checkNode.getParent();
                    }
                    checkNode = checkNode.getNextSibling();
                    continue block3;
                }
            }
            endOfScope = false;
        }
        return endOfScope;
    }

    private static boolean isParentContainsTokenType(DetailAST node, int type) {
        boolean returnValue = false;
        for (DetailAST ast = node.getParent(); ast != null; ast = ast.getParent()) {
            if (ast.getType() != type) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    private int expandedTabsColumnNo(DetailAST ast) {
        String line = this.indentCheck.getLine(ast.getLineNo() - 1);
        return CommonUtil.lengthExpandedTabs(line, ast.getColumnNo(), this.indentCheck.getIndentationTabWidth());
    }

    private int getLineStart(DetailAST ast) {
        String line = this.indentCheck.getLine(ast.getLineNo() - 1);
        return this.getLineStart(line);
    }

    private int getLineStart(String line) {
        int index = 0;
        while (Character.isWhitespace(line.charAt(index))) {
            ++index;
        }
        return CommonUtil.lengthExpandedTabs(line, index, this.indentCheck.getIndentationTabWidth());
    }

    private void logWarningMessage(DetailAST currentNode, int currentIndent) {
        if (this.indentCheck.isForceStrictCondition()) {
            if (this.expandedTabsColumnNo(currentNode) != currentIndent) {
                this.indentCheck.indentationLog(currentNode, "indentation.error", currentNode.getText(), this.expandedTabsColumnNo(currentNode), currentIndent);
            }
        } else if (this.expandedTabsColumnNo(currentNode) < currentIndent) {
            this.indentCheck.indentationLog(currentNode, "indentation.error", currentNode.getText(), this.expandedTabsColumnNo(currentNode), currentIndent);
        }
    }

    public static enum LineWrappingOptions {
        IGNORE_FIRST_LINE,
        NONE;


        public static LineWrappingOptions ofBoolean(boolean val) {
            LineWrappingOptions option = NONE;
            if (val) {
                option = IGNORE_FIRST_LINE;
            }
            return option;
        }
    }
}

