/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class DeleteMethodArgument
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="com.yourorg.A foo(int, int)")
    private final String methodPattern;
    @Option(displayName="Argument index", description="A zero-based index that indicates which argument will be removed from the method invocation.", example="0")
    private final int argumentIndex;

    public String getDisplayName() {
        return "Delete method argument";
    }

    public String getDescription() {
        return "Delete an argument from method invocations.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesMethod(this.methodPattern), (TreeVisitor)new DeleteMethodArgumentVisitor(new MethodMatcher(this.methodPattern)));
    }

    public DeleteMethodArgument(String methodPattern, int argumentIndex) {
        this.methodPattern = methodPattern;
        this.argumentIndex = argumentIndex;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public int getArgumentIndex() {
        return this.argumentIndex;
    }

    @NonNull
    public String toString() {
        return "DeleteMethodArgument(methodPattern=" + this.getMethodPattern() + ", argumentIndex=" + this.getArgumentIndex() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteMethodArgument)) {
            return false;
        }
        DeleteMethodArgument other = (DeleteMethodArgument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getArgumentIndex() != other.getArgumentIndex()) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteMethodArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getArgumentIndex();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }

    private class DeleteMethodArgumentVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        public DeleteMethodArgumentVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            return (J.MethodInvocation)this.visitMethodCall((MethodCall)m);
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J n = super.visitNewClass(newClass, ctx);
            return (J.NewClass)this.visitMethodCall((MethodCall)n);
        }

        private MethodCall visitMethodCall(MethodCall methodCall) {
            MethodCall m = methodCall;
            List<Expression> originalArgs = m.getArguments();
            if (this.methodMatcher.matches(m) && originalArgs.stream().filter(a -> !(a instanceof J.Empty)).count() >= (long)(DeleteMethodArgument.this.argumentIndex + 1)) {
                List<Expression> args = new ArrayList<Expression>(originalArgs);
                args.remove(DeleteMethodArgument.this.argumentIndex);
                if (args.isEmpty()) {
                    args = Collections.singletonList(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY));
                }
                m = m.withArguments(args);
            }
            return m;
        }
    }
}

