/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class JContainer<T> {
    private transient Padding<T> padding;
    private static final JContainer<?> EMPTY = new JContainer(Space.EMPTY, Collections.emptyList(), Markers.EMPTY);
    private final Space before;
    private final List<JRightPadded<T>> elements;
    private final Markers markers;

    private JContainer(Space before, List<JRightPadded<T>> elements, Markers markers) {
        this.before = before;
        this.elements = elements;
        this.markers = markers;
    }

    public static <T> JContainer<T> build(List<JRightPadded<T>> elements) {
        return JContainer.build(Space.EMPTY, elements, Markers.EMPTY);
    }

    @JsonCreator
    public static <T> JContainer<T> build(Space before, List<JRightPadded<T>> elements, Markers markers) {
        if (before.isEmpty() && elements.isEmpty() && markers.getMarkers().isEmpty()) {
            return JContainer.empty();
        }
        return new JContainer<T>(before, elements, markers);
    }

    public static <T> JContainer<T> empty() {
        return EMPTY;
    }

    public JContainer<T> withBefore(Space before) {
        return this.getBefore() == before ? this : JContainer.build(before, this.elements, this.markers);
    }

    public JContainer<T> withMarkers(Markers markers) {
        return this.getMarkers() == markers ? this : JContainer.build(this.before, this.elements, markers);
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public List<T> getElements() {
        return JRightPadded.getElements(this.elements);
    }

    public Space getBefore() {
        return this.before;
    }

    public JContainer<T> map(UnaryOperator<T> map) {
        return this.getPadding().withElements(ListUtils.map(this.elements, t -> t.map(map)));
    }

    public Space getLastSpace() {
        return this.elements.isEmpty() ? Space.EMPTY : this.elements.get(this.elements.size() - 1).getAfter();
    }

    public Padding<T> getPadding() {
        if (this.padding == null) {
            this.padding = new Padding(this);
        }
        return this.padding;
    }

    @Nullable
    public static <J2 extends J> JContainer<J2> withElementsNullable(@Nullable JContainer<J2> before, @Nullable List<J2> elements) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        if (before == null) {
            return JContainer.build(Space.EMPTY, JRightPadded.withElements(Collections.emptyList(), elements), Markers.EMPTY);
        }
        return before.getPadding().withElements(JRightPadded.withElements(before.elements, elements));
    }

    public static <J2 extends J> JContainer<J2> withElements(JContainer<J2> before, @Nullable List<J2> elements) {
        if (elements == null) {
            return before.getPadding().withElements(Collections.emptyList());
        }
        return before.getPadding().withElements(JRightPadded.withElements(before.elements, elements));
    }

    public String toString() {
        return "JContainer(before=" + this.before + ", elementCount=" + this.elements.size() + ')';
    }

    public static class Padding<T> {
        private final JContainer<T> c;

        public List<JRightPadded<T>> getElements() {
            return ((JContainer)this.c).elements;
        }

        public JContainer<T> withElements(List<JRightPadded<T>> elements) {
            return ((JContainer)this.c).elements == elements ? this.c : JContainer.build(((JContainer)this.c).before, elements, ((JContainer)this.c).markers);
        }

        @Generated
        public Padding(JContainer<T> c) {
            this.c = c;
        }
    }

    public static enum Location {
        ANNOTATION_ARGUMENTS(Space.Location.ANNOTATION_ARGUMENTS, JRightPadded.Location.ANNOTATION_ARGUMENT),
        CASE(Space.Location.CASE, JRightPadded.Location.CASE),
        CASE_EXPRESSION(Space.Location.CASE_EXPRESSION, JRightPadded.Location.CASE_EXPRESSION),
        IMPLEMENTS(Space.Location.IMPLEMENTS, JRightPadded.Location.IMPLEMENTS),
        PERMITS(Space.Location.PERMITS, JRightPadded.Location.PERMITS),
        LANGUAGE_EXTENSION(Space.Location.LANGUAGE_EXTENSION, JRightPadded.Location.LANGUAGE_EXTENSION),
        METHOD_DECLARATION_PARAMETERS(Space.Location.METHOD_DECLARATION_PARAMETERS, JRightPadded.Location.METHOD_DECLARATION_PARAMETER),
        METHOD_INVOCATION_ARGUMENTS(Space.Location.METHOD_INVOCATION_ARGUMENTS, JRightPadded.Location.METHOD_INVOCATION_ARGUMENT),
        NEW_ARRAY_INITIALIZER(Space.Location.NEW_ARRAY_INITIALIZER, JRightPadded.Location.NEW_ARRAY_INITIALIZER),
        NEW_CLASS_ARGUMENTS(Space.Location.NEW_CLASS_ARGUMENTS, JRightPadded.Location.NEW_CLASS_ARGUMENTS),
        RECORD_STATE_VECTOR(Space.Location.RECORD_STATE_VECTOR, JRightPadded.Location.RECORD_STATE_VECTOR),
        THROWS(Space.Location.THROWS, JRightPadded.Location.THROWS),
        TRY_RESOURCES(Space.Location.TRY_RESOURCES, JRightPadded.Location.TRY_RESOURCE),
        TYPE_BOUNDS(Space.Location.TYPE_BOUNDS, JRightPadded.Location.TYPE_BOUND),
        TYPE_PARAMETERS(Space.Location.TYPE_PARAMETERS, JRightPadded.Location.TYPE_PARAMETER);

        private final Space.Location beforeLocation;
        private final JRightPadded.Location elementLocation;

        private Location(Space.Location beforeLocation, JRightPadded.Location elementLocation) {
            this.beforeLocation = beforeLocation;
            this.elementLocation = elementLocation;
        }

        public Space.Location getBeforeLocation() {
            return this.beforeLocation;
        }

        public JRightPadded.Location getElementLocation() {
            return this.elementLocation;
        }
    }
}

