/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.search.FindDeprecatedClasses;
import org.openrewrite.java.search.FindDeprecatedFields;
import org.openrewrite.java.search.FindDeprecatedMethods;

public final class FindDeprecatedUses
extends Recipe {
    @Option(displayName="Type pattern", description="A type pattern that is used to find deprecations from certain types.", example="org.springframework..*", required=false)
    @Nullable
    private final String typePattern;
    @Option(displayName="Match inherited", description="When enabled, find types that inherit from a deprecated type.", required=false)
    @Nullable
    private final Boolean matchInherited;
    @Option(displayName="Ignore deprecated scopes", description="When a deprecated type is used in a deprecated method or class, ignore it.", required=false)
    @Nullable
    private final Boolean ignoreDeprecatedScopes;

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new FindDeprecatedMethods(this.typePattern == null || this.typePattern.isEmpty() ? null : this.typePattern + " *(..)", this.ignoreDeprecatedScopes), new FindDeprecatedClasses(this.typePattern, this.matchInherited, this.ignoreDeprecatedScopes), new FindDeprecatedFields(this.typePattern, this.matchInherited, this.ignoreDeprecatedScopes)});
    }

    public String getDisplayName() {
        return "Find uses of deprecated classes, methods, and fields";
    }

    public String getInstanceNameSuffix() {
        if (this.typePattern != null) {
            return "matching `" + this.typePattern + "`";
        }
        return super.getInstanceNameSuffix();
    }

    public String getDescription() {
        return "Find deprecated uses of methods, fields, and types. Optionally ignore those classes that are inside deprecated scopes.";
    }

    public FindDeprecatedUses(@Nullable String typePattern, @Nullable Boolean matchInherited, @Nullable Boolean ignoreDeprecatedScopes) {
        this.typePattern = typePattern;
        this.matchInherited = matchInherited;
        this.ignoreDeprecatedScopes = ignoreDeprecatedScopes;
    }

    @Nullable
    public String getTypePattern() {
        return this.typePattern;
    }

    @Nullable
    public Boolean getMatchInherited() {
        return this.matchInherited;
    }

    @Nullable
    public Boolean getIgnoreDeprecatedScopes() {
        return this.ignoreDeprecatedScopes;
    }

    @NonNull
    public String toString() {
        return "FindDeprecatedUses(typePattern=" + this.getTypePattern() + ", matchInherited=" + this.getMatchInherited() + ", ignoreDeprecatedScopes=" + this.getIgnoreDeprecatedScopes() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDeprecatedUses)) {
            return false;
        }
        FindDeprecatedUses other = (FindDeprecatedUses)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchInherited = this.getMatchInherited();
        Boolean other$matchInherited = other.getMatchInherited();
        if (this$matchInherited == null ? other$matchInherited != null : !((Object)this$matchInherited).equals(other$matchInherited)) {
            return false;
        }
        Boolean this$ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        Boolean other$ignoreDeprecatedScopes = other.getIgnoreDeprecatedScopes();
        if (this$ignoreDeprecatedScopes == null ? other$ignoreDeprecatedScopes != null : !((Object)this$ignoreDeprecatedScopes).equals(other$ignoreDeprecatedScopes)) {
            return false;
        }
        String this$typePattern = this.getTypePattern();
        String other$typePattern = other.getTypePattern();
        return !(this$typePattern == null ? other$typePattern != null : !this$typePattern.equals(other$typePattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindDeprecatedUses;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchInherited = this.getMatchInherited();
        result = result * 59 + ($matchInherited == null ? 43 : ((Object)$matchInherited).hashCode());
        Boolean $ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        result = result * 59 + ($ignoreDeprecatedScopes == null ? 43 : ((Object)$ignoreDeprecatedScopes).hashCode());
        String $typePattern = this.getTypePattern();
        result = result * 59 + ($typePattern == null ? 43 : $typePattern.hashCode());
        return result;
    }
}

