/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class UseStaticImport
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="java.util.Collections emptyList()")
    private final String methodPattern;

    public String getDisplayName() {
        return "Use static import";
    }

    public String getDescription() {
        return "Removes unnecessary receiver types from static method invocations. For example, `Collections.emptyList()` becomes `emptyList()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesMethod(this.methodPattern), (TreeVisitor)new UseStaticImportVisitor());
    }

    @NonNull
    public String toString() {
        return "UseStaticImport(methodPattern=" + this.getMethodPattern() + ")";
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public UseStaticImport(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseStaticImport)) {
            return false;
        }
        UseStaticImport other = (UseStaticImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UseStaticImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }

    private class UseStaticImportVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private UseStaticImportVisitor() {
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m;
            MethodMatcher methodMatcher = new MethodMatcher(UseStaticImport.this.methodPattern);
            if (methodMatcher.matches((MethodCall)(m = super.visitMethodInvocation(method, ctx)))) {
                if (((J.MethodInvocation)m).getMethodType() != null) {
                    JavaType.FullyQualified receiverType = ((J.MethodInvocation)m).getMethodType().getDeclaringType();
                    this.maybeRemoveImport(receiverType);
                    AddImport addStatic = new AddImport(receiverType.getFullyQualifiedName(), ((J.MethodInvocation)m).getSimpleName(), false);
                    if (!this.getAfterVisit().contains((Object)addStatic)) {
                        this.doAfterVisit(addStatic);
                    }
                }
                if (((J.MethodInvocation)m).getSelect() != null) {
                    m = ((J.MethodInvocation)m).withSelect(null).withName(((J.MethodInvocation)m).getName().withPrefix(((J.MethodInvocation)m).getSelect().getPrefix()));
                }
            }
            return m;
        }
    }
}

