/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class FindInheritedFields {
    private FindInheritedFields() {
    }

    public static Set<JavaType.Variable> find(J j, String clazz) {
        HashSet<JavaType.Variable> fields = new HashSet<JavaType.Variable>();
        new FindInheritedFieldsVisitor(clazz).visit(j, fields);
        return fields;
    }

    private static class FindInheritedFieldsVisitor
    extends JavaIsoVisitor<Set<JavaType.Variable>> {
        private final String fullyQualifiedName;

        public FindInheritedFieldsVisitor(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        private Set<JavaType.Variable> superFields(@Nullable JavaType.FullyQualified type) {
            if (type == null || type.getSupertype() == null) {
                return Collections.emptySet();
            }
            HashSet<JavaType.Variable> types = new HashSet<JavaType.Variable>();
            type.getMembers().stream().filter(m -> !m.hasFlags(Flag.Private) && TypeUtils.hasElementType(m.getType(), this.fullyQualifiedName)).forEach(types::add);
            types.addAll(this.superFields(type.getSupertype()));
            return types;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Set<JavaType.Variable> ctx) {
            ctx.addAll(this.superFields(classDecl.getType() == null ? null : classDecl.getType().getSupertype()));
            return super.visitClassDeclaration(classDecl, ctx);
        }
    }
}

