/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class AnnotationTemplateGenerator {
    private static final String TEMPLATE_COMMENT = "__TEMPLATE__";
    private final Set<String> imports;

    public String template(Cursor cursor, String template) {
        return (String)Timer.builder((String)"rewrite.template.generate.statement").register((MeterRegistry)Metrics.globalRegistry).record(() -> {
            StringBuilder before = new StringBuilder();
            StringBuilder after = new StringBuilder();
            this.template(this.next(cursor), (J)cursor.getValue(), before, after);
            J j = (J)cursor.getValue();
            if (j instanceof J.MethodDeclaration) {
                after.insert(0, " void $method() {}");
            } else if (j instanceof J.VariableDeclarations) {
                after.insert(0, " int $variable;");
            } else if (j instanceof J.ClassDeclaration) {
                after.insert(0, "static class $Clazz {}");
            }
            if (cursor.getParentOrThrow().getValue() instanceof J.ClassDeclaration && cursor.getParentOrThrow().getParentOrThrow().getValue() instanceof J.CompilationUnit) {
                after.append("class $Template {}");
            }
            return before + "/*" + TEMPLATE_COMMENT + "*/" + template + "\n" + after;
        });
    }

    public List<J.Annotation> listAnnotations(J.CompilationUnit cu) {
        final ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        new JavaIsoVisitor<Integer>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, Integer integer) {
                annotations.add(annotation);
                return annotation;
            }
        }.visit(cu, 0);
        return annotations;
    }

    private void template(Cursor cursor, J prior, StringBuilder before, StringBuilder after) {
        J j = (J)cursor.getValue();
        if (j instanceof J.CompilationUnit) {
            J.CompilationUnit cu = (J.CompilationUnit)j;
            for (J.Import import_ : cu.getImports()) {
                before.insert(0, import_.withPrefix(Space.EMPTY).printTrimmed() + ";\n");
            }
            for (String string : this.imports) {
                before.insert(0, string);
            }
            if (cu.getPackageDeclaration() != null) {
                before.insert(0, cu.getPackageDeclaration().withPrefix(Space.EMPTY).printTrimmed() + ";\n");
            }
            return;
        }
        if (j instanceof J.Block) {
            J parent = (J)this.next(cursor).getValue();
            if (parent instanceof J.ClassDeclaration) {
                this.classDeclaration(before, (J.ClassDeclaration)parent);
                after.append('}');
            } else if (parent instanceof J.MethodDeclaration) {
                J.MethodDeclaration m = (J.MethodDeclaration)parent;
                assert (m.getBody() != null);
                for (Statement statement : m.getBody().getStatements()) {
                    if (statement == prior) break;
                    if (!(statement instanceof J.VariableDeclarations)) continue;
                    before.insert(0, "\n" + this.variable((J.VariableDeclarations)statement) + ";\n");
                }
                if (m.getReturnTypeExpression() != null && !JavaType.Primitive.Void.equals(m.getReturnTypeExpression().getType())) {
                    after.append("return ").append(this.valueOfType(m.getReturnTypeExpression().getType())).append(";\n");
                }
                before.insert(0, m.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY).printTrimmed().trim() + '{');
                after.append('}');
            } else if (parent instanceof J.Block) {
                J.Block b = (J.Block)j;
                for (Statement statement : b.getStatements()) {
                    J.VariableDeclarations v;
                    if (statement == prior) break;
                    if (!(statement instanceof J.VariableDeclarations) || !(v = (J.VariableDeclarations)statement).hasModifier(J.Modifier.Type.Final)) continue;
                    before.insert(0, "\n" + this.variable(v) + ";\n");
                }
                before.insert(0, "{\n");
                if (b.isStatic()) {
                    before.insert(0, "static");
                }
                after.append('}');
            }
        } else if (j instanceof J.VariableDeclarations) {
            J.VariableDeclarations v = (J.VariableDeclarations)j;
            if (v.hasModifier(J.Modifier.Type.Final)) {
                before.insert(0, this.variable((J.VariableDeclarations)j) + '=');
            }
        } else if (j instanceof J.NewClass) {
            J.NewClass n = (J.NewClass)j;
            n = n.withBody(null).withPrefix(Space.EMPTY);
            before.insert(0, '{');
            before.insert(0, n.printTrimmed().trim());
            after.append("};");
        }
        this.template(this.next(cursor), j, before, after);
    }

    private void classDeclaration(StringBuilder before, J.ClassDeclaration parent) {
        J.ClassDeclaration c = parent;
        for (Statement statement : c.getBody().getStatements()) {
            if (statement instanceof J.VariableDeclarations) {
                J.VariableDeclarations v = (J.VariableDeclarations)statement;
                if (!v.hasModifier(J.Modifier.Type.Final) || !v.hasModifier(J.Modifier.Type.Static)) continue;
                before.insert(0, this.variable((J.VariableDeclarations)statement) + ";\n");
                continue;
            }
            if (!(statement instanceof J.ClassDeclaration)) continue;
            before.insert(0, '}');
            this.classDeclaration(before, (J.ClassDeclaration)statement);
        }
        c = c.withBody(null).withLeadingAnnotations(null).withPrefix(Space.EMPTY);
        before.insert(0, c.printTrimmed().trim() + '{');
    }

    private String variable(J.VariableDeclarations variable) {
        StringBuilder varBuilder = new StringBuilder();
        if (variable.getTypeExpression() != null) {
            for (J.Modifier modifier : variable.getModifiers()) {
                varBuilder.append(modifier.getType().toString().toLowerCase()).append(' ');
            }
            varBuilder.append(variable.getTypeExpression().withPrefix(Space.EMPTY).printTrimmed()).append(' ');
        }
        List<J.VariableDeclarations.NamedVariable> variables = variable.getVariables();
        int variablesSize = variables.size();
        for (int i = 0; i < variablesSize; ++i) {
            J.VariableDeclarations.NamedVariable nv = variables.get(i);
            varBuilder.append(nv.getSimpleName());
            if (i >= variables.size() - 1) continue;
            varBuilder.append(',');
        }
        return varBuilder.toString();
    }

    private String valueOfType(@Nullable JavaType type) {
        JavaType.Primitive primitive = TypeUtils.asPrimitive(type);
        if (primitive != null) {
            switch (primitive) {
                case Boolean: {
                    return "true";
                }
                case Byte: 
                case Char: 
                case Int: 
                case Double: 
                case Float: 
                case Long: 
                case Short: {
                    return "0";
                }
                case String: 
                case Null: {
                    return "null";
                }
            }
            return "";
        }
        return "null";
    }

    private Cursor next(Cursor c) {
        return c.dropParentUntil(J.class::isInstance);
    }

    public AnnotationTemplateGenerator(Set<String> imports) {
        this.imports = imports;
    }
}

